/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import com.jxdinfo.idp.common.entity.location.Location;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.util.TextDiffUtil;
import com.jxdinfo.idp.common.util.docparse.ReadWordUtil;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class Word2WordComparator
extends AbstractComparator<WordInfo, WordInfo> {
    public Word2WordComparator() {
        super(DocumentComparatorEnum.WORD2WORD);
    }

    @Override
    public List<CompareResult> compare(WordInfo reference, WordInfo contrast) {
        List referenceParaInfos = reference.getParaInfos();
        StringBuilder referenceText = new StringBuilder();
        referenceParaInfos.forEach(e -> referenceText.append(e.getText()));
        List contrastParaInfos = contrast.getParaInfos();
        StringBuilder contrastText = new StringBuilder();
        contrastParaInfos.forEach(e -> contrastText.append(e.getText()));
        LinkedList diffs = this.util.diffMain(referenceText.toString(), contrastText.toString());
        return this.getCompareResults(diffs, referenceParaInfos, contrastParaInfos);
    }

    private List<CompareResult> getCompareResults(List<TextDiffUtil.Diff> diffs, List<WordParagraphInfo> reference, List<WordParagraphInfo> contrast) {
        LinkedList<CompareResult> compareResults = new LinkedList<CompareResult>();
        int referenceIndex = 0;
        int contrastIndex = 0;
        WordParagraphInfo referencePara = reference.get(referenceIndex);
        WordParagraphInfo contrastPara = contrast.get(contrastIndex);
        int rTextIndex = 0;
        int cTextIndex = 0;
        int diffIndex = 0;
        CompareResult result = null;
        for (TextDiffUtil.Diff diff : diffs) {
            switch (diff.operation) {
                case EQUAL: {
                    int i;
                    for (i = 0; i < diff.text.length(); ++i) {
                        if (rTextIndex++ >= referencePara.getText().length()) {
                            referencePara = reference.get(++referenceIndex);
                            rTextIndex = 0;
                        }
                        if (cTextIndex++ < contrastPara.getText().length()) continue;
                        contrastPara = contrast.get(++contrastIndex);
                        cTextIndex = 0;
                    }
                    break;
                }
                case DELETE: {
                    int i;
                    result = new CompareResult();
                    compareResults.add(result);
                    result.setReferenceContent(diff.text);
                    result.setRLocation(this.location(diffs, diff, diffIndex));
                    for (i = 0; i < diff.text.length(); ++i) {
                        if (rTextIndex++ < referencePara.getText().length()) continue;
                        referencePara = reference.get(++referenceIndex);
                        rTextIndex = 0;
                    }
                    break;
                }
                case INSERT: {
                    int i;
                    if (result == null) {
                        result = new CompareResult();
                        compareResults.add(result);
                    }
                    result.setCompareContent(diff.text);
                    result.setCLocation(this.location(diffs, diff, diffIndex));
                    for (i = 0; i < diff.text.length(); ++i) {
                        if (cTextIndex++ < contrastPara.getText().length()) continue;
                        contrastPara = contrast.get(++contrastIndex);
                        cTextIndex = 0;
                    }
                    break;
                }
            }
            ++diffIndex;
        }
        return compareResults;
    }

    private Location location(List<TextDiffUtil.Diff> diffs, TextDiffUtil.Diff current, int index) {
        int back;
        Location location = new Location();
        location.setText(current.text);
        int forward = index + 1;
        String prefix = "";
        String suffix = "";
        for (back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL && diffs.get((int)forward).operation != current.operation) continue;
            prefix = diffs.get((int)back).text;
            break;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL || diffs.get((int)back).operation == current.operation) {
                suffix = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        location.setContext(prefix + current.text + suffix);
        location.setTextIndex(Integer.valueOf(prefix.length()));
        return location;
    }

    public static void main(String[] args) throws FileNotFoundException {
        Word2WordComparator comparator = new Word2WordComparator();
        FileInputStream file1 = new FileInputStream("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u6e56\u5dde\u5e02\u4ea7\u4e1a\u6295\u8d44\u53d1\u5c55\u96c6\u56e2\u6709\u9650\u516c\u53f82023\u5e74\u5ea6\u7b2c\u4e8c\u671f\u8d85\u77ed\u671f\u878d\u8d44\u5238\u53d1\u884c\u65b9\u6848\u53ca\u627f\u8bfa\u51fd(1).docx");
        FileInputStream file2 = new FileInputStream("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u6e56\u5dde\u5e02\u4ea7\u4e1a\u6295\u8d44\u53d1\u5c55\u96c6\u56e2\u6709\u9650\u516c\u53f82023\u5e74\u5ea6\u7b2c\u4e8c\u671f\u8d85\u77ed\u671f\u878d\u8d44\u5238\u53d1\u884c\u65b9\u6848\u53ca\u627f\u8bfa\u51fd\u4fee\u6539(1).docx");
        WordInfo wordInfo1 = ReadWordUtil.getWordInfo((InputStream)file1, (String)"\u6e56\u5dde\u5e02\u4ea7\u4e1a\u6295\u8d44\u53d1\u5c55\u96c6\u56e2\u6709\u9650\u516c\u53f82023\u5e74\u5ea6\u7b2c\u4e8c\u671f\u8d85\u77ed\u671f\u878d\u8d44\u5238\u53d1\u884c\u65b9\u6848\u53ca\u627f\u8bfa\u51fd(1).docx");
        WordInfo wordInfo2 = ReadWordUtil.getWordInfo((InputStream)file2, (String)"\u6e56\u5dde\u5e02\u4ea7\u4e1a\u6295\u8d44\u53d1\u5c55\u96c6\u56e2\u6709\u9650\u516c\u53f82023\u5e74\u5ea6\u7b2c\u4e8c\u671f\u8d85\u77ed\u671f\u878d\u8d44\u5238\u53d1\u884c\u65b9\u6848\u53ca\u627f\u8bfa\u51fd\u4fee\u6539(1).docx");
        List<CompareResult> results = comparator.compare(wordInfo1, wordInfo2);
        System.out.println("end");
    }
}

