/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.time;

import com.jxdinfo.idp.common.pdfparser.pojo.MarkPojo;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class DateTimeUtil {
    public static final DateTimeFormatter TIME_FORMAT;
    public static final DateTimeFormatter DATETIME_FORMAT;
    public static final DateTimeFormatter DATE_FORMAT;

    public static LocalDateTime toDateTime(Instant a) {
        return LocalDateTime.ofInstant(a, ZoneId.systemDefault());
    }

    public static LocalTime parseTime(String a) {
        return DateTimeUtil.parseTime(a, TIME_FORMAT);
    }

    public static Date toDate(LocalDateTime a) {
        return Date.from(DateTimeUtil.toInstant(a));
    }

    public static String formatTime(TemporalAccessor a) {
        return TIME_FORMAT.format(a);
    }

    public DateTimeUtil() {
        DateTimeUtil a;
    }

    public static String formatDateTime(TemporalAccessor a) {
        return DATETIME_FORMAT.format(a);
    }

    public static Instant toInstant(LocalDateTime a) {
        return a.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Duration between(Temporal a, Temporal a2) {
        return Duration.between(a, a2);
    }

    public static LocalDate parseDate(String a, DateTimeFormatter a2) {
        return LocalDate.parse(a, a2);
    }

    public static String format(TemporalAccessor a, String a2) {
        return DateTimeFormatter.ofPattern(a2).format(a);
    }

    public static long toLong(LocalDateTime a) {
        return DateTimeUtil.toInstant(a).toEpochMilli();
    }

    public static String formatDate(TemporalAccessor a) {
        return DATE_FORMAT.format(a);
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime parseDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        void a;
        String a2;
        return LocalDateTime.parse(a2, (DateTimeFormatter)a);
    }

    public static LocalTime parseTime(String a, String a2) {
        a2 = DateTimeFormatter.ofPattern((String)a2);
        return DateTimeUtil.parseTime(a, (DateTimeFormatter)a2);
    }

    public static LocalDateTime parseDateTime(String a, String a2) {
        a2 = DateTimeFormatter.ofPattern((String)a2);
        return DateTimeUtil.parseDateTime(a, (DateTimeFormatter)a2);
    }

    public static LocalTime parseTime(String a, DateTimeFormatter a2) {
        return LocalTime.parse(a, a2);
    }

    public static LocalDateTime toDateTime(long a) {
        return DateTimeUtil.toDateTime(Instant.ofEpochMilli(a));
    }

    public static LocalDate parseDate(String a) {
        return DateTimeUtil.parseDate(a, DATE_FORMAT);
    }

    public static LocalDateTime parseDateTime(String a) {
        return DateTimeUtil.parseDateTime(a, DATETIME_FORMAT);
    }

    public static LocalDate parseDate(String a, String a2) {
        a2 = DateTimeFormatter.ofPattern((String)a2);
        return DateTimeUtil.parseDate(a, (DateTimeFormatter)a2);
    }

    static {
        DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        TIME_FORMAT = DateTimeFormatter.ofPattern(MarkPojo.boolean("j\u0006\u0018#OtQ="));
    }

    public static Period between(LocalDate a, LocalDate a2) {
        return Period.between(a, a2);
    }
}

