 import sys

import fitz
import math


def remove_watermark_from_pdf(pdf_path, output_pdf_path):
    doc = fitz.open(pdf_path)
    for page_num in range(len(doc)):
        page = doc.load_page(page_num)
        block_text = page.get_text("blocks")
        sy = {}
        for block in page.get_text("dict")["blocks"]:
            lines = block.get("lines")
            if lines is None:
                continue

            for line in lines:
                spans = line.get("spans")
                if spans is None:
                    continue
                for span in spans:
                    bbox = span["bbox"]
                    text = str(span["text"])
                    width = bbox[2] - bbox[0]
                    height = bbox[3] - bbox[1]

                    if width != 0:
                        angle = math.degrees(math.atan(height / width))
                    else:
                        angle = 90.0

                    if angle > 30:
                        if sy.get(text.replace(' ', '').replace("\n","").replace('\r', '')):
                            sy[text.replace(' ', '').replace("\n","").replace('\r', '')].add(span['bbox'])
                        else:
                            sy[text.replace(' ', '').replace("\n","").replace('\r', '')] = {span['bbox']}

        for b_i, block in enumerate(block_text):
            if sy.get(str(block[4]).replace(' ', '').replace('\n', '').replace('\r', '')):
                for span in sy[str(block[4]).replace(' ', '').replace('\n', '').replace('\r', '')]:
                    page.add_redact_annot(span)
                    page.apply_redactions()

    doc.save(output_pdf_path)

if __name__ == '__main__':
    pdf_path = sys.argv[1]
    output_pdf_path = sys.argv[2]
    remove_watermark_from_pdf(pdf_path, output_pdf_path)
