/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MatchTextUtil {
    private static final String SPECIAL_CHAR = " |\\s|\r|\n|\t";

    public static boolean isFuzzyMatched(String basic, String text) {
        basic = basic.replaceAll(SPECIAL_CHAR, "");
        text = text.replaceAll(SPECIAL_CHAR, "");
        return text.contains(basic);
    }

    public static List<Object> Match(String regex, Object text) {
        ArrayList<Object> result = new ArrayList<Object>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text.toString());
        if (StringUtils.isEmpty((CharSequence)regex)) {
            result.add(text);
            return result;
        }
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                result.add(matcher.group());
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i <= groupCount; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)matcher.group(i))) continue;
                builder.append(matcher.group(i));
                if (i >= groupCount) continue;
                builder.append("\t");
            }
            if (!StringUtils.isNotEmpty((CharSequence)builder.toString())) continue;
            result.add(builder.toString());
        }
        return result;
    }

    public static List<String> match(String regex, String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)regex)) {
            result.add(text);
            return result;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                result.add(matcher.group());
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i <= groupCount; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)matcher.group(i))) continue;
                builder.append(matcher.group(i));
                if (i >= groupCount) continue;
                builder.append("\t");
            }
            if (!StringUtils.isNotEmpty((CharSequence)builder.toString())) continue;
            result.add(builder.toString());
        }
        return result;
    }

    public static String matchOne(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (StringUtils.isEmpty((CharSequence)regex)) {
            return text;
        }
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                return matcher.group();
            }
            return matcher.group(0);
        }
        return "";
    }

    public static Boolean isMatch(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    public static void main(String[] args) {
        List<Object> match = MatchTextUtil.Match("\u542b\u7a0e\u603b\u4ef7[:\uff1a](.*?)\\d\u3001[\\u4e00-\\u9fa5]+[:\uff1a]|\u542b\u7a0e\u603b\u4ef7[:\uff1a](.*)", "\u542b\u7a0e\u603b\u4ef7\uff1a10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
        System.out.println(match);
    }
}

