/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.table;

import lombok.Generated;

public class TableLine {
    public static VerticalLine connectVLine(VerticalLine v1, VerticalLine v2) {
        return new VerticalLine(v1.getX(), Math.min(v1.getYStart(), v2.getYStart()), Math.max(v1.getYEnd(), v2.getYEnd()));
    }

    public static HorizonLine connectHLine(HorizonLine h1, HorizonLine h2) {
        return new HorizonLine(h1.getY(), Math.min(h1.getXStart(), h2.getXStart()), Math.max(h1.getXEnd(), h2.getXEnd()));
    }

    public static class HorizonLine
    implements Comparable<HorizonLine> {
        public double y;
        public double xStart;
        public double xEnd;
        public double length;

        public HorizonLine(double y, double xStart, double xEnd) {
            this.y = y;
            this.xStart = xStart;
            this.xEnd = xEnd;
            this.length = xEnd - xStart;
        }

        @Override
        public int compareTo(HorizonLine h) {
            double y = h.getY();
            double xStart = h.getXStart();
            if (this.y > y) {
                return -1;
            }
            if (this.y < y) {
                return 1;
            }
            int comparerResult = Double.compare(this.xStart, xStart);
            if (comparerResult != 0) {
                return comparerResult;
            }
            return Double.compare(this.xStart, xStart);
        }

        public boolean equals(Object obj) {
            HorizonLine v1 = (HorizonLine)obj;
            return v1.getXStart() == this.getXStart() && v1.getXEnd() == this.getXEnd() && v1.getY() == this.getY();
        }

        public int hashCode() {
            return Double.valueOf(this.xStart).hashCode() & Double.valueOf(this.xEnd).hashCode() & Double.valueOf(this.y).hashCode();
        }

        @Generated
        public double getY() {
            return this.y;
        }

        @Generated
        public double getXStart() {
            return this.xStart;
        }

        @Generated
        public double getXEnd() {
            return this.xEnd;
        }

        @Generated
        public double getLength() {
            return this.length;
        }

        @Generated
        public void setY(double y) {
            this.y = y;
        }

        @Generated
        public void setXStart(double xStart) {
            this.xStart = xStart;
        }

        @Generated
        public void setXEnd(double xEnd) {
            this.xEnd = xEnd;
        }

        @Generated
        public void setLength(double length) {
            this.length = length;
        }

        @Generated
        public String toString() {
            return "TableLine.HorizonLine(y=" + this.getY() + ", xStart=" + this.getXStart() + ", xEnd=" + this.getXEnd() + ", length=" + this.getLength() + ")";
        }

        @Generated
        public HorizonLine() {
        }
    }

    public static class VerticalLine
    implements Comparable<VerticalLine> {
        public double x;
        public double yStart;
        public double yEnd;
        public double length;

        public VerticalLine(double x, double yStart, double yEnd) {
            this.x = x;
            this.yStart = yStart;
            this.yEnd = yEnd;
            this.length = yEnd - yStart;
        }

        @Override
        public int compareTo(VerticalLine v) {
            double x = v.getX();
            double yStart = v.getYStart();
            if (this.x < x) {
                return -1;
            }
            if (this.x > x) {
                return 1;
            }
            if (yStart > this.yStart) {
                return -1;
            }
            if (yStart < this.getYStart()) {
                return 1;
            }
            return -Double.compare(v.yEnd, this.yEnd);
        }

        public boolean equals(Object obj) {
            VerticalLine v1 = (VerticalLine)obj;
            return v1.getX() == this.getX() && v1.getYEnd() == this.getYEnd() && v1.getYStart() == this.getYStart();
        }

        public int hashCode() {
            return Double.valueOf(this.x).hashCode() & Double.valueOf(this.yEnd).hashCode() & Double.valueOf(this.yStart).hashCode();
        }

        @Generated
        public double getX() {
            return this.x;
        }

        @Generated
        public double getYStart() {
            return this.yStart;
        }

        @Generated
        public double getYEnd() {
            return this.yEnd;
        }

        @Generated
        public double getLength() {
            return this.length;
        }

        @Generated
        public void setX(double x) {
            this.x = x;
        }

        @Generated
        public void setYStart(double yStart) {
            this.yStart = yStart;
        }

        @Generated
        public void setYEnd(double yEnd) {
            this.yEnd = yEnd;
        }

        @Generated
        public void setLength(double length) {
            this.length = length;
        }

        @Generated
        public String toString() {
            return "TableLine.VerticalLine(x=" + this.getX() + ", yStart=" + this.getYStart() + ", yEnd=" + this.getYEnd() + ", length=" + this.getLength() + ")";
        }

        @Generated
        public VerticalLine() {
        }
    }
}

