/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.core;

import com.jxdinfo.idp.common.pdfparser.core.UnTaggedAnalyser;
import com.jxdinfo.idp.common.pdfparser.pojo.Language;
import com.jxdinfo.idp.common.pdfparser.pojo.TextBlock;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.table.CellAnalyser;
import com.jxdinfo.idp.common.pdfparser.table.TableCell;
import com.jxdinfo.idp.common.pdfparser.table.TableInfo;
import com.jxdinfo.idp.common.pdfparser.tools.RenderInfo;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.TextPosition;

public class UnTaggedContext {
    private PDDocument document;
    private Language language;
    private StringBuilder sb = new StringBuilder();
    private TreeMap<Float, Integer> leftXMap = new TreeMap();
    private TreeMap<Float, Integer> rightXMap = new TreeMap((o1, o2) -> Float.compare(o2.floatValue(), o1.floatValue()));
    private Float leftX;
    private Float rightX;
    private int MaxSize = 10;
    private LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> textPagesMap = new LinkedList();
    private List<TextBlock> lastTextPage;
    private LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> firstLineMap = new LinkedList();
    private LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> endLineMap = new LinkedList();
    private float totalLineSpace;
    private float totalLineSpaceCount;
    private boolean[] titleLevels = null;
    private Map<Float, Integer> fontSizeMap = new HashMap<Float, Integer>();
    private Float mainFontSize = Float.valueOf(0.0f);
    Map<Float, Integer> lineSpaceMap = new HashMap<Float, Integer>();

    public float getMainLineSpace() {
        int count = 0;
        float mainLineSpace = 0.0f;
        for (Map.Entry<Float, Integer> entry : this.lineSpaceMap.entrySet()) {
            Integer value = entry.getValue();
            if (count < value) {
                mainLineSpace = entry.getKey().floatValue();
                count = value;
                continue;
            }
            if (count != value || !(mainLineSpace > entry.getKey().floatValue())) continue;
            mainLineSpace = entry.getKey().floatValue();
        }
        return mainLineSpace;
    }

    public void preHeat(PDDocument document, Integer pageNum) throws IOException {
        this.document = document;
        int numberOfPages = document.getNumberOfPages();
        int up = Math.min(numberOfPages, pageNum);
        int chineseCount = 0;
        int englishCount = 0;
        for (int i = 1; i <= up; ++i) {
            Tu.Tuple2<Integer, Integer> tokenNums = this.preHeat(i);
            chineseCount += tokenNums.getKey().intValue();
            englishCount += tokenNums.getValue().intValue();
        }
        int count = 0;
        for (Map.Entry<Float, Integer> entry : this.fontSizeMap.entrySet()) {
            Float tmpSize = entry.getKey();
            Integer tmpNum = entry.getValue();
            if (tmpNum <= count) continue;
            this.mainFontSize = tmpSize;
        }
        this.language = englishCount > chineseCount ? Language.ENGLISH : Language.CHINESE;
    }

    private Tu.Tuple2<Integer, Integer> preHeat(Integer p) throws IOException {
        List<Shape> shapes = CellAnalyser.getShapes(this.document, p);
        List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> tableInfos = CellAnalyser.getTableInfos(shapes);
        tableInfos.sort((o1, o2) -> -Double.compare((Double)((Tu.Tuple2)o1.getKey()).getKey(), (Double)((Tu.Tuple2)o2.getKey()).getKey()));
        float maxHeight = this.document.getPage(p - 1).getCropBox().getHeight();
        float maxWidth = this.document.getPage(p - 1).getCropBox().getWidth();
        ArrayList<Tu.Tuple2<Boolean, Rectangle2D>> contentRanges = new ArrayList<Tu.Tuple2<Boolean, Rectangle2D>>();
        ArrayList<Integer> textIndexes = new ArrayList<Integer>();
        Double curPos = 0.0;
        for (int j = 0; j < tableInfos.size(); ++j) {
            Tu.Tuple2<Double, Double> tableHeightRange = tableInfos.get(j).getKey();
            Double start = (double)maxHeight - tableHeightRange.getValue();
            Double end = (double)maxHeight - tableHeightRange.getKey();
            Double h = start - curPos;
            if (h > 0.0) {
                int size = contentRanges.size();
                textIndexes.add(size);
                contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, curPos.floatValue(), maxWidth, h.floatValue() + 2.0f)));
                curPos = end;
            }
            TableInfo tableInfo = tableInfos.get(j).getValue();
            List<TableCell> cells = tableInfo.getCells();
            for (int k = 0; k < cells.size(); ++k) {
                TableCell cell = cells.get(k);
                float xStart = cell.getXStart().floatValue();
                float xEnd = cell.getXEnd().floatValue();
                float width = xEnd - xStart;
                float yStart = cell.getYStart().floatValue();
                float yEnd = cell.getYEnd().floatValue();
                float height = yStart - yEnd;
                contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(false, new Rectangle2D.Float(xStart, maxHeight - yStart, width, height), cell));
            }
        }
        int size = contentRanges.size();
        if (size == 0) {
            textIndexes.add(size);
            contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, 0.0f, maxWidth, maxHeight)));
        } else {
            textIndexes.add(size);
            contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, curPos.floatValue(), maxWidth, maxHeight - curPos.floatValue() + 2.0f)));
        }
        List<Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>> cellTexts = TextTool.grabTextEnhance(this.document, contentRanges, p);
        ArrayList<TextBlock> textBlocks = new ArrayList<TextBlock>();
        int chineseCount = 0;
        int englishCount = 0;
        for (Integer textIndex : textIndexes) {
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> range = cellTexts.get(textIndex).getValue1();
            range = UnTaggedAnalyser.sortAndTrimForRange(range);
            int count = 0;
            block3: for (int i = range.size() - 1; i >= 0; --i) {
                List<Tu.Tuple2<TextPosition, RenderInfo>> line = range.get(i);
                for (Tu.Tuple2<TextPosition, RenderInfo> tu : line) {
                    float fontSize;
                    String unicode = tu.getKey().getUnicode();
                    if (TextTool.isContainChinese(unicode)) {
                        ++chineseCount;
                    }
                    if (TextTool.isContainEnglish(unicode)) {
                        ++englishCount;
                    }
                    if (this.fontSizeMap.containsKey(Float.valueOf(fontSize = tu.getKey().getFontSize()))) {
                        this.fontSizeMap.put(Float.valueOf(fontSize), this.fontSizeMap.get(Float.valueOf(fontSize)) + 1);
                    } else {
                        this.fontSizeMap.put(Float.valueOf(fontSize), 1);
                    }
                    if (++count != 30) continue;
                    continue block3;
                }
            }
            textBlocks.add(new TextBlock(range, textIndex));
        }
        this.addTextPage(textBlocks, p);
        return new Tu.Tuple2<Integer, Integer>(chineseCount, englishCount);
    }

    public List<TextBlock> getLastTextPage() {
        return this.lastTextPage;
    }

    public Float getAvgLineSpace() {
        if (this.totalLineSpaceCount == 0.0f) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        float v = this.totalLineSpace / this.totalLineSpaceCount;
        if (v >= 20.0f || v <= 1.0f) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        return Float.valueOf(v);
    }

    private Integer containsKey(LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> list, Integer pageNum) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getKey().equals(pageNum)) continue;
            return i;
        }
        return -1;
    }

    public void addTextPage(List<TextBlock> textPage, Integer pageNum) {
        Optional first;
        TextBlock textBlock1;
        List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region1;
        Integer index = this.containsKey(this.textPagesMap, pageNum);
        if (index != -1) {
            Tu.Tuple2<Integer, List<TextBlock>> ele = this.textPagesMap.get(index);
            this.textPagesMap.remove(index);
            this.textPagesMap.addLast(ele);
            this.lastTextPage = textPage;
            return;
        }
        if (textPage.size() == 0) {
            return;
        }
        if (this.textPagesMap.size() == this.MaxSize) {
            this.textPagesMap.removeFirst();
        }
        this.textPagesMap.addLast(new Tu.Tuple2<Integer, List<TextBlock>>(pageNum, textPage));
        TextBlock textBlock = textPage.get(0);
        List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region = textBlock.getRegion();
        if (!CollectionUtils.isEmpty(region)) {
            List<Tu.Tuple2<TextPosition, RenderInfo>> line = region.get(0);
            if (this.firstLineMap.size() == this.MaxSize) {
                this.firstLineMap.removeFirst();
            }
            this.firstLineMap.addLast(line);
        }
        if (!CollectionUtils.isEmpty(region1 = (textBlock1 = textPage.get(textPage.size() - 1)).getRegion())) {
            Iterator<Map.Entry<Float, Integer>> line = region1.get(region1.size() - 1);
            if (this.endLineMap.size() == this.MaxSize) {
                this.endLineMap.removeFirst();
            }
            this.endLineMap.addLast((List<Tu.Tuple2<TextPosition, RenderInfo>>)((Object)line));
        }
        for (TextBlock textBlock2 : textPage) {
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> rg = textBlock2.getRegion();
            if (rg.size() <= 1) continue;
            for (int i = 0; i < rg.size() - 1; ++i) {
                List<Tu.Tuple2<TextPosition, RenderInfo>> line = rg.get(i);
                List<Tu.Tuple2<TextPosition, RenderInfo>> nextLine = rg.get(i + 1);
                if (UnTaggedAnalyser.verifyBlankLine(line) || UnTaggedAnalyser.verifyBlankLine(nextLine)) continue;
                float y = line.get(0).getKey().getY();
                float y1 = nextLine.get(0).getKey().getY();
                float fontHeight = line.get(0).getKey().getHeight();
                this.lineSpaceMap.merge(Float.valueOf(y1 - y - -fontHeight), 1, Integer::sum);
            }
        }
        textPage.stream().forEach(x -> {
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> rg = x.getRegion();
            rg.stream().forEach(y -> {
                TextPosition firstWord = null;
                for (Tu.Tuple2 tu2 : y) {
                    TextPosition tu2Key = (TextPosition)tu2.getKey();
                    if (!StringUtils.isNotBlank((String)tu2Key.getUnicode())) continue;
                    firstWord = tu2Key;
                    break;
                }
                if (firstWord != null) {
                    if (this.leftXMap.containsKey(Float.valueOf(firstWord.getX()))) {
                        this.leftXMap.put(Float.valueOf(firstWord.getX()), this.leftXMap.get(Float.valueOf(firstWord.getX())) + 1);
                    } else {
                        this.leftXMap.put(Float.valueOf(firstWord.getX()), 1);
                    }
                }
                TextPosition lastWord = null;
                for (int i = y.size() - 1; i > 0; --i) {
                    Tu.Tuple2 tuple2 = (Tu.Tuple2)y.get(i);
                    TextPosition textPosition = (TextPosition)tuple2.getKey();
                    if (!StringUtils.isNotBlank((String)textPosition.getUnicode())) continue;
                    lastWord = textPosition;
                    break;
                }
                if (lastWord != null) {
                    float v = lastWord.getX() + ((TextPosition)((Tu.Tuple2)y.get(y.size() - 1)).getKey()).getWidth();
                    if (this.rightXMap.containsKey(Float.valueOf(v))) {
                        this.rightXMap.put(Float.valueOf(v), this.rightXMap.get(Float.valueOf(v)) + 1);
                    } else {
                        this.rightXMap.put(Float.valueOf(v), 1);
                    }
                }
            });
        });
        for (Map.Entry<Float, Integer> entry : this.leftXMap.entrySet()) {
            if (entry.getValue() < 3 || entry.getKey().floatValue() == Float.MAX_VALUE) continue;
            this.leftX = entry.getKey();
            break;
        }
        if (this.leftX == null) {
            first = this.leftXMap.entrySet().stream().findFirst();
            first.ifPresent(floatIntegerEntry -> {
                this.leftX = (Float)floatIntegerEntry.getKey();
            });
        }
        for (Map.Entry entry : this.rightXMap.entrySet()) {
            if ((Integer)entry.getValue() < 3 || ((Float)entry.getKey()).floatValue() == 0.0f) continue;
            this.rightX = (Float)entry.getKey();
            break;
        }
        if (this.rightX == null) {
            first = this.rightXMap.entrySet().stream().findFirst();
            first.ifPresent(floatIntegerEntry -> {
                this.rightX = (Float)floatIntegerEntry.getKey();
            });
        }
        this.lastTextPage = textPage;
    }

    @Generated
    public UnTaggedContext() {
    }

    @Generated
    public PDDocument getDocument() {
        return this.document;
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public StringBuilder getSb() {
        return this.sb;
    }

    @Generated
    public TreeMap<Float, Integer> getLeftXMap() {
        return this.leftXMap;
    }

    @Generated
    public TreeMap<Float, Integer> getRightXMap() {
        return this.rightXMap;
    }

    @Generated
    public Float getLeftX() {
        return this.leftX;
    }

    @Generated
    public Float getRightX() {
        return this.rightX;
    }

    @Generated
    public int getMaxSize() {
        return this.MaxSize;
    }

    @Generated
    public LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> getTextPagesMap() {
        return this.textPagesMap;
    }

    @Generated
    public LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> getFirstLineMap() {
        return this.firstLineMap;
    }

    @Generated
    public LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> getEndLineMap() {
        return this.endLineMap;
    }

    @Generated
    public float getTotalLineSpace() {
        return this.totalLineSpace;
    }

    @Generated
    public float getTotalLineSpaceCount() {
        return this.totalLineSpaceCount;
    }

    @Generated
    public boolean[] getTitleLevels() {
        return this.titleLevels;
    }

    @Generated
    public Map<Float, Integer> getFontSizeMap() {
        return this.fontSizeMap;
    }

    @Generated
    public Float getMainFontSize() {
        return this.mainFontSize;
    }

    @Generated
    public Map<Float, Integer> getLineSpaceMap() {
        return this.lineSpaceMap;
    }

    @Generated
    public void setDocument(PDDocument document) {
        this.document = document;
    }

    @Generated
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Generated
    public void setSb(StringBuilder sb) {
        this.sb = sb;
    }

    @Generated
    public void setLeftXMap(TreeMap<Float, Integer> leftXMap) {
        this.leftXMap = leftXMap;
    }

    @Generated
    public void setRightXMap(TreeMap<Float, Integer> rightXMap) {
        this.rightXMap = rightXMap;
    }

    @Generated
    public void setLeftX(Float leftX) {
        this.leftX = leftX;
    }

    @Generated
    public void setRightX(Float rightX) {
        this.rightX = rightX;
    }

    @Generated
    public void setMaxSize(int MaxSize) {
        this.MaxSize = MaxSize;
    }

    @Generated
    public void setTextPagesMap(LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> textPagesMap) {
        this.textPagesMap = textPagesMap;
    }

    @Generated
    public void setLastTextPage(List<TextBlock> lastTextPage) {
        this.lastTextPage = lastTextPage;
    }

    @Generated
    public void setFirstLineMap(LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> firstLineMap) {
        this.firstLineMap = firstLineMap;
    }

    @Generated
    public void setEndLineMap(LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> endLineMap) {
        this.endLineMap = endLineMap;
    }

    @Generated
    public void setTotalLineSpace(float totalLineSpace) {
        this.totalLineSpace = totalLineSpace;
    }

    @Generated
    public void setTotalLineSpaceCount(float totalLineSpaceCount) {
        this.totalLineSpaceCount = totalLineSpaceCount;
    }

    @Generated
    public void setTitleLevels(boolean[] titleLevels) {
        this.titleLevels = titleLevels;
    }

    @Generated
    public void setFontSizeMap(Map<Float, Integer> fontSizeMap) {
        this.fontSizeMap = fontSizeMap;
    }

    @Generated
    public void setMainFontSize(Float mainFontSize) {
        this.mainFontSize = mainFontSize;
    }

    @Generated
    public void setLineSpaceMap(Map<Float, Integer> lineSpaceMap) {
        this.lineSpaceMap = lineSpaceMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnTaggedContext)) {
            return false;
        }
        UnTaggedContext other = (UnTaggedContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (Float.compare(this.getTotalLineSpace(), other.getTotalLineSpace()) != 0) {
            return false;
        }
        if (Float.compare(this.getTotalLineSpaceCount(), other.getTotalLineSpaceCount()) != 0) {
            return false;
        }
        Float this$leftX = this.getLeftX();
        Float other$leftX = other.getLeftX();
        if (this$leftX == null ? other$leftX != null : !((Object)this$leftX).equals(other$leftX)) {
            return false;
        }
        Float this$rightX = this.getRightX();
        Float other$rightX = other.getRightX();
        if (this$rightX == null ? other$rightX != null : !((Object)this$rightX).equals(other$rightX)) {
            return false;
        }
        Float this$mainFontSize = this.getMainFontSize();
        Float other$mainFontSize = other.getMainFontSize();
        if (this$mainFontSize == null ? other$mainFontSize != null : !((Object)this$mainFontSize).equals(other$mainFontSize)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        StringBuilder this$sb = this.getSb();
        StringBuilder other$sb = other.getSb();
        if (this$sb == null ? other$sb != null : !this$sb.equals(other$sb)) {
            return false;
        }
        TreeMap<Float, Integer> this$leftXMap = this.getLeftXMap();
        TreeMap<Float, Integer> other$leftXMap = other.getLeftXMap();
        if (this$leftXMap == null ? other$leftXMap != null : !((Object)this$leftXMap).equals(other$leftXMap)) {
            return false;
        }
        TreeMap<Float, Integer> this$rightXMap = this.getRightXMap();
        TreeMap<Float, Integer> other$rightXMap = other.getRightXMap();
        if (this$rightXMap == null ? other$rightXMap != null : !((Object)this$rightXMap).equals(other$rightXMap)) {
            return false;
        }
        LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> this$textPagesMap = this.getTextPagesMap();
        LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> other$textPagesMap = other.getTextPagesMap();
        if (this$textPagesMap == null ? other$textPagesMap != null : !((Object)this$textPagesMap).equals(other$textPagesMap)) {
            return false;
        }
        List<TextBlock> this$lastTextPage = this.getLastTextPage();
        List<TextBlock> other$lastTextPage = other.getLastTextPage();
        if (this$lastTextPage == null ? other$lastTextPage != null : !((Object)this$lastTextPage).equals(other$lastTextPage)) {
            return false;
        }
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> this$firstLineMap = this.getFirstLineMap();
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> other$firstLineMap = other.getFirstLineMap();
        if (this$firstLineMap == null ? other$firstLineMap != null : !((Object)this$firstLineMap).equals(other$firstLineMap)) {
            return false;
        }
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> this$endLineMap = this.getEndLineMap();
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> other$endLineMap = other.getEndLineMap();
        if (this$endLineMap == null ? other$endLineMap != null : !((Object)this$endLineMap).equals(other$endLineMap)) {
            return false;
        }
        if (!Arrays.equals(this.getTitleLevels(), other.getTitleLevels())) {
            return false;
        }
        Map<Float, Integer> this$fontSizeMap = this.getFontSizeMap();
        Map<Float, Integer> other$fontSizeMap = other.getFontSizeMap();
        if (this$fontSizeMap == null ? other$fontSizeMap != null : !((Object)this$fontSizeMap).equals(other$fontSizeMap)) {
            return false;
        }
        Map<Float, Integer> this$lineSpaceMap = this.getLineSpaceMap();
        Map<Float, Integer> other$lineSpaceMap = other.getLineSpaceMap();
        return !(this$lineSpaceMap == null ? other$lineSpaceMap != null : !((Object)this$lineSpaceMap).equals(other$lineSpaceMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnTaggedContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSize();
        result = result * 59 + Float.floatToIntBits(this.getTotalLineSpace());
        result = result * 59 + Float.floatToIntBits(this.getTotalLineSpaceCount());
        Float $leftX = this.getLeftX();
        result = result * 59 + ($leftX == null ? 43 : ((Object)$leftX).hashCode());
        Float $rightX = this.getRightX();
        result = result * 59 + ($rightX == null ? 43 : ((Object)$rightX).hashCode());
        Float $mainFontSize = this.getMainFontSize();
        result = result * 59 + ($mainFontSize == null ? 43 : ((Object)$mainFontSize).hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        StringBuilder $sb = this.getSb();
        result = result * 59 + ($sb == null ? 43 : $sb.hashCode());
        TreeMap<Float, Integer> $leftXMap = this.getLeftXMap();
        result = result * 59 + ($leftXMap == null ? 43 : ((Object)$leftXMap).hashCode());
        TreeMap<Float, Integer> $rightXMap = this.getRightXMap();
        result = result * 59 + ($rightXMap == null ? 43 : ((Object)$rightXMap).hashCode());
        LinkedList<Tu.Tuple2<Integer, List<TextBlock>>> $textPagesMap = this.getTextPagesMap();
        result = result * 59 + ($textPagesMap == null ? 43 : ((Object)$textPagesMap).hashCode());
        List<TextBlock> $lastTextPage = this.getLastTextPage();
        result = result * 59 + ($lastTextPage == null ? 43 : ((Object)$lastTextPage).hashCode());
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> $firstLineMap = this.getFirstLineMap();
        result = result * 59 + ($firstLineMap == null ? 43 : ((Object)$firstLineMap).hashCode());
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> $endLineMap = this.getEndLineMap();
        result = result * 59 + ($endLineMap == null ? 43 : ((Object)$endLineMap).hashCode());
        result = result * 59 + Arrays.hashCode(this.getTitleLevels());
        Map<Float, Integer> $fontSizeMap = this.getFontSizeMap();
        result = result * 59 + ($fontSizeMap == null ? 43 : ((Object)$fontSizeMap).hashCode());
        Map<Float, Integer> $lineSpaceMap = this.getLineSpaceMap();
        result = result * 59 + ($lineSpaceMap == null ? 43 : ((Object)$lineSpaceMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UnTaggedContext(document=" + this.getDocument() + ", language=" + (Object)((Object)this.getLanguage()) + ", sb=" + this.getSb() + ", leftXMap=" + this.getLeftXMap() + ", rightXMap=" + this.getRightXMap() + ", leftX=" + this.getLeftX() + ", rightX=" + this.getRightX() + ", MaxSize=" + this.getMaxSize() + ", textPagesMap=" + this.getTextPagesMap() + ", lastTextPage=" + this.getLastTextPage() + ", firstLineMap=" + this.getFirstLineMap() + ", endLineMap=" + this.getEndLineMap() + ", totalLineSpace=" + this.getTotalLineSpace() + ", totalLineSpaceCount=" + this.getTotalLineSpaceCount() + ", titleLevels=" + Arrays.toString(this.getTitleLevels()) + ", fontSizeMap=" + this.getFontSizeMap() + ", mainFontSize=" + this.getMainFontSize() + ", lineSpaceMap=" + this.getLineSpaceMap() + ")";
    }
}

