/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.core;

import com.jxdinfo.idp.common.pdfparser.core.ParaStrategy;
import com.jxdinfo.idp.common.pdfparser.core.UnTaggedAnalyser;
import com.jxdinfo.idp.common.pdfparser.core.UnTaggedContext;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.pojo.Language;
import com.jxdinfo.idp.common.pdfparser.pojo.LineStatus;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.tools.RenderInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.TextPosition;

public class BirdViewerBak {
    public static void mergeTableElements(List<ContentPojo.contentElement> outList, PDDocument pdd) throws IOException {
        if (outList.size() == 0) {
            return;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Tu.Tuple2<Integer, ContentPojo.contentElement>> continuousList = new ArrayList<Tu.Tuple2<Integer, ContentPojo.contentElement>>();
        for (int k = 0; k < outList.size() - 1; ++k) {
            int index;
            int i;
            ContentPojo.contentElement contentElement2;
            ContentPojo.contentElement pre = outList.get(k);
            ContentPojo.contentElement post = outList.get(k + 1);
            if (!"table".equals(pre.getElementType()) || !"table".equals(post.getElementType())) continue;
            if (continuousList.size() == 0) {
                if (!BirdViewerBak.ifNeedMerge(pre, post)) continue;
                continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(pre.getPageNumber(), pre));
                continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(post.getPageNumber(), post));
                indexes.add(k);
                indexes.add(k + 1);
                continue;
            }
            if (pre == ((Tu.Tuple2)continuousList.get(continuousList.size() - 1)).getValue()) {
                if (BirdViewerBak.ifNeedMerge(pre, post)) {
                    continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(post.getPageNumber(), post));
                    indexes.add(k + 1);
                    continue;
                }
                contentElement2 = BirdViewerBak.mergeTableElementsInner(continuousList, pdd);
                if (contentElement2 != null) {
                    for (i = indexes.size() - 1; i >= 0; --i) {
                        index = (Integer)indexes.get(i);
                        outList.set(index, null);
                    }
                    outList.set((Integer)indexes.get(0), contentElement2);
                }
                continuousList.clear();
                indexes.clear();
                continue;
            }
            contentElement2 = BirdViewerBak.mergeTableElementsInner(continuousList, pdd);
            if (contentElement2 != null) {
                for (i = indexes.size() - 1; i >= 0; --i) {
                    index = (Integer)indexes.get(i);
                    outList.set(index, null);
                }
                outList.set((Integer)indexes.get(0), contentElement2);
            }
            continuousList.clear();
            indexes.clear();
            if (!BirdViewerBak.ifNeedMerge(pre, post)) continue;
            continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(pre.getPageNumber(), pre));
            continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(post.getPageNumber(), post));
            indexes.add(k);
            indexes.add(k + 1);
        }
        if (continuousList.size() != 0) {
            ContentPojo.contentElement contentElement3 = BirdViewerBak.mergeTableElementsInner(continuousList, pdd);
            if (contentElement3 != null) {
                for (int i = indexes.size() - 1; i >= 0; --i) {
                    int index = (Integer)indexes.get(i);
                    outList.set(index, null);
                }
                outList.set((Integer)indexes.get(0), contentElement3);
            }
            continuousList.clear();
            indexes.clear();
        }
        for (int i = outList.size() - 1; i >= 0; --i) {
            if (outList.get(i) != null) continue;
            outList.remove(i);
        }
    }

    private static ContentPojo.contentElement mergeTableElementsInner(List<Tu.Tuple2<Integer, ContentPojo.contentElement>> continuousList, PDDocument pdd) throws IOException {
        ContentPojo.contentElement firstElement = continuousList.get(0).getValue();
        List<ContentPojo.contentElement.InnerCell> firstCellList = firstElement.getCells();
        for (int i = 1; i < continuousList.size(); ++i) {
            ContentPojo.contentElement.InnerCell cell1 = firstCellList.get(firstCellList.size() - 1);
            int row_index = cell1.getRow_index();
            int tmpRow_index = -1;
            ContentPojo.contentElement element = continuousList.get(i).getValue();
            firstElement.setRow_num(element.getRow_num() + firstElement.getRow_num());
            firstElement.setCol_num(element.getCol_num() + firstElement.getCol_num());
            List<ContentPojo.contentElement.InnerCell> cellList = element.getCells();
            for (ContentPojo.contentElement.InnerCell cell : cellList) {
                if (tmpRow_index == -1 || tmpRow_index != cell.getRow_index()) {
                    tmpRow_index = cell.getRow_index();
                    cell.setRow_index(++row_index);
                    firstCellList.add(cell);
                    continue;
                }
                if (cell.getRow_index() != tmpRow_index) continue;
                cell.setRow_index(row_index);
                firstCellList.add(cell);
            }
        }
        return firstElement;
    }

    private static boolean ifNeedMerge(ContentPojo.contentElement preP, ContentPojo.contentElement p) {
        Integer row_num = preP.getRow_num();
        Integer tmp_row_num = p.getRow_num();
        if (row_num == null || row_num == 0 || tmp_row_num == null || tmp_row_num == 0) {
            return false;
        }
        List<ContentPojo.contentElement.InnerCell> cells = preP.getCells();
        List filterCells = cells.stream().filter(x -> x.getRow_index() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterCells)) {
            return false;
        }
        Float xStart = ((ContentPojo.contentElement.InnerCell)filterCells.get(0)).getXStart();
        float xEnd = ((ContentPojo.contentElement.InnerCell)filterCells.get(filterCells.size() - 1)).getXStart().floatValue() + ((ContentPojo.contentElement.InnerCell)filterCells.get(filterCells.size() - 1)).getWidth().floatValue();
        List<ContentPojo.contentElement.InnerCell> tmpCells = p.getCells();
        List tmpFilterCells = tmpCells.stream().filter(x -> x.getRow_index() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmpFilterCells)) {
            return false;
        }
        Float tmpXStart = ((ContentPojo.contentElement.InnerCell)tmpFilterCells.get(0)).getXStart();
        float tmpXEnd = ((ContentPojo.contentElement.InnerCell)tmpFilterCells.get(tmpFilterCells.size() - 1)).getXStart().floatValue() + ((ContentPojo.contentElement.InnerCell)tmpFilterCells.get(tmpFilterCells.size() - 1)).getWidth().floatValue();
        return !(Math.abs(xStart.floatValue() - tmpXStart.floatValue()) > 2.0f) && !(Math.abs(xEnd - tmpXEnd) > 2.0f);
    }

    private static ContentPojo.contentElement mergePElement(ContentPojo.contentElement lastE, ContentPojo.contentElement firstE) {
        ArrayList<ContentPojo.PdfStyleStruct> newStyleStruct = new ArrayList<ContentPojo.PdfStyleStruct>();
        String lastEText = lastE.getText();
        String firstEText = firstE.getText();
        String finalText = lastEText + "\n" + firstEText;
        newStyleStruct.addAll(lastE.getPdfStyleStructs());
        newStyleStruct.addAll(firstE.getPdfStyleStructs());
        lastE.setText(finalText);
        lastE.setPdfStyleStructs(newStyleStruct);
        return lastE;
    }

    public static void mergePElement(List<List<ContentPojo.contentElement>> docPages, UnTaggedContext unTaggedContext) {
        if (docPages == null || docPages.size() <= 1) {
            return;
        }
        for (int i = 0; i < docPages.size() - 1; ++i) {
            ArrayList<ContentPojo.contentElement> list;
            ContentPojo.contentElement e;
            boolean content1;
            boolean flag10;
            boolean flag8;
            boolean flag7;
            boolean flag3;
            List<ContentPojo.contentElement> curPage = docPages.get(i);
            List<ContentPojo.contentElement> nextPage = docPages.get(i + 1);
            if (CollectionUtils.isEmpty(curPage) || CollectionUtils.isEmpty(nextPage)) {
                return;
            }
            ContentPojo.contentElement lastE = curPage.get(curPage.size() - 1);
            ContentPojo.contentElement firstE = nextPage.get(0);
            String lastEType = lastE.getElementType();
            String firstEType = firstE.getElementType();
            if (!lastEType.equals("text") || !firstEType.equals("text")) continue;
            LineStatus endLineStatus = lastE.getEndLineStatus();
            LineStatus startLineStatus = firstE.getStartLineStatus();
            List<Tu.Tuple2<TextPosition, RenderInfo>> endLine = lastE.getEndLine();
            List<Tu.Tuple2<TextPosition, RenderInfo>> startLine = firstE.getStartLine();
            if (CollectionUtils.isEmpty(endLine) || CollectionUtils.isEmpty(startLine)) continue;
            float deltaLength = Math.min(UnTaggedAnalyser.calAvgDeltaLength(endLine), UnTaggedAnalyser.calAvgDeltaLength(startLine));
            Language language = unTaggedContext.getLanguage();
            if (language == Language.CHINESE) {
                flag3 = ParaStrategy.strategy3(endLine, startLine);
                flag7 = false;
                flag8 = ParaStrategy.strategy8(endLine, startLine, unTaggedContext, deltaLength);
                flag10 = ParaStrategy.strategy10(endLine, unTaggedContext, deltaLength);
                content1 = ParaStrategy.referParaEndByContent1(endLine, unTaggedContext);
                if (flag3 || flag7 || flag8 || flag10 || content1) continue;
                e = BirdViewerBak.mergePElement(lastE, firstE);
                list = new ArrayList<ContentPojo.contentElement>();
                firstE.setText(null);
                list.add(firstE);
                e.setCrossPageList(list);
                curPage.set(curPage.size() - 1, e);
                nextPage.remove(0);
                continue;
            }
            if (language != Language.ENGLISH) continue;
            flag3 = ParaStrategy.strategy3(endLine, startLine);
            flag7 = false;
            flag8 = ParaStrategy.strategy8(endLine, startLine, unTaggedContext, deltaLength);
            flag10 = ParaStrategy.strategy10(endLine, unTaggedContext, deltaLength);
            content1 = ParaStrategy.referParaEndByContent1(endLine, unTaggedContext);
            if (flag3 || flag7 || flag8 || flag10 || content1) continue;
            e = BirdViewerBak.mergePElement(lastE, firstE);
            list = new ArrayList();
            list.add(firstE);
            e.setCrossPageList(list);
            curPage.set(curPage.size() - 1, e);
            nextPage.remove(0);
        }
    }
}

