/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.reflect;

import com.jxdinfo.idp.common.util.reflect.ReflectEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.springframework.beans.BeanUtils;

public class ReflectUtils {
    public static <T> T copyProperties(Object source, Class<T> clazz) {
        try {
            T result = clazz.newInstance();
            BeanUtils.copyProperties((Object)source, result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8f6c\u6362 error!");
        }
    }

    public static Object getFieldValueByName(String fieldName, Object o) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            return field.get(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setValueByMethod(String fieldName, Object obj, Object value) throws RuntimeException {
        Method method = ReflectUtils.getMethod(obj.getClass(), fieldName, ReflectEnum.SET);
        try {
            method.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u53cd\u5c04\u8d4b\u503c\u5931\u8d25");
        }
    }

    public static Object getValueByMethod(String fieldName, Object obj) throws RuntimeException {
        Method method = ReflectUtils.getMethod(obj.getClass(), fieldName, ReflectEnum.GET);
        try {
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u53cd\u5c04\u53d6\u503c\u5931\u8d25");
        }
    }

    public static Method getMethod(Class<?> objectClass, String fieldName, ReflectEnum reflectEnum) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuilder methodName = new StringBuilder();
            methodName.append(reflectEnum.getMethod());
            methodName.append(fieldName.substring(0, 1).toUpperCase(Locale.ROOT));
            methodName.append(fieldName.substring(1));
            return objectClass.getMethod(methodName.toString(), parameterTypes);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("Reflect error!");
        }
    }
}

