/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.core;

import com.jxdinfo.idp.common.pdfparser.core.UnTaggedAnalyser;
import com.jxdinfo.idp.common.pdfparser.core.UnTaggedContext;
import com.jxdinfo.idp.common.pdfparser.pojo.Language;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.tools.RenderInfo;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pdfbox.text.TextPosition;

public class ParaStrategy {
    private static final Pattern CATALOG_PATTERN = Pattern.compile("(.*?)(\\.){3,}\\d+");

    public static boolean strategy1(List<Tu.Tuple2<TextPosition, RenderInfo>> preLine, List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, Float deltaLength) {
        boolean flag1 = false;
        if (preLine.size() != 0) {
            flag1 = UnTaggedAnalyser.compareEndTokenPos(preLine.get(preLine.size() - 1).getKey(), curLine.get(curLine.size() - 1).getKey(), deltaLength.floatValue());
        }
        return flag1;
    }

    public static boolean strategy2(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine, Float deltaLength) {
        boolean flag2 = false;
        if (postLine.size() == 0) {
            flag2 = true;
        } else if (UnTaggedAnalyser.compareFirstTokenPos(curLine.get(0).getKey(), postLine.get(0).getKey(), deltaLength.floatValue())) {
            flag2 = true;
        }
        return flag2;
    }

    public static boolean strategy3(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine) {
        boolean flag3 = false;
        if (postLine.size() == 0) {
            flag3 = true;
        } else if (UnTaggedAnalyser.compareTokenFont(curLine, postLine)) {
            flag3 = true;
        }
        return flag3;
    }

    public static boolean strategyBySignLine(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, UnTaggedContext unTaggedContext, float deltaLength) {
        float currentLeftX;
        if (CollectionUtils.isEmpty(curLine = UnTaggedAnalyser.trimLine(curLine))) {
            return true;
        }
        Float leftX = unTaggedContext.getLeftX();
        return UnTaggedAnalyser.comparePos(leftX, Float.valueOf(currentLeftX = curLine.get(0).getKey().getX()), deltaLength * 20.0f);
    }

    public static boolean strategy4(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine) {
        boolean flag4 = false;
        if (postLine.size() == 0) {
            flag4 = true;
        } else if (UnTaggedAnalyser.compareTokenRender(curLine.get(curLine.size() - 1).getValue(), postLine.get(0).getValue())) {
            flag4 = true;
        }
        return flag4;
    }

    public static boolean strategy5(List<Tu.Tuple2<TextPosition, RenderInfo>> preLine, List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine, UnTaggedContext unTaggedContext, float deltaLength) {
        boolean flag5 = false;
        float leftX = unTaggedContext.getLeftX().floatValue();
        if (postLine.size() != 0) {
            float x = curLine.get(0).getKey().getX();
            if (UnTaggedAnalyser.comparePos(Float.valueOf(leftX), Float.valueOf(x), deltaLength) && UnTaggedAnalyser.comparePos(Float.valueOf(leftX), Float.valueOf(postLine.get(0).getKey().getX()), deltaLength) && preLine.size() != 0) {
                float preX = preLine.get(0).getKey().getX();
                if (!UnTaggedAnalyser.comparePos(Float.valueOf(leftX), Float.valueOf(preX), deltaLength) && !UnTaggedAnalyser.compareTokenFont(preLine, curLine)) {
                    flag5 = true;
                }
            }
        }
        return flag5;
    }

    public static boolean strategy6(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, UnTaggedContext unTaggedContext, float deltaLength) {
        boolean flag6 = false;
        float rightX = unTaggedContext.getRightX().floatValue();
        float x = curLine.get(curLine.size() - 1).getKey().getX() + curLine.get(curLine.size() - 1).getKey().getWidth();
        if (UnTaggedAnalyser.comparePos(Float.valueOf(x), Float.valueOf(rightX), deltaLength)) {
            flag6 = true;
        }
        return flag6;
    }

    public static boolean strategy11(List<Tu.Tuple2<TextPosition, RenderInfo>> preLine, List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine, UnTaggedContext unTaggedContext, float deltaLength) {
        boolean flag11 = false;
        Float leftX = unTaggedContext.getLeftX();
        Float rightX = unTaggedContext.getRightX();
        if (curLine.size() == 0 || postLine.size() == 0) {
            flag11 = true;
        } else if (preLine.size() != 0) {
            float curX = curLine.get(0).getKey().getX();
            float postX = postLine.get(0).getKey().getX();
            float preX = preLine.get(preLine.size() - 1).getKey().getX() + preLine.get(preLine.size() - 1).getKey().getWidth();
            if (!UnTaggedAnalyser.comparePos(leftX, Float.valueOf(curX), deltaLength) && UnTaggedAnalyser.comparePos(leftX, Float.valueOf(postX), deltaLength) && !UnTaggedAnalyser.comparePos(Float.valueOf(preX), rightX, deltaLength)) {
                flag11 = true;
            }
        }
        return flag11;
    }

    public static boolean strategy7(List<Tu.Tuple2<TextPosition, RenderInfo>> preLine, List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, UnTaggedContext unTaggedContext, float deltaLength) {
        boolean flag7 = false;
        if (!CollectionUtils.isEmpty(preLine) && !CollectionUtils.isEmpty(curLine)) {
            float preLinePos = preLine.get(preLine.size() - 1).getKey().getX() + preLine.get(preLine.size() - 1).getKey().getWidth();
            float postLinePos = curLine.get(curLine.size() - 1).getKey().getX() + curLine.get(curLine.size() - 1).getKey().getWidth();
            Float rightX = unTaggedContext.getRightX();
            if (postLinePos < preLinePos && UnTaggedAnalyser.comparePos(Float.valueOf(postLinePos), rightX, deltaLength * 3.0f)) {
                flag7 = true;
            }
        }
        return flag7;
    }

    public static boolean strategy8(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine, UnTaggedContext unTaggedContext, float deltaLength) {
        boolean flag8 = false;
        curLine = UnTaggedAnalyser.trimLine(curLine);
        postLine = UnTaggedAnalyser.trimLine(postLine);
        if (CollectionUtils.isEmpty(curLine)) {
            return true;
        }
        if (CollectionUtils.isEmpty(postLine)) {
            return true;
        }
        Float rightX = unTaggedContext.getRightX();
        if (UnTaggedAnalyser.isTitle(postLine)) {
            return true;
        }
        if (curLine.get(curLine.size() - 1).getKey().getUnicode().matches("[.;\u3002]") && UnTaggedAnalyser.comparePos(Float.valueOf(curLine.get(curLine.size() - 1).getKey().getX() + curLine.get(curLine.size() - 1).getKey().getWidth()), rightX, deltaLength)) {
            return true;
        }
        return flag8;
    }

    public static boolean strategy9(List<Tu.Tuple2<TextPosition, RenderInfo>> preLine, List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine, UnTaggedContext unTaggedContext) {
        float mainLineSize;
        float postSpace;
        ArrayList<String> stopChars = new ArrayList<String>();
        stopChars.add(",");
        stopChars.add("\uff0c");
        stopChars.add("\u3001");
        boolean flag9 = false;
        if (!CollectionUtils.isEmpty(preLine) && !CollectionUtils.isEmpty(curLine) && !CollectionUtils.isEmpty(postLine) && (postSpace = postLine.get(0).getKey().getY() - curLine.get(0).getKey().getY() - curLine.get(0).getKey().getHeight()) > (mainLineSize = unTaggedContext.getMainLineSpace()) && Math.abs(mainLineSize - postSpace) > 2.0f) {
            return true;
        }
        return flag9;
    }

    public static boolean strategy10(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, UnTaggedContext unTaggedContext, float deltaLength) {
        if (CollectionUtils.isEmpty(curLine = UnTaggedAnalyser.trimLine(curLine))) {
            return true;
        }
        Float rightX = unTaggedContext.getRightX();
        float curRightX = curLine.get(curLine.size() - 1).getKey().getX() + curLine.get(curLine.size() - 1).getKey().getWidth();
        return UnTaggedAnalyser.comparePos(Float.valueOf(curRightX), rightX, deltaLength * 6.0f);
    }

    public static boolean firstLineStrategy1(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, List<Tu.Tuple2<TextPosition, RenderInfo>> postLine, Float deltaLength) {
        curLine = UnTaggedAnalyser.trimLine(curLine);
        postLine = UnTaggedAnalyser.trimLine(postLine);
        if (CollectionUtils.isEmpty(curLine) || CollectionUtils.isEmpty(postLine)) {
            return true;
        }
        float curLineRightX = curLine.get(curLine.size() - 1).getKey().getX() + curLine.get(curLine.size() - 1).getKey().getWidth();
        float postLineRightX = postLine.get(postLine.size() - 1).getKey().getX() + postLine.get(postLine.size() - 1).getKey().getWidth();
        if (!UnTaggedAnalyser.comparePos(Float.valueOf(curLineRightX), Float.valueOf(postLineRightX), deltaLength.floatValue()) && !UnTaggedAnalyser.comparePos(Float.valueOf(postLineRightX), Float.valueOf(curLineRightX), deltaLength.floatValue())) {
            boolean b = curLine.get(curLine.size() - 1).getKey().getUnicode().matches("[.;\u3002\uff1b]");
            if (b) {
                return true;
            }
            boolean b1 = UnTaggedAnalyser.compareTokenFont(curLine, postLine);
            return b1;
        }
        if (UnTaggedAnalyser.comparePos(Float.valueOf(postLineRightX), Float.valueOf(curLineRightX), deltaLength.floatValue())) {
            return UnTaggedAnalyser.compareTokenFont(curLine, postLine);
        }
        return true;
    }

    public static boolean lastLineStrategy1(List<Tu.Tuple2<TextPosition, RenderInfo>> curLine, UnTaggedContext unTaggedContext, float deltaLength) {
        float rightX = unTaggedContext.getRightX().floatValue();
        return UnTaggedAnalyser.comparePos(Float.valueOf(curLine.get(curLine.size() - 1).getKey().getX()), Float.valueOf(rightX), deltaLength);
    }

    public static boolean referParaEndByContent1(List<Tu.Tuple2<TextPosition, RenderInfo>> line, UnTaggedContext unTaggedContext) {
        if (CollectionUtils.isEmpty(line = UnTaggedAnalyser.trimLine(line)) || line.size() == 1) {
            return false;
        }
        Tu.Tuple2<TextPosition, RenderInfo> first = line.get(0);
        Tu.Tuple2<TextPosition, RenderInfo> last = line.get(line.size() - 1);
        if (unTaggedContext.getLanguage() == Language.CHINESE) {
            if (!TextTool.isContainChinese(first.getKey().getUnicode()) && !TextTool.isContainEnglish(first.getKey().getUnicode())) {
                if (UnTaggedAnalyser.isTitle(line) && last.getKey().getUnicode().matches("[.;\u3002\uff1b]")) {
                    return true;
                }
                if (!first.getKey().getUnicode().matches("[1-9]+") && last.getKey().getUnicode().matches("[.;\u3002\uff1b]")) {
                    return true;
                }
                String str = UnTaggedAnalyser.formLineString(line);
                Matcher matcher = CATALOG_PATTERN.matcher(str);
                if (matcher.matches()) {
                    return true;
                }
            }
        } else if (unTaggedContext.getLanguage() == Language.ENGLISH && last.getKey().getUnicode().matches("[.;\u3002\uff1b]")) {
            return true;
        }
        return false;
    }
}

