/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MatchTextUtil {
    private static final String SPECIAL_CHAR = " |\\s|\r|\n|\t";

    public static boolean matchOld(String basicText, String targetText) {
        targetText = targetText.replaceAll(SPECIAL_CHAR, "");
        basicText = basicText.replaceAll(SPECIAL_CHAR, "");
        return targetText.contains(basicText);
    }

    public static List<Object> matchOld(String regex, Object text) {
        ArrayList<Object> result = new ArrayList<Object>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text.toString());
        if (StringUtils.isEmpty((CharSequence)regex)) {
            result.add(text);
            return result;
        }
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                result.add(matcher.group());
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i <= groupCount; ++i) {
                builder.append(matcher.group(i));
                if (i >= groupCount) continue;
                builder.append("\t");
            }
            if (!StringUtils.isNotEmpty((CharSequence)builder.toString())) continue;
            result.add(builder.toString());
        }
        return result;
    }

    public static List<String> match(String regex, String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)regex)) {
            result.add(text);
            return result;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                result.add(matcher.group());
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i <= groupCount; ++i) {
                builder.append(matcher.group(i));
                if (i >= groupCount) continue;
                builder.append("\t");
            }
            if (!StringUtils.isNotEmpty((CharSequence)builder.toString())) continue;
            result.add(builder.toString());
        }
        return result;
    }

    public static String matchOne(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (StringUtils.isEmpty((CharSequence)regex)) {
            return text;
        }
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                return matcher.group();
            }
            return matcher.group(0);
        }
        return "";
    }

    public static Boolean isMatch(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    public static void main(String[] args) {
        String regex = "\u516c\u53f8\u5730\u5740\uff1a(.*)";
        String text = "\u516c\u53f8\u5730\u5740\uff1a\u6d4e\u5357\u5e02";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            System.out.println(matcher.group());
            String group = matcher.group(1);
            System.out.println(group);
        }
    }
}

