/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util;

import com.jxdinfo.idp.common.util.StringUtils;

public class TextSimilarUtil {
    public static double similarity(String s, String t) {
        if (StringUtils.isEmpty(s) && StringUtils.isEmpty(t)) {
            return 1.0;
        }
        int distance = TextSimilarUtil.levenshteinDistance(s, t);
        int maxLength = Math.max(s.length(), t.length());
        return (double)(maxLength - distance) / (double)maxLength;
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        int m = s.length();
        int n = t.length();
        int[][] d = new int[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                int cost = s.charAt(i - 1) == t.charAt(j - 1) ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
            }
        }
        return d[m][n];
    }
}

