/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.table;

import lombok.Generated;

public class TableLine {
    public static VerticalLine connectVLine(VerticalLine v1, VerticalLine v2) {
        return new VerticalLine(v1.getX(), Math.min(v1.getYStart(), v2.getYStart()), Math.max(v1.getYEnd(), v2.getYEnd()));
    }

    public static HorizonLine connectHLine(HorizonLine h1, HorizonLine h2) {
        return new HorizonLine(h1.getY(), Math.min(h1.getXStart(), h2.getXStart()), Math.max(h1.getXEnd(), h2.getXEnd()));
    }

    public static class HorizonLine
    implements Comparable<HorizonLine> {
        public double y;
        public double xStart;
        public double xEnd;
        public double length;

        public HorizonLine(double y, double xStart, double xEnd) {
            this.y = y;
            this.xStart = xStart;
            this.xEnd = xEnd;
            this.length = xEnd - xStart;
        }

        @Override
        public int compareTo(HorizonLine h) {
            double y = h.getY();
            double xStart = h.getXStart();
            if (this.y > y) {
                return -1;
            }
            if (this.y < y) {
                return 1;
            }
            return Double.compare(this.xStart, xStart);
        }

        @Generated
        public double getY() {
            return this.y;
        }

        @Generated
        public double getXStart() {
            return this.xStart;
        }

        @Generated
        public double getXEnd() {
            return this.xEnd;
        }

        @Generated
        public double getLength() {
            return this.length;
        }

        @Generated
        public void setY(double y) {
            this.y = y;
        }

        @Generated
        public void setXStart(double xStart) {
            this.xStart = xStart;
        }

        @Generated
        public void setXEnd(double xEnd) {
            this.xEnd = xEnd;
        }

        @Generated
        public void setLength(double length) {
            this.length = length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HorizonLine)) {
                return false;
            }
            HorizonLine other = (HorizonLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getY(), other.getY()) != 0) {
                return false;
            }
            if (Double.compare(this.getXStart(), other.getXStart()) != 0) {
                return false;
            }
            if (Double.compare(this.getXEnd(), other.getXEnd()) != 0) {
                return false;
            }
            return Double.compare(this.getLength(), other.getLength()) == 0;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HorizonLine;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $y = Double.doubleToLongBits(this.getY());
            result = result * 59 + (int)($y >>> 32 ^ $y);
            long $xStart = Double.doubleToLongBits(this.getXStart());
            result = result * 59 + (int)($xStart >>> 32 ^ $xStart);
            long $xEnd = Double.doubleToLongBits(this.getXEnd());
            result = result * 59 + (int)($xEnd >>> 32 ^ $xEnd);
            long $length = Double.doubleToLongBits(this.getLength());
            result = result * 59 + (int)($length >>> 32 ^ $length);
            return result;
        }

        @Generated
        public String toString() {
            return "TableLine.HorizonLine(y=" + this.getY() + ", xStart=" + this.getXStart() + ", xEnd=" + this.getXEnd() + ", length=" + this.getLength() + ")";
        }

        @Generated
        public HorizonLine() {
        }
    }

    public static class VerticalLine
    implements Comparable<VerticalLine> {
        public double x;
        public double yStart;
        public double yEnd;
        public double length;

        public VerticalLine(double x, double yStart, double yEnd) {
            this.x = x;
            this.yStart = yStart;
            this.yEnd = yEnd;
            this.length = yEnd - yStart;
        }

        @Override
        public int compareTo(VerticalLine v) {
            double x = v.getX();
            double yStart = v.getYStart();
            if (this.x < x) {
                return -1;
            }
            if (this.x > x) {
                return 1;
            }
            return -Double.compare(yStart, this.yStart);
        }

        @Generated
        public double getX() {
            return this.x;
        }

        @Generated
        public double getYStart() {
            return this.yStart;
        }

        @Generated
        public double getYEnd() {
            return this.yEnd;
        }

        @Generated
        public double getLength() {
            return this.length;
        }

        @Generated
        public void setX(double x) {
            this.x = x;
        }

        @Generated
        public void setYStart(double yStart) {
            this.yStart = yStart;
        }

        @Generated
        public void setYEnd(double yEnd) {
            this.yEnd = yEnd;
        }

        @Generated
        public void setLength(double length) {
            this.length = length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerticalLine)) {
                return false;
            }
            VerticalLine other = (VerticalLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            if (Double.compare(this.getYStart(), other.getYStart()) != 0) {
                return false;
            }
            if (Double.compare(this.getYEnd(), other.getYEnd()) != 0) {
                return false;
            }
            return Double.compare(this.getLength(), other.getLength()) == 0;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerticalLine;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $x = Double.doubleToLongBits(this.getX());
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $yStart = Double.doubleToLongBits(this.getYStart());
            result = result * 59 + (int)($yStart >>> 32 ^ $yStart);
            long $yEnd = Double.doubleToLongBits(this.getYEnd());
            result = result * 59 + (int)($yEnd >>> 32 ^ $yEnd);
            long $length = Double.doubleToLongBits(this.getLength());
            result = result * 59 + (int)($length >>> 32 ^ $length);
            return result;
        }

        @Generated
        public String toString() {
            return "TableLine.VerticalLine(x=" + this.getX() + ", yStart=" + this.getYStart() + ", yEnd=" + this.getYEnd() + ", length=" + this.getLength() + ")";
        }

        @Generated
        public VerticalLine() {
        }
    }
}

