/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.user.cache;

import com.jxdinfo.idp.common.user.entity.SysRolesVo;
import com.jxdinfo.idp.common.user.entity.SysUsersVo;
import com.jxdinfo.idp.common.user.service.UserLoginService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class IDPUserInfoPool {
    @Resource
    private UserLoginService userLoginService;
    private static UserLoginService userLoginServiceStatic;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    public final Lock readLock = this.readWriteLock.readLock();
    public final Lock writeLock = this.readWriteLock.writeLock();
    private Map<String, SysUsersVo> userInfoMap = new HashMap<String, SysUsersVo>();
    private Map<String, SysRolesVo> roleInfoMap = new HashMap<String, SysRolesVo>();
    private Map<String, Set<String>> roleUserMap = new HashMap<String, Set<String>>();

    @PostConstruct
    public void initAttribute() {
        userLoginServiceStatic = this.userLoginService;
    }

    public void refreshUserInfo() {
        this.writeLock.lock();
        try {
            this.refreshUserInfoMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void refreshUserInfoMap() {
    }

    public SysUsersVo getUserInfo(String userId) {
        return this.userInfoMap.get(userId);
    }

    public static SysUsersVo getUserInfoStatic() {
        return userLoginServiceStatic.getUser();
    }

    public Set<SysRolesVo> getUserRole(String userId) {
        return new HashSet<SysRolesVo>();
    }
}

