/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.tools;

import java.util.Comparator;
import java.util.List;

public class CollectionSort {
    public static <T> void quickSort(List<T> list, int low, int high, Comparator<T> comparator) {
        if (low < high) {
            int pivotIndex = CollectionSort.partition(list, low, high, comparator);
            CollectionSort.quickSort(list, low, pivotIndex - 1, comparator);
            CollectionSort.quickSort(list, pivotIndex + 1, high, comparator);
        }
    }

    private static <T> int partition(List<T> collection, int low, int high, Comparator<T> comparator) {
        T pivot = collection.get(high);
        int i = low - 1;
        for (int j = low; j < high; ++j) {
            if (comparator.compare(collection.get(j), pivot) <= 0) continue;
            CollectionSort.swap(collection, ++i, j);
        }
        CollectionSort.swap(collection, i + 1, high);
        return i + 1;
    }

    private static <T> void swap(List<T> arr, int i, int j) {
        T o = arr.get(i);
        arr.set(i, arr.get(j));
        arr.set(j, o);
    }

    public static <T> void sort(Comparator<T> comparator, List<T> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            boolean swapped = false;
            for (int j = 0; j < list.size() - i - 1; ++j) {
                if (comparator.compare(list.get(j), list.get(j + 1)) <= 0) continue;
                T temp = list.get(j);
                list.set(j, list.get(j + 1));
                list.set(j + 1, temp);
                swapped = true;
            }
            if (!swapped) break;
        }
    }
}

