/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.core;

import com.jxdinfo.idp.common.pdfparser.core.ParaStrategy;
import com.jxdinfo.idp.common.pdfparser.core.UnTaggedContext;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.pojo.Language;
import com.jxdinfo.idp.common.pdfparser.pojo.LineStatus;
import com.jxdinfo.idp.common.pdfparser.pojo.TextBlock;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.table.CellAnalyser;
import com.jxdinfo.idp.common.pdfparser.table.TableCell;
import com.jxdinfo.idp.common.pdfparser.table.TableInfo;
import com.jxdinfo.idp.common.pdfparser.thirdparty.GetImageEngine;
import com.jxdinfo.idp.common.pdfparser.tools.RenderInfo;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import com.jxdinfo.idp.common.util.StringUtils;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.text.TextPosition;

public class UnTaggedAnalyser {
    private static GetImageEngine getImageEngine;

    public static List<ContentPojo.contentElement> parsePagePureText(PDDocument document, Integer p) throws IOException {
        ArrayList<Tu.Tuple2<Boolean, Rectangle2D>> contentRanges = new ArrayList<Tu.Tuple2<Boolean, Rectangle2D>>();
        float maxHeight = document.getPage(p - 1).getCropBox().getHeight();
        float maxWidth = document.getPage(p - 1).getCropBox().getWidth();
        contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, 0.0f, maxWidth, maxHeight)));
        List<Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>> range = TextTool.grabTextEnhance(document, contentRanges, p);
        List<List<Tu.Tuple2<TextPosition, RenderInfo>>> lists = UnTaggedAnalyser.sortAndTrimForRange(range.get(0).getValue1());
        ArrayList<ContentPojo.contentElement> outList = new ArrayList<ContentPojo.contentElement>();
        for (List<Tu.Tuple2<TextPosition, RenderInfo>> list : lists) {
            ContentPojo.contentElement t = new ContentPojo.contentElement();
            ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>> tmpList = new ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>>();
            tmpList.add(list);
            Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>> regionString = UnTaggedAnalyser.formRegionString(tmpList);
            Tu.Tuple4<Float, Float, Float, Float> coor = UnTaggedAnalyser.formRegion(tmpList);
            t.setText(regionString.getKey());
            t.setPdfStyleStructs(regionString.getValue());
            t.setElementType("text");
            t.setPageNumber(p);
            t.setPageHeight(Float.valueOf(maxHeight));
            t.setPageWidth(Float.valueOf(maxWidth));
            if (coor != null) {
                Float xStart = coor.getValue1();
                Float xEnd = coor.getValue2();
                Float yStart = Float.valueOf(maxHeight - coor.getValue3().floatValue());
                Float yEnd = Float.valueOf(maxHeight - coor.getValue4().floatValue());
                t.setXStart(xStart);
                t.setYStart(yStart);
                t.setWidth(Float.valueOf(xEnd.floatValue() - xStart.floatValue()));
                t.setHeight(Float.valueOf(yEnd.floatValue() - yStart.floatValue()));
            }
            outList.add(t);
        }
        return outList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ContentPojo.contentElement> parsePage(PDDocument document, Integer p, UnTaggedContext untaggedContext, String picSavePath, boolean verifyPara) throws IOException {
        Object tableInfo;
        List<Shape> shapes = CellAnalyser.getShapes(document, p);
        List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> tableInfos = CellAnalyser.getTableInfos(shapes);
        tableInfos.sort((o1, o2) -> -Double.compare((Double)((Tu.Tuple2)o1.getKey()).getKey(), (Double)((Tu.Tuple2)o2.getKey()).getKey()));
        float maxHeight = document.getPage(p - 1).getCropBox().getHeight();
        float maxWidth = document.getPage(p - 1).getCropBox().getWidth();
        ArrayList<Tu.Tuple2<Boolean, Rectangle2D>> contentRanges = new ArrayList<Tu.Tuple2<Boolean, Rectangle2D>>();
        ArrayList<Integer> textIndexes = new ArrayList<Integer>();
        Double curPos = 0.0;
        for (int j = 0; j < tableInfos.size(); ++j) {
            Tu.Tuple2<Double, Double> tableHeightRange = tableInfos.get(j).getKey();
            Double start = (double)maxHeight - tableHeightRange.getValue();
            Double end = (double)maxHeight - tableHeightRange.getKey();
            Double h = start - curPos;
            if (h > 0.0) {
                int size = contentRanges.size();
                textIndexes.add(size);
                contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, curPos.floatValue(), maxWidth, h.floatValue() + 2.0f)));
                curPos = end;
            }
            tableInfo = tableInfos.get(j).getValue();
            List<TableCell> cells = ((TableInfo)tableInfo).getCells();
            for (int k = 0; k < cells.size(); ++k) {
                TableCell tableCell = cells.get(k);
                float xStart = tableCell.getXStart().floatValue();
                float f = tableCell.getXEnd().floatValue();
                float width = f - xStart;
                float yStart = tableCell.getYStart().floatValue();
                float yEnd = tableCell.getYEnd().floatValue();
                float height = yStart - yEnd;
                contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(false, new Rectangle2D.Float(xStart, maxHeight - yStart, width, height)));
            }
        }
        int size = contentRanges.size();
        if (size == 0) {
            textIndexes.add(size);
            contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, 0.0f, maxWidth, maxHeight)));
        } else {
            textIndexes.add(size);
            contentRanges.add(new Tu.Tuple2<Boolean, Rectangle2D.Float>(true, new Rectangle2D.Float(0.0f, curPos.floatValue(), maxWidth, maxHeight - curPos.floatValue() + 2.0f)));
        }
        List<Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>> cellTexts = TextTool.grabTextEnhance(document, contentRanges, p);
        HashMap structOutMap = new HashMap();
        int pos = 0;
        for (int j = 0; j < tableInfos.size(); ++j) {
            void var20_32;
            tableInfo = tableInfos.get(j).getValue();
            ArrayList<ContentPojo.contentElement> tableList = new ArrayList<ContentPojo.contentElement>();
            List<TableCell> cells = ((TableInfo)tableInfo).getCells();
            boolean bl = false;
            while (var20_32 < cells.size()) {
                while (textIndexes.contains(pos)) {
                    ++pos;
                }
                cells.get((int)var20_32).setCell(cellTexts.get(pos).getValue2());
                ++pos;
                ++var20_32;
            }
            ContentPojo.contentElement contentElement2 = CellAnalyser.formTable((TableInfo)tableInfo, p);
            contentElement2.setPageHeight(Float.valueOf(maxHeight));
            contentElement2.setPageWidth(Float.valueOf(maxWidth));
            tableList.add(contentElement2);
            structOutMap.put(pos - 1, tableList);
        }
        ArrayList<TextBlock> textBlocks = new ArrayList<TextBlock>();
        for (Integer textIndex : textIndexes) {
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> range = cellTexts.get(textIndex).getValue1();
            range = UnTaggedAnalyser.sortAndTrimForRange(range);
            textBlocks.add(new TextBlock(range, textIndex));
        }
        untaggedContext.addTextPage(textBlocks, p);
        List<Object> lineStatuses = new ArrayList();
        if (verifyPara) {
            lineStatuses = UnTaggedAnalyser.parseTextBlock(untaggedContext);
        } else {
            LineStatus[] tmpLS = new LineStatus[1000];
            Arrays.fill((Object[])tmpLS, (Object)LineStatus.ParaEnd);
            for (TextBlock textBlock : textBlocks) {
                lineStatuses.add(tmpLS);
            }
        }
        ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>> structRegion = new ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>>();
        ArrayList<LineStatus> tmpLineStatuses = new ArrayList<LineStatus>();
        boolean bl = false;
        for (LineStatus[] lineStatusArray : lineStatuses) {
            void var20_37;
            TextBlock textBlock = (TextBlock)textBlocks.get((int)var20_37);
            ++var20_37;
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region = textBlock.getRegion();
            Integer id = textBlock.getId();
            ArrayList<ContentPojo.contentElement> contentElementList = new ArrayList<ContentPojo.contentElement>();
            if (lineStatusArray == null || lineStatusArray.length == 0) continue;
            block12: for (int i = 0; i < lineStatusArray.length; ++i) {
                LineStatus lineStatus = lineStatusArray[i];
                if (region.size() <= i) break;
                switch (lineStatus) {
                    case ParaEnd: {
                        structRegion.add(region.get(i));
                        tmpLineStatuses.add(lineStatus);
                        Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>> regionString = UnTaggedAnalyser.formRegionString(structRegion);
                        Tu.Tuple4<Float, Float, Float, Float> range = UnTaggedAnalyser.formRegion(structRegion);
                        String text = regionString.getKey();
                        if (!text.replaceAll("[\\pZ]", "").trim().equals("")) {
                            ContentPojo.contentElement t = new ContentPojo.contentElement();
                            t.setText(text);
                            t.setPdfStyleStructs(regionString.getValue());
                            t.setElementType("text");
                            t.setPageNumber(p);
                            t.setPageHeight(Float.valueOf(maxHeight));
                            t.setPageWidth(Float.valueOf(maxWidth));
                            if (range != null) {
                                Float xStart = range.getValue1();
                                Float xEnd = range.getValue2();
                                Float yStart = Float.valueOf(maxHeight - range.getValue3().floatValue());
                                Float yEnd = Float.valueOf(maxHeight - range.getValue4().floatValue());
                                t.setXStart(xStart);
                                t.setYStart(yStart);
                                t.setWidth(Float.valueOf(xEnd.floatValue() - xStart.floatValue()));
                                t.setHeight(Float.valueOf(yEnd.floatValue() - yStart.floatValue()));
                            }
                            if (structRegion.size() >= 1) {
                                t.setStartLine((List)structRegion.get(0));
                                t.setStartLineStatus((LineStatus)((Object)tmpLineStatuses.get(0)));
                                t.setEndLine((List)structRegion.get(structRegion.size() - 1));
                                t.setEndLineStatus((LineStatus)((Object)tmpLineStatuses.get(tmpLineStatuses.size() - 1)));
                            }
                            contentElementList.add(t);
                        }
                        structRegion.clear();
                        tmpLineStatuses.clear();
                        continue block12;
                    }
                    case Normal: {
                        structRegion.add(region.get(i));
                        tmpLineStatuses.add(lineStatus);
                        continue block12;
                    }
                }
            }
            if (structRegion.size() != 0) {
                Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>> regionString = UnTaggedAnalyser.formRegionString(structRegion);
                Tu.Tuple4<Float, Float, Float, Float> range = UnTaggedAnalyser.formRegion(structRegion);
                String text = regionString.getKey();
                if (!text.replaceAll("[\\pZ]", "").trim().equals("")) {
                    ContentPojo.contentElement t = new ContentPojo.contentElement();
                    t.setText(regionString.getKey());
                    t.setPdfStyleStructs(regionString.getValue());
                    t.setElementType("text");
                    t.setPageNumber(p);
                    t.setPageHeight(Float.valueOf(maxHeight));
                    t.setPageWidth(Float.valueOf(maxWidth));
                    if (range != null) {
                        Float xStart = range.getValue1();
                        Float xEnd = range.getValue2();
                        Float yStart = Float.valueOf(maxHeight - range.getValue3().floatValue());
                        Float yEnd = Float.valueOf(maxHeight - range.getValue4().floatValue());
                        t.setXStart(xStart);
                        t.setYStart(yStart);
                        t.setWidth(Float.valueOf(xEnd.floatValue() - xStart.floatValue()));
                        t.setHeight(Float.valueOf(yEnd.floatValue() - yStart.floatValue()));
                    }
                    if (structRegion.size() >= 1) {
                        t.setStartLine((List)structRegion.get(0));
                        t.setStartLineStatus((LineStatus)((Object)tmpLineStatuses.get(0)));
                        t.setEndLine((List)structRegion.get(structRegion.size() - 1));
                        t.setEndLineStatus((LineStatus)((Object)tmpLineStatuses.get(tmpLineStatuses.size() - 1)));
                    }
                    contentElementList.add(t);
                }
                structRegion.clear();
                tmpLineStatuses.clear();
            }
            structOutMap.put(id, contentElementList);
        }
        ArrayList<ContentPojo.contentElement> pageContentList = new ArrayList<ContentPojo.contentElement>();
        structOutMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).forEach(x -> pageContentList.addAll((Collection)x.getValue()));
        if (picSavePath == null) {
            return pageContentList;
        }
        if (getImageEngine == null) {
            getImageEngine = new GetImageEngine(picSavePath);
        } else {
            getImageEngine.clearList();
        }
        PDPage pDPage = document.getPages().get(p - 1);
        getImageEngine.processPage(pDPage);
        List<Tu.Tuple2<Integer, Rectangle2D.Float>> pics = getImageEngine.getPics();
        int i = 0;
        if (pics.size() != 0) {
            block13: for (Tu.Tuple2<Integer, Rectangle2D.Float> pic : pics) {
                double yStart = pic.getValue().getY();
                while (true) {
                    if (i == pageContentList.size()) {
                        ContentPojo.contentElement contentElement2 = new ContentPojo.contentElement();
                        contentElement2.setElementType("pic");
                        contentElement2.setText(picSavePath + "/" + pic.getKey() + ".png");
                        contentElement2.setPageNumber(p);
                        pageContentList.add(contentElement2);
                        continue block13;
                    }
                    if (!((double)((ContentPojo.contentElement)pageContentList.get(i)).getYStart().floatValue() > yStart)) break;
                    ++i;
                }
                ContentPojo.contentElement contentElement3 = new ContentPojo.contentElement();
                contentElement3.setElementType("pic");
                contentElement3.setText(picSavePath + "/" + pic.getKey() + ".png");
                contentElement3.setPageNumber(p);
                if (i == 0) {
                    pageContentList.add(0, contentElement3);
                    ++i;
                    continue;
                }
                pageContentList.add(i - 1, contentElement3);
            }
        }
        return pageContentList;
    }

    public static List<LineStatus[]> parseTextBlock(UnTaggedContext untaggedContext) {
        List<TextBlock> blockList = untaggedContext.getLastTextPage();
        ArrayList<LineStatus[]> resultList = new ArrayList<LineStatus[]>();
        int count = 0;
        for (TextBlock textBlock : blockList) {
            boolean b;
            int i;
            ++count;
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region = textBlock.getRegion();
            ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>> newRegion = new ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>>(region);
            if (CollectionUtils.isEmpty(newRegion)) {
                resultList.add(null);
                continue;
            }
            LineStatus[] lineStatuses = new LineStatus[newRegion.size()];
            Arrays.fill((Object[])lineStatuses, (Object)LineStatus.Normal);
            Integer offset = 0;
            if (count == 1 && (i = UnTaggedAnalyser.verifyHeader(untaggedContext, (List)newRegion.get(0))) == 1) {
                lineStatuses[0] = LineStatus.Header;
                newRegion.remove(0);
                offset = 1;
            }
            if (count == blockList.size() && !newRegion.isEmpty() && (b = UnTaggedAnalyser.verifyPagination(untaggedContext, (List)newRegion.get(newRegion.size() - 1)))) {
                lineStatuses[lineStatuses.length - 1] = LineStatus.Footer;
                newRegion.remove(newRegion.size() - 1);
            }
            if (CollectionUtils.isEmpty(newRegion)) {
                resultList.add(lineStatuses);
                continue;
            }
            resultList.add(UnTaggedAnalyser.parseTextBlock(newRegion, lineStatuses, untaggedContext, offset));
        }
        return resultList;
    }

    private static LineStatus[] parseTextBlock(List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region, LineStatus[] lineStatuses, UnTaggedContext unTaggedContext, Integer offset) {
        if (region.size() <= 2) {
            if (region.size() == 1) {
                lineStatuses[0 + offset.intValue()] = LineStatus.ParaEnd;
            } else {
                float rightX = unTaggedContext.getRightX().floatValue();
                float x = region.get(0).get(region.get(0).size() - 1).getKey().getX() + region.get(0).get(region.get(0).size() - 1).getKey().getWidth();
                float deltaLength = UnTaggedAnalyser.calAvgDeltaLength(region.get(0));
                lineStatuses[0 + offset.intValue()] = UnTaggedAnalyser.comparePos(Float.valueOf(x), Float.valueOf(rightX), deltaLength) ? LineStatus.ParaEnd : LineStatus.Normal;
                lineStatuses[1 + offset.intValue()] = LineStatus.ParaEnd;
            }
        } else {
            for (int i = 0; i < region.size() - 2; ++i) {
                boolean flag10;
                boolean flag9;
                boolean flag8;
                boolean flag7;
                boolean flag3;
                List<Tu.Tuple2<TextPosition, RenderInfo>> curLine = region.get(i + 1);
                if (curLine.size() == 0) continue;
                List<Tu.Tuple2<TextPosition, RenderInfo>> preLine = region.get(i);
                List<Tu.Tuple2<TextPosition, RenderInfo>> postLine = region.get(i + 2);
                float deltaLength = 0.0f;
                if (unTaggedContext.getLanguage() == Language.CHINESE) {
                    deltaLength = UnTaggedAnalyser.calAvgDeltaLength(curLine);
                } else if (unTaggedContext.getLanguage() == Language.ENGLISH) {
                    deltaLength = UnTaggedAnalyser.calAvgDeltaLength(curLine) * 4.0f;
                }
                Language language = unTaggedContext.getLanguage();
                if (language == Language.CHINESE) {
                    flag3 = ParaStrategy.strategy3(curLine, postLine);
                    flag7 = false;
                    flag8 = ParaStrategy.strategy8(curLine, postLine, unTaggedContext, deltaLength);
                    flag9 = ParaStrategy.strategy9(preLine, curLine, postLine);
                    flag10 = ParaStrategy.strategy10(curLine, unTaggedContext, deltaLength);
                    boolean flag11 = ParaStrategy.strategy11(preLine, curLine, postLine, unTaggedContext, deltaLength);
                    boolean content1 = ParaStrategy.referParaEndByContent1(curLine, unTaggedContext);
                    if (!flag3 && !flag7 && !flag8 && !flag9 && !flag10 && !flag11 && !content1) continue;
                    lineStatuses[i + 1 + offset.intValue()] = LineStatus.ParaEnd;
                    continue;
                }
                if (language != Language.ENGLISH) continue;
                flag3 = ParaStrategy.strategy3(curLine, postLine);
                flag7 = false;
                flag8 = ParaStrategy.strategy8(curLine, postLine, unTaggedContext, deltaLength);
                flag9 = ParaStrategy.strategy9(preLine, curLine, postLine);
                flag10 = ParaStrategy.strategy10(curLine, unTaggedContext, deltaLength);
                boolean content1 = ParaStrategy.referParaEndByContent1(curLine, unTaggedContext);
                if (!flag3 && !flag7 && !flag8 && !flag9 && !flag10 && !content1) continue;
                lineStatuses[i + 1 + offset.intValue()] = LineStatus.ParaEnd;
            }
            List<Tu.Tuple2<TextPosition, RenderInfo>> first = region.get(0);
            float deltaLength = 0.0f;
            if (unTaggedContext.getLanguage() == Language.CHINESE) {
                deltaLength = UnTaggedAnalyser.calAvgDeltaLength(first);
            } else if (unTaggedContext.getLanguage() == Language.ENGLISH) {
                deltaLength = UnTaggedAnalyser.calAvgDeltaLength(first) * 4.0f;
            }
            if (region.size() == 1) {
                lineStatuses[0 + offset.intValue()] = LineStatus.ParaEnd;
            } else {
                List<Tu.Tuple2<TextPosition, RenderInfo>> second = region.get(0);
                boolean flag3 = ParaStrategy.strategy3(first, second);
                boolean flag8 = ParaStrategy.strategy8(first, second, unTaggedContext, deltaLength);
                boolean flag10 = ParaStrategy.strategy10(first, unTaggedContext, deltaLength);
                boolean content1 = ParaStrategy.referParaEndByContent1(first, unTaggedContext);
                if (flag3 || flag8 || flag10 || content1) {
                    lineStatuses[0 + offset.intValue()] = LineStatus.ParaEnd;
                }
            }
            List<Tu.Tuple2<TextPosition, RenderInfo>> last = region.get(region.size() - 1);
            if (unTaggedContext.getLanguage() == Language.CHINESE) {
                deltaLength = UnTaggedAnalyser.calAvgDeltaLength(first);
            } else if (unTaggedContext.getLanguage() == Language.ENGLISH) {
                deltaLength = UnTaggedAnalyser.calAvgDeltaLength(first) * 4.0f;
            }
            if (ParaStrategy.lastLineStrategy1(last, unTaggedContext, deltaLength) || ParaStrategy.referParaEndByContent1(last, unTaggedContext)) {
                lineStatuses[region.size() - 1 + offset.intValue()] = LineStatus.ParaEnd;
            }
        }
        return lineStatuses;
    }

    public static Map<Integer, Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>>> formBlockString(List<TextBlock> textBlocks) {
        HashMap<Integer, Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>>> map = new HashMap<Integer, Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>>>();
        for (TextBlock tb : textBlocks) {
            Integer id = tb.getId();
            List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region = tb.getRegion();
            Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>> strAndStyle = UnTaggedAnalyser.formRegionString(region);
            map.put(id, strAndStyle);
        }
        return map;
    }

    public static Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>> formRegionString(List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region) {
        ArrayList<ContentPojo.PdfStyleStruct> styleList = new ArrayList<ContentPojo.PdfStyleStruct>();
        StringBuilder sb = new StringBuilder();
        for (List<Tu.Tuple2<TextPosition, RenderInfo>> line : region) {
            UnTaggedAnalyser.formLineString(line, styleList, sb);
        }
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) == '\n') {
            sb.delete(sb.length() - 1, sb.length());
            styleList.remove(styleList.size() - 1);
        }
        return new Tu.Tuple2<String, List<ContentPojo.PdfStyleStruct>>(sb.toString(), styleList);
    }

    private static Tu.Tuple4<Float, Float, Float, Float> formRegion(List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region) {
        if (CollectionUtils.isEmpty(region)) {
            return null;
        }
        float minLeftX = Float.MAX_VALUE;
        float maxRightX = 0.0f;
        float upBound = 0.0f;
        float bottomBound = 0.0f;
        for (int i = 0; i < region.size(); ++i) {
            List<Tu.Tuple2<TextPosition, RenderInfo>> line = region.get(i);
            if (CollectionUtils.isEmpty(line)) continue;
            float leftX = line.get(0).getKey().getX();
            minLeftX = Math.min(minLeftX, leftX);
            float rightX = line.get(line.size() - 1).getKey().getX() + line.get(line.size() - 1).getKey().getWidth();
            maxRightX = Math.max(maxRightX, rightX);
            if (i == 0) {
                Tu.Tuple2<TextPosition, RenderInfo> tu = line.get(0);
                upBound = tu.getKey().getY() - tu.getKey().getHeight();
            }
            if (i != region.size() - 1) continue;
            Tu.Tuple2<TextPosition, RenderInfo> tu = line.get(0);
            bottomBound = tu.getKey().getY();
        }
        if (minLeftX == Float.MAX_VALUE || maxRightX == 0.0f || upBound == 0.0f || bottomBound == 0.0f) {
            return null;
        }
        return new Tu.Tuple4<Float, Float, Float, Float>(Float.valueOf(minLeftX), Float.valueOf(maxRightX), Float.valueOf(bottomBound), Float.valueOf(upBound));
    }

    public static boolean isTitle(List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        String str = UnTaggedAnalyser.formLineString(line);
        if (str.matches("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,3}[\u3001.\uff0e][\\s\\S]*")) {
            return true;
        }
        if (str.matches("[(\uff08][\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,3}[)\uff09][\u3001.\uff0e]?[\\s\\S]*")) {
            return true;
        }
        if (str.matches("[1-9]{1,3}[.,\u3001\uff0c\uff0e][\\s\\S]*")) {
            return true;
        }
        if (str.matches("[1-9]{1,3}[.][1-9]{1,3}[\\s\\S]*")) {
            return true;
        }
        if (str.matches("[(\uff08]?[1-9]{1,2}[)\uff09][\u3001.\uff0e]?[\\s\\S]*")) {
            return true;
        }
        return str.matches("[\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467\u2468\u2469][\\s\\S]*");
    }

    public static String formLineString(List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        if (CollectionUtils.isEmpty(line)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Tu.Tuple2<TextPosition, RenderInfo> tu : line) {
            TextPosition tp = tu.getKey();
            sb.append(tp.getUnicode());
        }
        return sb.toString();
    }

    public static void formLineString(List<Tu.Tuple2<TextPosition, RenderInfo>> line, List<ContentPojo.PdfStyleStruct> styleList, StringBuilder sb) {
        for (Tu.Tuple2<TextPosition, RenderInfo> tu : line) {
            ContentPojo.PdfStyleStruct pdfStyleStruct = new ContentPojo.PdfStyleStruct();
            TextPosition tp = tu.getKey();
            RenderInfo ri = tu.getValue();
            pdfStyleStruct.setText(tp.getUnicode());
            sb.append(tp.getUnicode());
            if (ri != null) {
                pdfStyleStruct.setLineWidth(ri.getLineWidth());
                pdfStyleStruct.setRenderingMode(ri.getRenderingMode().toString());
            }
            pdfStyleStruct.setRotation(tp.getRotation());
            pdfStyleStruct.setX(Float.valueOf(tp.getX()));
            pdfStyleStruct.setY(Float.valueOf(tp.getY()));
            pdfStyleStruct.setWidth(Float.valueOf(tp.getWidth()));
            pdfStyleStruct.setHeight(Float.valueOf(tp.getHeight()));
            pdfStyleStruct.setFontSize(Float.valueOf(tp.getFontSize()));
            pdfStyleStruct.setFontSizePt(Float.valueOf(tp.getFontSizeInPt()));
            if (tp.getFont() != null) {
                PDFontDescriptor fontDescriptor = tp.getFont().getFontDescriptor();
                if (fontDescriptor != null) {
                    pdfStyleStruct.setFontName(fontDescriptor.getFontName());
                }
                if (fontDescriptor != null) {
                    pdfStyleStruct.setFontWeight(Float.valueOf(fontDescriptor.getFontWeight()));
                }
                if (fontDescriptor != null) {
                    pdfStyleStruct.setCharSet(fontDescriptor.getCharSet());
                }
            }
            styleList.add(pdfStyleStruct);
        }
        sb.append("\n");
        styleList.add(null);
    }

    public static List<List<Tu.Tuple2<TextPosition, RenderInfo>>> sortAndTrimForRange(List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region) {
        return UnTaggedAnalyser.trimRange(UnTaggedAnalyser.sortForRange(region));
    }

    public static List<List<Tu.Tuple2<TextPosition, RenderInfo>>> sortForRange(List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region) {
        return region.stream().sorted((o1, o2) -> {
            Tu.Tuple2 p1 = (Tu.Tuple2)o1.get(0);
            Tu.Tuple2 p2 = (Tu.Tuple2)o2.get(0);
            TextPosition t1 = (TextPosition)p1.getKey();
            TextPosition t2 = (TextPosition)p2.getKey();
            float y1 = t1.getY();
            float y2 = t2.getY();
            return Float.compare(y1, y2);
        }).collect(Collectors.toList());
    }

    public static List<List<Tu.Tuple2<TextPosition, RenderInfo>>> trimRange(List<List<Tu.Tuple2<TextPosition, RenderInfo>>> region) {
        int i;
        int pre;
        if (CollectionUtils.isEmpty(region)) {
            return region;
        }
        int pos = region.size() - 1;
        for (pre = 0; pre != region.size() && UnTaggedAnalyser.verifyBlankLine(region.get(pre)); ++pre) {
        }
        if (pre == region.size()) {
            return new ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>>();
        }
        while (pos != -1 && UnTaggedAnalyser.verifyBlankLine(region.get(pos))) {
            --pos;
        }
        int count = region.size() - 1;
        for (i = 0; i < pre; ++i) {
            region.remove(0);
        }
        for (i = count; i > pos; --i) {
            region.remove(region.size() - 1);
        }
        return region;
    }

    public static List<Tu.Tuple2<TextPosition, RenderInfo>> trimLine(List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        int i;
        int pre;
        if (CollectionUtils.isEmpty(line)) {
            return line;
        }
        int pos = line.size() - 1;
        for (pre = 0; pre != line.size() && UnTaggedAnalyser.verifyBlankToken(line.get(pre).getKey()); ++pre) {
        }
        if (pre == line.size()) {
            return new ArrayList<Tu.Tuple2<TextPosition, RenderInfo>>();
        }
        while (pos != -1 && UnTaggedAnalyser.verifyBlankToken(line.get(pos).getKey())) {
            --pos;
        }
        int count = line.size() - 1;
        for (i = 0; i < pre; ++i) {
            line.remove(0);
        }
        for (i = count; i > pos; --i) {
            line.remove(line.size() - 1);
        }
        return line;
    }

    public static boolean verifyBlankLine(List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        StringBuilder sb = new StringBuilder();
        for (Tu.Tuple2<TextPosition, RenderInfo> tu : line) {
            String unicode = tu.getKey().getUnicode();
            sb.append(unicode.replaceAll("[\\pZ]", "").trim());
        }
        return sb.toString().equals("");
    }

    private static boolean verifyBlankToken(TextPosition t) {
        String unicode = t.getUnicode();
        String token = unicode.replaceAll("[\\pZ]", "").trim();
        return token.equals("");
    }

    private static int verifyHeader(UnTaggedContext unTaggedContext, List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> firstLineMap = unTaggedContext.getFirstLineMap();
        int size = firstLineMap.size();
        int count = 0;
        String curLine = UnTaggedAnalyser.formLineString(line);
        for (List list : firstLineMap) {
            String s = UnTaggedAnalyser.formLineString(list);
            if (!StringUtils.isNotEmpty(s) || !curLine.trim().equals(s.trim())) continue;
            ++count;
        }
        if (count >= 2 && count >= size / 2) {
            return 1;
        }
        return 0;
    }

    private static boolean verifyPagination(UnTaggedContext unTaggedContext, List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        String str = UnTaggedAnalyser.formLineString(line);
        if (str.length() <= 7 && !str.endsWith("\u3002") && !str.endsWith(".")) {
            for (Tu.Tuple2<TextPosition, RenderInfo> tu : line) {
                String unicode = tu.getKey().getUnicode();
                if (unicode == null || unicode.length() == 0) {
                    return false;
                }
                if (!Character.isDigit(unicode.charAt(0))) continue;
                return true;
            }
        }
        LinkedList<List<Tu.Tuple2<TextPosition, RenderInfo>>> endLineMap = unTaggedContext.getEndLineMap();
        int count = 0;
        String targetStr = UnTaggedAnalyser.formLineString(line);
        for (List list : endLineMap) {
            String tmpStr = UnTaggedAnalyser.formLineString(list);
            double p = 1.0 - (double)UnTaggedAnalyser.calStrDistance(tmpStr, targetStr) * 1.0 / (double)Math.max(targetStr.length(), tmpStr.length());
            if (p > 0.5) {
                ++count;
            }
            if (count != 2) continue;
            return true;
        }
        return false;
    }

    private static int calStrDistance(String str1, String str2) {
        int i;
        char[] a = str1.toCharArray();
        char[] b = str2.toCharArray();
        int[][] len = new int[a.length + 1][b.length + 1];
        for (i = 0; i < len.length; ++i) {
            len[i][0] = i;
        }
        for (int j = 0; j < len[0].length; ++j) {
            len[0][j] = j;
        }
        for (i = 1; i < len.length; ++i) {
            for (int j = 1; j < len[0].length; ++j) {
                len[i][j] = a[i - 1] == b[j - 1] ? len[i - 1][j - 1] : Math.min(Math.min(len[i - 1][j], len[i - 1][j - 1]), len[i][j - 1]) + 1;
            }
        }
        return len[len.length - 1][len[0].length - 1];
    }

    public static float calAvgDeltaLength(List<Tu.Tuple2<TextPosition, RenderInfo>> line) {
        float aggr = 0.0f;
        int sizeMinus = 0;
        for (Tu.Tuple2<TextPosition, RenderInfo> p : line) {
            TextPosition tp = p.getKey();
            if (UnTaggedAnalyser.isPresetTextPosition(tp)) {
                ++sizeMinus;
                continue;
            }
            float width = tp.getWidth();
            aggr += width;
        }
        int i = line.size() - sizeMinus;
        if (i != 0) {
            return aggr / (float)i;
        }
        return Float.MAX_VALUE;
    }

    private static boolean isPresetTextPosition(TextPosition tp) {
        return tp.getPageWidth() == -1.0f || tp.getPageWidth() == -2.0f;
    }

    public static boolean comparePos(Float pre, Float post, float tolerance) {
        return post.floatValue() - pre.floatValue() > tolerance;
    }

    public static boolean compareTokenRender(RenderInfo pre, RenderInfo post) {
        RenderingMode postRenderingMode;
        RenderingMode preRenderingMode = pre.getRenderingMode();
        return preRenderingMode != (postRenderingMode = post.getRenderingMode());
    }

    public static boolean compareTokenFont(List<Tu.Tuple2<TextPosition, RenderInfo>> line1, List<Tu.Tuple2<TextPosition, RenderInfo>> line2) {
        HashMap<String, Integer> fontMap = new HashMap<String, Integer>();
        Tu.Tuple2<String, String> preMostCommonFonts = UnTaggedAnalyser.findMostCommonFont(line1, fontMap);
        Tu.Tuple2<String, String> postMostCommonFont = UnTaggedAnalyser.findMostCommonFont(line2, fontMap);
        String preFirst = preMostCommonFonts.getKey();
        String preSecond = preMostCommonFonts.getValue();
        String postFirst = postMostCommonFont.getKey();
        String postSecond = postMostCommonFont.getValue();
        if (!preFirst.equals("") && (preFirst.equals(postFirst) || preFirst.equals(postSecond))) {
            return false;
        }
        return preSecond.equals("") || !preSecond.equals(postFirst) && !preSecond.equals(postSecond);
    }

    public static Tu.Tuple2<String, String> findMostCommonFont(List<Tu.Tuple2<TextPosition, RenderInfo>> line, Map<String, Integer> fontMap) {
        fontMap.clear();
        for (Tu.Tuple2<TextPosition, RenderInfo> tu : line) {
            if (tu.getKey().getFont() == null || tu.getKey().getFont().getFontDescriptor() == null) continue;
            String fontName = tu.getKey().getFont().getFontDescriptor().getFontName();
            float fontWeight = tu.getKey().getFont().getFontDescriptor().getFontWeight();
            RenderingMode renderingMode = tu.getValue().getRenderingMode();
            String key = fontName + renderingMode + fontWeight;
            if (fontMap.containsKey(key)) {
                fontMap.put(key, fontMap.get(key) + 1);
                continue;
            }
            fontMap.put(key, 1);
        }
        List collect = fontMap.entrySet().stream().sorted(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue() - o1.getValue();
            }
        }).collect(Collectors.toList());
        String first = "";
        String second = "";
        if (!CollectionUtils.isEmpty(collect)) {
            if (collect.size() == 1) {
                first = (String)((Map.Entry)collect.get(0)).getKey();
            } else {
                first = (String)((Map.Entry)collect.get(0)).getKey();
                Integer count = (Integer)((Map.Entry)collect.get(1)).getValue();
                if (count > 3) {
                    second = (String)((Map.Entry)collect.get(1)).getKey();
                }
            }
        }
        return new Tu.Tuple2<String, String>(first, second);
    }

    public static boolean compareFirstTokenPos(TextPosition pre, TextPosition post, float tolerance) {
        float preX = pre.getX();
        float postX = post.getX();
        return postX - preX > tolerance;
    }

    public static boolean compareEndTokenPos(TextPosition pre, TextPosition post, float tolerance) {
        float postX;
        float preX = pre.getX();
        return preX - (postX = post.getX()) > tolerance;
    }

    public static Tu.Tuple2<Float, Float> findMostCommonFontSize(List<Tu.Tuple2<TextPosition, RenderInfo>> line, Map<Float, Integer> map) {
        map.clear();
        line.forEach(x -> {
            float fontSize = ((TextPosition)x.getKey()).getFontSize();
            if (map.containsKey(Float.valueOf(fontSize))) {
                map.put(Float.valueOf(fontSize), (Integer)map.get(Float.valueOf(fontSize)) + 1);
            } else {
                map.put(Float.valueOf(fontSize), 1);
            }
        });
        List collect = map.entrySet().stream().sorted(new Comparator<Map.Entry<Float, Integer>>(){

            @Override
            public int compare(Map.Entry<Float, Integer> o1, Map.Entry<Float, Integer> o2) {
                return -Integer.compare(o1.getValue(), o2.getValue());
            }
        }).collect(Collectors.toList());
        if (collect.size() == 1) {
            Float first = (Float)((Map.Entry)collect.get(0)).getKey();
            return new Tu.Tuple2<Float, Float>(first, first);
        }
        if (collect.size() >= 2) {
            Float first = (Float)((Map.Entry)collect.get(0)).getKey();
            Float second = (Float)((Map.Entry)collect.get(1)).getKey();
            return new Tu.Tuple2<Float, Float>(first, second);
        }
        return null;
    }

    public static Tu.Tuple2<String, String> findMostCommonRenderingMode(List<Tu.Tuple2<TextPosition, RenderInfo>> line, Map<String, Integer> map) {
        map.clear();
        line.forEach(x -> {
            if (x.getValue() != null && ((RenderInfo)x.getValue()).getRenderingMode() != null) {
                String renderingMode = ((RenderInfo)x.getValue()).getRenderingMode().toString();
                if (map.containsKey(renderingMode)) {
                    map.put(renderingMode, (Integer)map.get(renderingMode) + 1);
                } else {
                    map.put(renderingMode, 1);
                }
            }
        });
        List collect = map.entrySet().stream().sorted(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return -Integer.compare(o1.getValue(), o2.getValue());
            }
        }).collect(Collectors.toList());
        if (collect.size() == 1) {
            String first = (String)((Map.Entry)collect.get(0)).getKey();
            return new Tu.Tuple2<String, String>(first, first);
        }
        if (collect.size() >= 2) {
            String first = (String)((Map.Entry)collect.get(0)).getKey();
            String second = (String)((Map.Entry)collect.get(1)).getKey();
            return new Tu.Tuple2<String, String>(first, second);
        }
        return null;
    }

    static {
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }
}

