/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.http;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RequestHTTPUtil {
    @Autowired
    private RestTemplate restTemplate;
    private static RestTemplate restTemplateHTTP;
    private static RestTemplate restTemplateHTTPs;

    @PostConstruct
    public void initParam() {
        this.restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        restTemplateHTTP = this.restTemplate;
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory();
        factory.setConnectTimeout(3600000);
        factory.setReadTimeout(3600000);
        factory.setWriteTimeout(3600000);
        return factory;
    }

    public static <T> T requestGet(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)restTemplateHTTP.getForObject(url, responseType, urlVariables);
    }

    public static <T> T requestPost(String url, Object body, Class<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        return (T)restTemplateHTTP.postForObject(url, (Object)request, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> postEntity(String url, Object body, Class<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        return restTemplateHTTP.postForEntity(url, (Object)request, responseType, new Object[0]);
    }

    public static <T> T requestPost(String url, Class<T> responseType, MultiValueMap<String, Object> form) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestEntity = new HttpEntity(form);
        ResponseEntity exchange = restTemplateHTTP.postForEntity(url, (Object)requestEntity, responseType, new Object[0]);
        return (T)exchange.getBody();
    }

    public static <T> T requestGetHTTPs(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)restTemplateHTTPs.getForObject(url, responseType, urlVariables);
    }

    public static <T> T requestPostHTTPs(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)restTemplateHTTPs.postForObject(url, null, responseType, urlVariables);
    }
}

