/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.tools;

import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class FileTool {
    private static final String html = "<!DOCTYPE html>\n" + "<html>\n" + "    <head>\n" + "        <title>Empty HTML Page</title>\n" + "    </head>\n" + "    <body>\n" + "    </body>\n" + "</html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveText(String outputFileDir, ContentPojo contentPojo, String fileName) {
        if (outputFileDir == null) {
            return "";
        }
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        StringBuilder sb = new StringBuilder();
        outList.stream().forEach(x -> {
            if (x.getElementType().equals("text") || x.getElementType().equals("title")) {
                sb.append(x.getText().replaceAll("\n", ""));
                sb.append("\n");
                sb.append("\n");
            } else if (x.getElementType().equals("table")) {
                List<ContentPojo.contentElement.InnerCell> cells = x.getCells();
                Map<Integer, List<ContentPojo.contentElement.InnerCell>> collect = cells.stream().collect(Collectors.groupingBy(ContentPojo.contentElement.InnerCell::getRow_index));
                collect.entrySet().stream().forEach(y -> {
                    List rowCells = (List)y.getValue();
                    for (ContentPojo.contentElement.InnerCell innerCell : rowCells) {
                        sb.append(TextTool.unescape(innerCell.getText()).replaceAll("\n", ""));
                        sb.append(",");
                    }
                    sb.append("\n");
                });
            }
        });
        OutputStreamWriter fwriter = null;
        try {
            String name = null;
            name = fileName.contains("/") ? fileName.split("/")[fileName.split("/").length - 1].split("\\.")[0] : fileName.split("\\\\")[fileName.split("\\\\").length - 1].split("\\.")[0];
            fwriter = new FileWriter(outputFileDir + "/" + name + ".txt", false);
            fwriter.write(sb.toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fwriter.flush();
                fwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveJson(String outputFileDir, ContentPojo contentPojo, String fileName) {
        if (outputFileDir == null) {
            return "";
        }
        String finalText = TextTool.toJson(contentPojo);
        OutputStreamWriter fwriter = null;
        try {
            String name = null;
            name = fileName.contains("/") ? fileName.split("/")[fileName.split("/").length - 1].split("\\.")[0] : fileName.split("\\\\")[fileName.split("\\\\").length - 1].split("\\.")[0];
            fwriter = new FileWriter(outputFileDir + "/" + name + ".json", false);
            fwriter.write(finalText);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fwriter.flush();
                fwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return finalText;
    }

    public static void saveXML(String outputFileDir, org.dom4j.Document dom, String fileName) {
        if (outputFileDir == null || dom == null) {
            return;
        }
        String name = null;
        name = fileName.contains("/") ? fileName.split("/")[fileName.split("/").length - 1].split("\\.")[0] : fileName.split("\\\\")[fileName.split("\\\\").length - 1].split("\\.")[0];
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File file = new File(outputFileDir + "/" + name + ".xml");
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)new FileOutputStream(file), format);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        writer.setEscapeText(false);
        try {
            writer.write(dom);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveHTML(String outputFileDir, ContentPojo contentPojo, String fileName) {
        if (outputFileDir == null) {
            return "";
        }
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < outList.size(); ++i) {
            ContentPojo.contentElement p = outList.get(i);
            String element_type = p.getElementType();
            if ("text".equals(element_type)) {
                sb.append("<p>");
                sb.append(p.getText()).append("</p>");
                sb.append("<br/>");
                continue;
            }
            if ("title".equals(element_type)) {
                sb.append("<h>");
                sb.append(p.getText()).append("</h>");
                sb.append("<br/>");
                continue;
            }
            if (element_type.equals("table")) {
                sb.append("<table border=\"1\">");
                List<ContentPojo.contentElement.InnerCell> cells = p.getCells();
                Map<Integer, List<ContentPojo.contentElement.InnerCell>> collect = cells.stream().collect(Collectors.groupingBy(ContentPojo.contentElement.InnerCell::getRow_index));
                collect.entrySet().stream().forEach(x -> {
                    sb.append("<tr>").append("\n");
                    List rowCells = (List)x.getValue();
                    for (ContentPojo.contentElement.InnerCell innerCell : rowCells) {
                        Integer row_span = innerCell.getRow_span();
                        Integer col_span = innerCell.getCol_span();
                        sb.append(String.format(" <td colspan=\"%s\" rowspan=\"%s\">", col_span, row_span));
                        sb.append(TextTool.unescape(innerCell.getText()));
                        sb.append("</td>");
                    }
                    sb.append("</tr>").append("\n");
                });
                sb.append("</table>").append("\n").append("<br/>");
                continue;
            }
            if (!element_type.equals("pic")) continue;
            String text = p.getText();
            String format = String.format("<img src=\"%s\" />", text);
            sb.append(format);
            sb.append("<br/>");
        }
        OutputStreamWriter fwriter = null;
        try {
            String name = null;
            name = fileName.contains("/") ? fileName.split("/")[fileName.split("/").length - 1] : fileName.split("\\\\")[fileName.split("\\\\").length - 1];
            name = name.substring(0, name.lastIndexOf("."));
            fwriter = new FileWriter(outputFileDir + "/" + name + ".html", false);
            fwriter.write(sb.toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fwriter.flush();
                fwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static Document table2Html(ContentPojo contentPojo) {
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        Document document = Jsoup.parse((String)html);
        Element body = document.body();
        Element div = new Element("div");
        div.attr("style", "overflow-x:auto;margin-bottom:72.0pt;margin-top:72.0pt;margin-left:20.0pt;margin-right:20.0pt;");
        body.appendChild((Node)div);
        for (ContentPojo.contentElement p : outList) {
            String element_type = p.getElementType();
            if (!element_type.equals("table")) continue;
            Element table = new Element("table");
            div.appendChild((Node)table);
            table.attr("border", "1");
            table.attr("style", "border-collapse:collapse;");
            List<ContentPojo.contentElement.InnerCell> cells = p.getCells();
            Map<Integer, List<ContentPojo.contentElement.InnerCell>> collect = cells.stream().collect(Collectors.groupingBy(ContentPojo.contentElement.InnerCell::getRow_index));
            collect.forEach((key, rowCells) -> {
                Element tr = new Element("tr");
                table.appendChild((Node)tr);
                for (ContentPojo.contentElement.InnerCell innerCell : rowCells) {
                    String[] cuts;
                    Integer row_span = innerCell.getRow_span();
                    Integer col_span = innerCell.getCol_span();
                    Element td = new Element("td");
                    tr.appendChild((Node)td);
                    td.attr("style", "width:" + innerCell.getWidth() + "pt;height:" + innerCell.getHeight() + "pt;");
                    td.attr("colspan", col_span.toString());
                    td.attr("rowspan", row_span.toString());
                    String cellText = innerCell.getText();
                    for (String cut : cuts = cellText.replaceAll("[ \\r]+", "").split("\\n")) {
                        Element span = new Element("span");
                        span.text(cut);
                        td.appendChild((Node)span);
                        Element br = new Element("br");
                        td.appendChild((Node)br);
                    }
                }
            });
        }
        return document;
    }

    public static void main(String[] args) throws IOException {
        File file = new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u672c\u5730\u63d0\u53d6\u6d4b\u8bd5\\\u65b0\u5efa\u6587\u4ef6\u5939 (4)\\4.ZF3G24020003\u7b7e\u7ae0\u6280\u672f\u534f\u8bae.pdf");
        ContentPojo contentPojo = PdfParser.parsingUnTaggedPdfWithTableDetection(PDDocument.load((File)file), true);
        Document document = FileTool.table2Html(contentPojo);
        FileWriter fileWriter = new FileWriter("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u672c\u5730\u63d0\u53d6\u6d4b\u8bd5\\\u65b0\u5efa\u6587\u4ef6\u5939 (2)\\4.ZF3G24040002\u7b7e\u7ae0\u6280\u672f\u9644\u4ef6(1)(1).html");
        fileWriter.write(document.outerHtml());
        fileWriter.flush();
        fileWriter.close();
        String aa = "";
        String[] split = aa.replaceAll("[ \\r]+", "").split("\\n");
        System.out.println("end");
    }
}

