/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.externalserve;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.externalserve.BatchAnswer;
import com.jxdinfo.idp.common.entity.externalserve.BatchQuestion;
import com.jxdinfo.idp.common.entity.externalserve.Knowledge;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.http.RequestHTTPUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class KnowledgeBaseServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBaseServer.class);
    @Value(value="${rmi.knowledge_base.url}")
    private String url;
    @Value(value="${rmi.knowledge_base.api.create_knowledge_base}")
    private String createKnowledgeBaseApi;
    @Value(value="${rmi.knowledge_base.api.upload_doc}")
    private String uploadDocApi;
    @Value(value="${rmi.knowledge_base.api.knowledge_base_chat}")
    private String knowledgeBaseChatApi;
    public static final String ERROR_RESPONSE = "\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002";

    public ApiResponse createKnowledgeBase(Knowledge knowledge) {
        return RequestHTTPUtil.requestPost(this.url + this.createKnowledgeBaseApi, knowledge, ApiResponse.class);
    }

    public ApiResponse uploadDoc(String knowledge_base_name, final FileBytesInfo bytesInfo) {
        ByteArrayResource file = null;
        try {
            file = new ByteArrayResource(bytesInfo.getFileBytes()){

                public String getFilename() {
                    return bytesInfo.getFileName();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"knowledge_base_name", (Object)knowledge_base_name);
        form.add((Object)"file", (Object)file);
        form.add((Object)"chunk_size", (Object)200);
        form.add((Object)"overlap_size", (Object)30);
        return RequestHTTPUtil.requestPost(this.url + this.uploadDocApi, ApiResponse.class, (MultiValueMap<String, Object>)form);
    }

    public ApiResponse deleteDoc(Knowledge knowledge) {
        return RequestHTTPUtil.requestPost(this.url + "/knowledge_base/delete_doc", knowledge, ApiResponse.class);
    }

    public ApiResponse deleteKnowledgeBase(Knowledge knowledge) {
        return RequestHTTPUtil.requestPost(this.url + "/knowledge_base/delete_knowledge_base", knowledge, ApiResponse.class);
    }

    public String chat(Knowledge knowledge) {
        try {
            String batchAnswer = RequestHTTPUtil.requestPost(this.url + this.knowledgeBaseChatApi, knowledge, String.class);
            JSONObject jsonObject = JSON.parseObject((String)batchAnswer);
            return jsonObject.get((Object)"answer").toString();
        }
        catch (Exception e) {
            log.error("\u77e5\u8bc6\u5e93\u95ee\u7b54\u51fa\u9519", (Throwable)e);
            System.out.println(e.getMessage());
            return ERROR_RESPONSE;
        }
    }

    BatchAnswer knowledgeBaseChatBatch(BatchQuestion questions) {
        return RequestHTTPUtil.requestPost(this.url + "/chat/knowledge_base_chat_batch", questions, BatchAnswer.class);
    }
}

