/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.tools;

import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.tools.ContentRegion;
import com.jxdinfo.idp.common.pdfparser.tools.RenderInfo;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Bidi;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.text.TextPositionComparator;

public class ModifiedPDFTextStripperByArea
extends PDFTextStripper {
    public final List<String> regions = new ArrayList<String>();
    public final Map<String, Rectangle2D> regionArea = new HashMap<String, Rectangle2D>();
    public final Map<String, ArrayList<List<TextPosition>>> regionCharacterList = new HashMap<String, ArrayList<List<TextPosition>>>();
    public final Map<String, StringWriter> regionText = new HashMap<String, StringWriter>();
    private List<List<Tu.Tuple2<TextPosition, RenderInfo>>> textPositionsList = null;
    public final Map<TextPosition, RenderInfo> positionRenderInfoMap = new HashMap<TextPosition, RenderInfo>();
    public final Map<String, List<List<Tu.Tuple2<TextPosition, RenderInfo>>>> contentRegions = new HashMap<String, List<List<Tu.Tuple2<TextPosition, RenderInfo>>>>();
    public final Map<String, Object> orginalName = new HashMap<String, Object>();
    private static Map<Character, Character> MIRRORING_CHAR_MAP = new HashMap<Character, Character>();

    public Map<String, List<List<Tu.Tuple2<TextPosition, RenderInfo>>>> getContentRegions() {
        return this.contentRegions;
    }

    public List<List<Tu.Tuple2<TextPosition, RenderInfo>>> getDetailedTextForRange(String region) {
        return this.contentRegions.get(region);
    }

    public Map<TextPosition, RenderInfo> getPositionRenderInfoMap() {
        return this.positionRenderInfoMap;
    }

    public ModifiedPDFTextStripperByArea() throws IOException {
        super.setShouldSeparateByBeads(false);
    }

    public final void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
    }

    public Writer getOutput() {
        return super.getOutput();
    }

    public void addRegion(String regionName, Rectangle2D rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public void test(String regionName, Object o) {
        this.orginalName.put(regionName, o);
    }

    public void removeRegion(String regionName) {
        this.regions.remove(regionName);
        this.regionArea.remove(regionName);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(PDPage page) throws IOException {
        for (String region : this.regions) {
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            ArrayList regionCharactersByArticle = new ArrayList();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(region, regionCharactersByArticle);
            this.regionText.put(region, new StringWriter());
        }
        if (page.hasContents()) {
            this.processPage(page);
        }
    }

    protected void processTextPosition(TextPosition text) {
        float lineWidth = this.getGraphicsState().getLineWidth();
        RenderingMode renderingMode = this.getGraphicsState().getTextState().getRenderingMode();
        RenderInfo renderInfo = new RenderInfo();
        renderInfo.setLineWidth(Float.valueOf(lineWidth));
        renderInfo.setRenderingMode(renderingMode);
        this.positionRenderInfoMap.put(text, renderInfo);
        for (Map.Entry<String, Rectangle2D> regionAreaEntry : this.regionArea.entrySet()) {
            Object o = this.orginalName.get(regionAreaEntry.getKey());
            Rectangle2D rect = regionAreaEntry.getValue();
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = this.regionCharacterList.get(regionAreaEntry.getKey());
            super.processTextPosition(text);
            break;
        }
    }

    protected void writePage() throws IOException {
        Iterator<String> var1 = this.regionArea.keySet().iterator();
        ContentRegion contentRegion = new ContentRegion();
        this.textPositionsList = new ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>>();
        while (var1.hasNext()) {
            String region = var1.next();
            this.charactersByArticle = this.regionCharacterList.get(region);
            this.output = this.regionText.get(region);
            this.newWritePage(contentRegion);
            this.contentRegions.put(region, this.textPositionsList);
            this.textPositionsList = new ArrayList<List<Tu.Tuple2<TextPosition, RenderInfo>>>();
        }
    }

    private void newWritePage(ContentRegion contentRegion) throws IOException {
        String wordSeparator = " ";
        float maxHeightForLine = -1.0f;
        float maxYForLine = -3.4028235E38f;
        float minYTopForLine = Float.MAX_VALUE;
        float endOfLastTextX = -1.0f;
        float spacingTolerance = 0.5f;
        float averageCharTolerance = 0.3f;
        float lastWordSpacing = -1.0f;
        boolean startOfPage = true;
        PositionWrapper lastPosition = null;
        PositionWrapper lastLineStartPosition = null;
        if (this.charactersByArticle.size() > 0) {
            this.writePageStart();
        }
        for (List textList : this.charactersByArticle) {
            if (this.getSortByPosition()) {
                TextPositionComparator comparator = new TextPositionComparator();
                textList.sort(comparator);
            }
            this.startArticle();
            boolean startOfArticle = true;
            ArrayList<LineItem> line = new ArrayList<LineItem>();
            ArrayList<Tu.Tuple2<TextPosition, Object>> positions = new ArrayList<Tu.Tuple2<TextPosition, Object>>();
            Iterator textIter = textList.iterator();
            float previousAveCharWidth = -1.0f;
            while (textIter.hasNext()) {
                float positionHeight;
                float positionWidth;
                float positionY;
                float positionX;
                TextPosition position = (TextPosition)textIter.next();
                PositionWrapper current = new PositionWrapper(position);
                String characterValue = position.getUnicode();
                if (lastPosition != null && (position.getFont() != lastPosition.getTextPosition().getFont() || position.getFontSize() != lastPosition.getTextPosition().getFontSize())) {
                    previousAveCharWidth = -1.0f;
                }
                if (this.getSortByPosition()) {
                    positionX = position.getXDirAdj();
                    positionY = position.getYDirAdj();
                    positionWidth = position.getWidthDirAdj();
                    positionHeight = position.getHeightDir();
                } else {
                    positionX = position.getX();
                    positionY = position.getY();
                    positionWidth = position.getWidth();
                    positionHeight = position.getHeight();
                }
                int wordCharCount = position.getIndividualWidths().length;
                float wordSpacing = position.getWidthOfSpace();
                float deltaSpace = wordSpacing == 0.0f || Float.isNaN(wordSpacing) ? Float.MAX_VALUE : (lastWordSpacing < 0.0f ? wordSpacing * spacingTolerance : (wordSpacing + lastWordSpacing) / 2.0f * spacingTolerance);
                float averageCharWidth = previousAveCharWidth < 0.0f ? positionWidth / (float)wordCharCount : (previousAveCharWidth + positionWidth / (float)wordCharCount) / 2.0f;
                float deltaCharWidth = averageCharWidth * averageCharTolerance;
                float expectedStartOfNextWordX = -3.4028235E38f;
                if (endOfLastTextX != -1.0f) {
                    expectedStartOfNextWordX = endOfLastTextX + Math.min(deltaSpace, deltaCharWidth);
                }
                if (lastPosition != null) {
                    if (startOfArticle) {
                        lastPosition.setArticleStart();
                        startOfArticle = false;
                    }
                    if (!this.overlap(positionY, positionHeight, maxYForLine, maxHeightForLine)) {
                        this.writeLine(this.normalize(line));
                        line.clear();
                        this.textPositionsList.add(positions);
                        positions = new ArrayList();
                        lastLineStartPosition = this.handleLineSeparation(current, lastPosition, lastLineStartPosition, maxHeightForLine);
                        expectedStartOfNextWordX = -3.4028235E38f;
                        maxYForLine = -3.4028235E38f;
                        maxHeightForLine = -1.0f;
                        minYTopForLine = Float.MAX_VALUE;
                    }
                    if (expectedStartOfNextWordX != -3.4028235E38f && expectedStartOfNextWordX < positionX && (wordSeparator.isEmpty() || lastPosition.getTextPosition().getUnicode() != null && !lastPosition.getTextPosition().getUnicode().endsWith(wordSeparator))) {
                        line.add(LineItem.getWordSeparator());
                        positions.add(new Tu.Tuple2<TextPosition, Object>(ContentRegion.createTextPositionForWordSep(), null));
                    }
                    if (Math.abs(position.getX() - lastPosition.getTextPosition().getX()) > wordSpacing + deltaSpace) {
                        maxYForLine = -3.4028235E38f;
                        maxHeightForLine = -1.0f;
                        minYTopForLine = Float.MAX_VALUE;
                    }
                }
                if (positionY >= maxYForLine) {
                    maxYForLine = positionY;
                }
                endOfLastTextX = positionX + positionWidth;
                if (characterValue != null) {
                    if (startOfPage && lastPosition == null) {
                        this.writeParagraphStart();
                    }
                    line.add(new LineItem(position));
                    positions.add(new Tu.Tuple2<TextPosition, RenderInfo>(position, this.positionRenderInfoMap.get(position)));
                }
                maxHeightForLine = Math.max(maxHeightForLine, positionHeight);
                minYTopForLine = Math.min(minYTopForLine, positionY - positionHeight);
                lastPosition = current;
                if (startOfPage) {
                    lastPosition.setParagraphStart();
                    lastPosition.setLineStart();
                    lastLineStartPosition = lastPosition;
                    startOfPage = false;
                }
                lastWordSpacing = wordSpacing;
                previousAveCharWidth = averageCharWidth;
            }
            if (line.size() > 0) {
                this.writeLine(this.normalize(line));
                this.textPositionsList.add(positions);
                this.writeParagraphEnd();
            }
            this.endArticle();
        }
        this.writePageEnd();
    }

    private PositionWrapper handleLineSeparation(PositionWrapper current, PositionWrapper lastPosition, PositionWrapper lastLineStartPosition, float maxHeightForLine) throws IOException {
        current.setLineStart();
        this.isParagraphSeparation(current, lastPosition, lastLineStartPosition, maxHeightForLine);
        lastLineStartPosition = current;
        if (current.isParagraphStart()) {
            if (lastPosition.isArticleStart()) {
                if (lastPosition.isLineStart()) {
                    this.writeLineSeparator();
                }
                this.writeParagraphStart();
            } else {
                this.writeLineSeparator();
                this.writeParagraphSeparator();
            }
        } else {
            this.writeLineSeparator();
        }
        return lastLineStartPosition;
    }

    private void isParagraphSeparation(PositionWrapper position, PositionWrapper lastPosition, PositionWrapper lastLineStartPosition, float maxHeightForLine) {
        boolean result = false;
        if (lastLineStartPosition == null) {
            result = true;
        } else {
            float yGap = Math.abs(position.getTextPosition().getYDirAdj() - lastPosition.getTextPosition().getYDirAdj());
            float newYVal = this.multiplyFloat(this.getDropThreshold(), maxHeightForLine);
            float xGap = position.getTextPosition().getXDirAdj() - lastLineStartPosition.getTextPosition().getXDirAdj();
            float newXVal = this.multiplyFloat(this.getIndentThreshold(), position.getTextPosition().getWidthOfSpace());
            float positionWidth = this.multiplyFloat(0.25f, position.getTextPosition().getWidth());
            if (yGap > newYVal) {
                result = true;
            } else if (xGap > newXVal) {
                if (!lastLineStartPosition.isParagraphStart()) {
                    result = true;
                } else {
                    position.setHangingIndent();
                }
            } else if (xGap < -position.getTextPosition().getWidthOfSpace()) {
                if (!lastLineStartPosition.isParagraphStart()) {
                    result = true;
                }
            } else if (Math.abs(xGap) < positionWidth) {
                Pattern currentPattern;
                Pattern liPattern;
                if (lastLineStartPosition.isHangingIndent()) {
                    position.setHangingIndent();
                } else if (lastLineStartPosition.isParagraphStart() && (liPattern = this.matchListItemPattern(lastLineStartPosition)) != null && liPattern == (currentPattern = this.matchListItemPattern(position))) {
                    result = true;
                }
            }
        }
        if (result) {
            position.setParagraphStart();
        }
    }

    private Pattern matchListItemPattern(PositionWrapper pw) {
        TextPosition tp = pw.getTextPosition();
        String txt = tp.getUnicode();
        return ModifiedPDFTextStripperByArea.matchPattern((String)txt, (List)this.getListItemPatterns());
    }

    private float multiplyFloat(float value1, float value2) {
        return (float)Math.round(value1 * value2 * 1000.0f) / 1000.0f;
    }

    private List<WordWithTextPositions> normalize(List<LineItem> line) {
        LinkedList<WordWithTextPositions> normalized = new LinkedList<WordWithTextPositions>();
        StringBuilder lineBuilder = new StringBuilder();
        ArrayList<TextPosition> wordPositions = new ArrayList<TextPosition>();
        for (LineItem item : line) {
            lineBuilder = this.normalizeAdd(normalized, lineBuilder, wordPositions, item);
        }
        if (lineBuilder.length() > 0) {
            normalized.add(this.createWord(lineBuilder.toString(), wordPositions));
        }
        return normalized;
    }

    private StringBuilder normalizeAdd(List<WordWithTextPositions> normalized, StringBuilder lineBuilder, List<TextPosition> wordPositions, LineItem item) {
        if (item.isWordSeparator()) {
            normalized.add(this.createWord(lineBuilder.toString(), new ArrayList<TextPosition>(wordPositions)));
            lineBuilder = new StringBuilder();
            wordPositions.clear();
        } else {
            TextPosition text = item.getTextPosition();
            lineBuilder.append(text.getUnicode());
            wordPositions.add(text);
        }
        return lineBuilder;
    }

    private WordWithTextPositions createWord(String word, List<TextPosition> wordPositions) {
        return new WordWithTextPositions(this.normalizeWord(word), wordPositions);
    }

    private String normalizeWord(String word) {
        int q;
        StringBuilder builder = null;
        int p = 0;
        int strLength = word.length();
        for (q = 0; q < strLength; ++q) {
            char c = word.charAt(q);
            if (('\ufb00' > c || c > '\ufdff') && ('\ufe70' > c || c > '\ufeff')) continue;
            if (builder == null) {
                builder = new StringBuilder(strLength * 2);
            }
            builder.append(word, p, q);
            if (c == '\ufdf2' && q > 0 && (word.charAt(q - 1) == '\u0627' || word.charAt(q - 1) == '\ufe8d')) {
                builder.append("\u0644\u0644\u0647");
            } else {
                builder.append(Normalizer.normalize(word.substring(q, q + 1), Normalizer.Form.NFKC).trim());
            }
            p = q + 1;
        }
        if (builder == null) {
            return this.handleDirection(word);
        }
        builder.append(word, p, q);
        return this.handleDirection(builder.toString());
    }

    private static void parseBidiFile(InputStream inputStream) throws IOException {
        String s;
        LineNumberReader rd = new LineNumberReader(new InputStreamReader(inputStream));
        while ((s = rd.readLine()) != null) {
            int comment = s.indexOf(35);
            if (comment != -1) {
                s = s.substring(0, comment);
            }
            if (s.length() < 2) continue;
            StringTokenizer st = new StringTokenizer(s, ";");
            int nFields = st.countTokens();
            Character[] fields = new Character[nFields];
            for (int i = 0; i < nFields; ++i) {
                fields[i] = Character.valueOf((char)Integer.parseInt(st.nextToken().trim(), 16));
            }
            if (fields.length != 2) continue;
            MIRRORING_CHAR_MAP.put(fields[0], fields[1]);
        }
    }

    private String handleDirection(String word) {
        Bidi bidi = new Bidi(word, -2);
        if (!bidi.isMixed() && bidi.getBaseLevel() == 0) {
            return word;
        }
        int runCount = bidi.getRunCount();
        byte[] levels = new byte[runCount];
        Object[] runs = new Integer[runCount];
        for (int i = 0; i < runCount; ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
            runs[i] = i;
        }
        Bidi.reorderVisually(levels, 0, runs, 0, runCount);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < runCount; ++i) {
            int index = (Integer)runs[i];
            int start = bidi.getRunStart(index);
            int end = bidi.getRunLimit(index);
            byte level = levels[index];
            if ((level & 1) != 0) {
                while (--end >= start) {
                    char character = word.charAt(end);
                    if (Character.isMirrored(word.codePointAt(end))) {
                        if (MIRRORING_CHAR_MAP.containsKey(Character.valueOf(character))) {
                            result.append(MIRRORING_CHAR_MAP.get(Character.valueOf(character)));
                            continue;
                        }
                        result.append(character);
                        continue;
                    }
                    result.append(character);
                }
                continue;
            }
            result.append(word, start, end);
        }
        return result.toString();
    }

    private void writeLine(List<WordWithTextPositions> line) throws IOException {
        int numberOfStrings = line.size();
        for (int i = 0; i < numberOfStrings; ++i) {
            WordWithTextPositions word = line.get(i);
            this.writeString(word.getText(), word.getTextPositions());
            if (i >= numberOfStrings - 1) continue;
            this.writeWordSeparator();
        }
    }

    private boolean overlap(float y1, float height1, float y2, float height2) {
        return this.within(y1, y2, 0.1f) || y2 <= y1 && y2 >= y1 - height1 || y1 <= y2 && y1 >= y2 - height2;
    }

    private boolean within(float first, float second, float variance) {
        return second < first + variance && second > first - variance;
    }

    public List<List<TextPosition>> GetCharactersByArticle() {
        return this.getCharactersByArticle();
    }

    static {
        String path = "/org/apache/pdfbox/resources/text/BidiMirroring.txt";
        BufferedInputStream input = new BufferedInputStream(PDFTextStripper.class.getResourceAsStream(path));
        try {
            ModifiedPDFTextStripperByArea.parseBidiFile(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class LineItem {
        public static LineItem WORD_SEPARATOR = new LineItem();
        private final TextPosition textPosition;

        public static LineItem getWordSeparator() {
            return WORD_SEPARATOR;
        }

        private LineItem() {
            this.textPosition = null;
        }

        LineItem(TextPosition textPosition) {
            this.textPosition = textPosition;
        }

        public TextPosition getTextPosition() {
            return this.textPosition;
        }

        public boolean isWordSeparator() {
            return this.textPosition == null;
        }
    }

    private static final class PositionWrapper {
        private boolean isLineStart = false;
        private boolean isParagraphStart = false;
        private boolean isPageBreak = false;
        private boolean isHangingIndent = false;
        private boolean isArticleStart = false;
        private TextPosition position = null;

        PositionWrapper(TextPosition position) {
            this.position = position;
        }

        public TextPosition getTextPosition() {
            return this.position;
        }

        public boolean isLineStart() {
            return this.isLineStart;
        }

        public void setLineStart() {
            this.isLineStart = true;
        }

        public boolean isParagraphStart() {
            return this.isParagraphStart;
        }

        public void setParagraphStart() {
            this.isParagraphStart = true;
        }

        public boolean isArticleStart() {
            return this.isArticleStart;
        }

        public void setArticleStart() {
            this.isArticleStart = true;
        }

        public boolean isPageBreak() {
            return this.isPageBreak;
        }

        public void setPageBreak() {
            this.isPageBreak = true;
        }

        public boolean isHangingIndent() {
            return this.isHangingIndent;
        }

        public void setHangingIndent() {
            this.isHangingIndent = true;
        }
    }

    private static final class WordWithTextPositions {
        String text;
        List<TextPosition> textPositions;

        WordWithTextPositions(String word, List<TextPosition> positions) {
            this.text = word;
            this.textPositions = positions;
        }

        public String getText() {
            return this.text;
        }

        public List<TextPosition> getTextPositions() {
            return this.textPositions;
        }
    }
}

