/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.table;

import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.table.TableCell;
import com.jxdinfo.idp.common.pdfparser.table.TableInfo;
import com.jxdinfo.idp.common.pdfparser.table.TableLine;
import com.jxdinfo.idp.common.pdfparser.thirdparty.CustomPDFRenderer;
import com.jxdinfo.idp.common.pdfparser.thirdparty.CustomPageDrawer;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class CellAnalyser {
    private static final double minHorizonLineLength = 20.0;
    private static final double minVerticalLineLength = 15.0;
    private static final double maxVerticalLineWidth = 8.0;
    private static final double maxHorizonLineWidth = 8.0;
    static BufferedImage image = new BufferedImage(800, 900, 1);
    static Graphics2D g2d = image.createGraphics();

    public static List<Shape> getShapes(PDDocument doc, int pageNum) throws IOException {
        CustomPDFRenderer renderer = new CustomPDFRenderer(doc);
        BufferedImage image = renderer.renderImage(pageNum - 1);
        CustomPageDrawer drawer = renderer.getDrawer();
        List<Shape> fillLines = drawer.getFillLines();
        List<Shape> strokeLines = drawer.getStrokeLines();
        if (CollectionUtils.isEmpty(strokeLines)) {
            strokeLines = new ArrayList<Shape>();
        }
        strokeLines.addAll(fillLines);
        return strokeLines;
    }

    public static List<Shape> getSpecifyShapes(List<Shape> shapes, Double heightStart, Double heightEnd) {
        return shapes.stream().filter(x -> {
            double yStart = x.getBounds2D().getY() + 5.0;
            double yEnd = x.getBounds2D().getY() + x.getBounds2D().getHeight() - 5.0;
            return yStart >= heightStart && yEnd <= heightEnd;
        }).collect(Collectors.toList());
    }

    public static Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> getLastTableInfo(List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> resultList) {
        Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> curLast = null;
        Double curStart = Double.MAX_VALUE;
        for (Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> tu : resultList) {
            Double tmpStart = tu.getKey().getKey();
            if (!(tmpStart < curStart)) continue;
            curLast = tu;
            curStart = tmpStart;
        }
        return curLast;
    }

    public static Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> getFirstTableInfo(List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> resultList) {
        Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> curFirst = null;
        Double curStart = 0.0;
        for (Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> tu : resultList) {
            Double tmpStart = tu.getKey().getKey();
            if (!(tmpStart > curStart)) continue;
            curFirst = tu;
            curStart = tmpStart;
        }
        return curFirst;
    }

    public static TableInfo getSpecifyTableInfo(List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> resultList, Double heightStart, Double heightEnd) {
        List list = resultList.stream().filter(x -> {
            Tu.Tuple2 key = (Tu.Tuple2)x.getKey();
            Double yStart = (Double)key.getKey();
            Double yEnd = (Double)key.getValue();
            return yStart <= heightStart && yEnd >= heightEnd;
        }).collect(Collectors.toList());
        if (list.size() != 0) {
            return (TableInfo)((Tu.Tuple2)list.get(0)).getValue();
        }
        return new TableInfo(0, 0, 0.0, 0.0, 0.0, 0.0, new ArrayList<TableCell>());
    }

    public static List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> getTableInfos(List<Shape> tableLines) {
        double d;
        ArrayList<TableLine.VerticalLine> verticalLines = new ArrayList<TableLine.VerticalLine>();
        ArrayList<TableLine.HorizonLine> horizonLines = new ArrayList<TableLine.HorizonLine>();
        for (Shape shape : tableLines) {
            Rectangle bounds2D = shape.getBounds();
            double width = ((RectangularShape)bounds2D).getWidth();
            double height = ((RectangularShape)bounds2D).getHeight();
            if (((RectangularShape)bounds2D).getWidth() * ((RectangularShape)bounds2D).getHeight() >= 300000.0 || width >= 8.0 && height >= 8.0) continue;
            if (width < 8.0) {
                verticalLines.add(new TableLine.VerticalLine(((RectangularShape)bounds2D).getX(), ((RectangularShape)bounds2D).getY(), ((RectangularShape)bounds2D).getY() + ((RectangularShape)bounds2D).getHeight()));
            }
            if (!(height < 8.0)) continue;
            horizonLines.add(new TableLine.HorizonLine(((RectangularShape)bounds2D).getY(), ((RectangularShape)bounds2D).getX(), ((RectangularShape)bounds2D).getX() + ((RectangularShape)bounds2D).getWidth()));
        }
        CellAnalyser.unifyVerticalLine(verticalLines);
        Collections.sort(verticalLines);
        double curX = 0.0;
        TableLine.VerticalLine vL = null;
        ArrayList<TableLine.VerticalLine> newVerticalLines = new ArrayList<TableLine.VerticalLine>();
        for (TableLine.VerticalLine v : verticalLines) {
            double x2 = v.getX();
            if (curX == 0.0) {
                curX = x2;
            }
            if (curX == x2) {
                if (vL == null) {
                    vL = v;
                    continue;
                }
                double yEnd = vL.getYEnd();
                double yStart = v.getYStart();
                if (Math.abs(yStart - yEnd) < 4.0) {
                    vL = TableLine.connectVLine(vL, v);
                    continue;
                }
                if (vL.length >= 15.0) {
                    newVerticalLines.add(vL);
                }
                vL = v;
                continue;
            }
            if (vL != null) {
                if (vL.length >= 15.0) {
                    newVerticalLines.add(vL);
                }
                vL = v;
            }
            curX = x2;
        }
        if (vL != null && vL.length >= 15.0) {
            newVerticalLines.add(vL);
        }
        CellAnalyser.unifyHorizonLine(horizonLines);
        Collections.sort(horizonLines);
        double curY = 0.0;
        TableLine.HorizonLine hl = null;
        ArrayList<TableLine.HorizonLine> newHorizonLines = new ArrayList<TableLine.HorizonLine>();
        for (TableLine.HorizonLine h : horizonLines) {
            double y = h.getY();
            if (curY == 0.0) {
                curY = y;
            }
            if (curY == y) {
                if (hl == null) {
                    hl = h;
                    continue;
                }
                d = hl.getXEnd();
                double xStart = h.getXStart();
                if (Math.abs(xStart - d) < 4.0) {
                    hl = TableLine.connectHLine(hl, h);
                    continue;
                }
                if (hl.length >= 20.0) {
                    newHorizonLines.add(hl);
                }
                hl = h;
                continue;
            }
            if (hl != null) {
                if (hl.length >= 20.0) {
                    newHorizonLines.add(hl);
                }
                hl = h;
            }
            curY = y;
        }
        if (hl != null && hl.length >= 20.0) {
            newHorizonLines.add(hl);
        }
        if (newHorizonLines.size() != 0) {
            TableLine.HorizonLine firstLine = (TableLine.HorizonLine)newHorizonLines.get(0);
            double y = firstLine.getY();
            if (newVerticalLines.size() >= 2) {
                TableLine.VerticalLine left = (TableLine.VerticalLine)newVerticalLines.get(0);
                d = left.getYEnd();
                double leftX = left.getX();
                TableLine.VerticalLine right = (TableLine.VerticalLine)newVerticalLines.get(newVerticalLines.size() - 1);
                double rightYEnd = right.getYEnd();
                double rightX = right.getX();
                if (d - y > 10.0 && rightYEnd - y > 10.0) {
                    newHorizonLines.add(0, new TableLine.HorizonLine(d, leftX, rightX));
                }
            }
        }
        CellAnalyser.stretchVerticalLine(newVerticalLines);
        CellAnalyser.stretchHorizonLine(newHorizonLines);
        ArrayList<Tu.Tuple2<Double, Double>> rangeList = new ArrayList<Tu.Tuple2<Double, Double>>();
        for (TableLine.VerticalLine verticalLine : newVerticalLines) {
            double yStart = verticalLine.getYStart();
            double yEnd = verticalLine.getYEnd();
            rangeList.add(new Tu.Tuple2<Double, Double>(yStart, yEnd));
        }
        for (int i = 0; i < rangeList.size() - 1; ++i) {
            Tu.Tuple2 tuple = (Tu.Tuple2)rangeList.get(i);
            Double yStart = (Double)tuple.getKey();
            Double d2 = (Double)tuple.getValue();
            for (int j = i + 1; j < rangeList.size(); ++j) {
                Tu.Tuple2 curTuple = (Tu.Tuple2)rangeList.get(j);
                Double tmpYStart = (Double)curTuple.getKey();
                Double tmpYEnd = (Double)curTuple.getValue();
                if (yStart <= tmpYStart && d2 >= tmpYEnd) {
                    curTuple.setKey(yStart);
                    curTuple.setValue(d2);
                    tuple.setKey(-1.0);
                    tuple.setValue(-1.0);
                    continue;
                }
                if (tmpYStart <= yStart && tmpYEnd >= d2) {
                    tuple.setKey(-1.0);
                    tuple.setValue(-1.0);
                    continue;
                }
                if (!CellAnalyser.modifyEqual(tmpYStart, yStart) || !CellAnalyser.modifyEqual(tmpYEnd, d2)) continue;
                curTuple.setKey(Math.min(tmpYStart, yStart));
                curTuple.setValue(Math.max(tmpYEnd, d2));
                tuple.setKey(-1.0);
                tuple.setValue(-1.0);
            }
        }
        List ranges = rangeList.stream().filter(x -> (Double)x.getKey() != -1.0).collect(Collectors.toList());
        ArrayList<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> result = new ArrayList<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>>();
        for (Tu.Tuple2 tuple2 : ranges) {
            Double yStart = (Double)tuple2.getKey() - 5.0;
            Double yEnd = (Double)tuple2.getValue() + 5.0;
            ArrayList<TableLine.HorizonLine> filterHorizonLines = new ArrayList<TableLine.HorizonLine>();
            for (TableLine.HorizonLine horizonLine : newHorizonLines) {
                double hY = horizonLine.getY();
                if (!(yStart <= hY) || !(yEnd >= hY)) continue;
                filterHorizonLines.add(horizonLine);
            }
            ArrayList<TableLine.VerticalLine> filterVerticalLines = new ArrayList<TableLine.VerticalLine>();
            for (TableLine.VerticalLine newVerticalLine : newVerticalLines) {
                double vYEnd = newVerticalLine.getYEnd();
                double vYStart = newVerticalLine.getYStart();
                if (!(yStart <= vYStart) || !(yEnd >= vYEnd)) continue;
                filterVerticalLines.add(newVerticalLine);
            }
            if (filterHorizonLines.size() != 0) {
                TableLine.HorizonLine lastHLine = (TableLine.HorizonLine)filterHorizonLines.get(filterHorizonLines.size() - 1);
                double xs = lastHLine.getXStart();
                double xe = lastHLine.getXEnd();
                double lhy = lastHLine.getY();
                TableLine.HorizonLine firstHLine = (TableLine.HorizonLine)filterHorizonLines.get(0);
                double fhy = firstHLine.getY();
                if (filterVerticalLines.size() != 0) {
                    TableLine.VerticalLine firstVLine = (TableLine.VerticalLine)filterVerticalLines.get(0);
                    TableLine.VerticalLine lastVLine = (TableLine.VerticalLine)filterVerticalLines.get(filterVerticalLines.size() - 1);
                    double fxv = firstVLine.getX();
                    double lxv = lastVLine.getX();
                    if (fxv - xs > 20.0) {
                        filterVerticalLines.add(0, new TableLine.VerticalLine(xs, lhy, fhy));
                    }
                    if (xe - lxv > 20.0) {
                        filterVerticalLines.add(new TableLine.VerticalLine(xe, lhy, fhy));
                    }
                }
            }
            TableInfo tableInfo = CellAnalyser.getTableInfo(filterHorizonLines, filterVerticalLines);
            result.add(new Tu.Tuple2<Tu.Tuple2, TableInfo>(tuple2, tableInfo));
        }
        for (Tu.Tuple2 tuple2 : result) {
            TableInfo tableInfo = (TableInfo)tuple2.getValue();
            List<TableCell> cells = tableInfo.getCells();
            for (TableCell cell : cells) {
                g2d.drawLine((int)cell.getXStart().floatValue(), (int)cell.getYStart().floatValue(), (int)cell.getXStart().floatValue(), (int)cell.getYEnd().floatValue());
                g2d.drawLine((int)cell.getXEnd().floatValue(), (int)cell.getYStart().floatValue(), (int)cell.getXEnd().floatValue(), (int)cell.getYEnd().floatValue());
                g2d.drawLine((int)cell.getXStart().floatValue(), (int)cell.getYStart().floatValue(), (int)cell.getXEnd().floatValue(), (int)cell.getYStart().floatValue());
                g2d.drawLine((int)cell.getXStart().floatValue(), (int)cell.getYEnd().floatValue(), (int)cell.getXEnd().floatValue(), (int)cell.getYEnd().floatValue());
            }
        }
        return result;
    }

    public static ContentPojo.contentElement formTable(TableInfo tableInfo, Integer pageNum, PDDocument pdd) throws IOException {
        PDRectangle cropBox = pdd.getPage(pageNum - 1).getCropBox();
        float maxHeight = cropBox.getHeight();
        ArrayList<Rectangle2D> cellRanges = new ArrayList<Rectangle2D>();
        List<ContentPojo.contentElement.InnerCell> innerCells = tableInfo.getCells().stream().map(x -> {
            Integer rowIndex = x.getRowIndex();
            Integer colIndex = x.getColIndex();
            Integer rowSpan = x.getRowSpan();
            Integer colSpan = x.getColSpan();
            float xStart = x.getXStart().floatValue();
            float xEnd = x.getXEnd().floatValue();
            float width = xEnd - xStart;
            float yStart = x.getYStart().floatValue();
            float yEnd = x.getYEnd().floatValue();
            float height = yStart - yEnd;
            cellRanges.add(new Rectangle2D.Double(xStart, maxHeight - yStart, width, height));
            ContentPojo.contentElement.InnerCell innerCell = new ContentPojo.contentElement.InnerCell();
            innerCell.setRow_index(rowIndex);
            innerCell.setCol_index(colIndex);
            innerCell.setRow_span(rowSpan);
            innerCell.setCol_span(colSpan);
            return innerCell;
        }).collect(Collectors.toList());
        List<Tu.Tuple2<String, Rectangle2D>> cellTexts = TextTool.grabText(pdd, cellRanges, pageNum);
        for (int i = 0; i < innerCells.size(); ++i) {
            Tu.Tuple2<String, Rectangle2D> tmp = cellTexts.get(i);
            ((ContentPojo.contentElement.InnerCell)innerCells.get(i)).setText(tmp.getKey());
            ((ContentPojo.contentElement.InnerCell)innerCells.get(i)).setXStart(Float.valueOf((float)tmp.getValue().getX()));
            innerCells.get(i).setYStart(Float.valueOf((float)tmp.getValue().getY()));
            innerCells.get(i).setHeight(Float.valueOf((float)tmp.getValue().getHeight()));
            innerCells.get(i).setWidth(Float.valueOf((float)tmp.getValue().getWidth()));
        }
        Integer rowNum = tableInfo.getRowNum();
        Integer colNum = tableInfo.getColNum();
        ContentPojo.contentElement table = new ContentPojo.contentElement((int)pageNum, "table", rowNum, colNum, innerCells);
        return table;
    }

    public static ContentPojo.contentElement formTable(TableInfo tableInfo, Integer pageNum) {
        Integer rowNum = tableInfo.getRowNum();
        Integer colNum = tableInfo.getColNum();
        List<ContentPojo.contentElement.InnerCell> innerCells = tableInfo.getCells().stream().map(x -> {
            Integer rowIndex = x.getRowIndex();
            Integer colIndex = x.getColIndex();
            Integer rowSpan = x.getRowSpan();
            Integer colSpan = x.getColSpan();
            float xStart = x.getXStart().floatValue();
            float xEnd = x.getXEnd().floatValue();
            float width = xEnd - xStart;
            float yStart = x.getYStart().floatValue();
            float yEnd = x.getYEnd().floatValue();
            float height = yStart - yEnd;
            String cell = x.getCell();
            ContentPojo.contentElement.InnerCell innerCell = new ContentPojo.contentElement.InnerCell();
            innerCell.setRow_index(rowIndex);
            innerCell.setCol_index(colIndex);
            innerCell.setRow_span(rowSpan);
            innerCell.setCol_span(colSpan);
            innerCell.setXStart(Float.valueOf(xStart));
            innerCell.setYStart(Float.valueOf(yStart));
            innerCell.setWidth(Float.valueOf(width));
            innerCell.setHeight(Float.valueOf(height));
            innerCell.setText(cell);
            return innerCell;
        }).collect(Collectors.toList());
        ContentPojo.contentElement table = new ContentPojo.contentElement((int)pageNum, "table", rowNum, colNum, innerCells);
        Double xStart = tableInfo.getXStart();
        Double xEnd = tableInfo.getXEnd();
        Double yStart = tableInfo.getYStart();
        Double yEnd = tableInfo.getYEnd();
        table.setXStart(Float.valueOf(xStart.floatValue()));
        table.setYStart(Float.valueOf(yStart.floatValue()));
        double height = yEnd - yStart;
        table.setHeight(Float.valueOf((float)height));
        double width = xEnd - xStart;
        table.setWidth(Float.valueOf((float)width));
        return table;
    }

    public static boolean modifyEqual(Double a, Double b) {
        return Math.abs(b - a) <= 3.0;
    }

    private static TableInfo getTableInfo(List<TableLine.HorizonLine> horizonLines, List<TableLine.VerticalLine> verticalLines) {
        ArrayList<TableLine.HorizonLine> needRemoveLine = new ArrayList<TableLine.HorizonLine>();
        for (TableLine.HorizonLine horizonLine : horizonLines) {
            double xStart = horizonLine.getXStart();
            double xEnd = horizonLine.getXEnd();
            double y = horizonLine.getY();
            int crossCount = 0;
            for (TableLine.VerticalLine verticalLine : verticalLines) {
                if (crossCount == 2) break;
                double verticalLineX = verticalLine.getX();
                double verticalLineYStart = verticalLine.getYStart();
                double verticalLineYEnd = verticalLine.getYEnd();
                if (!(xStart < verticalLineX) || !(xEnd > verticalLineX) || !(verticalLineYStart < y) || !(verticalLineYEnd > y)) continue;
                ++crossCount;
            }
            if (crossCount >= 2) continue;
            needRemoveLine.add(horizonLine);
        }
        horizonLines.removeAll(needRemoveLine);
        ArrayList<TableCell> list = new ArrayList<TableCell>();
        Double tableXStart = 0.0;
        Double tableXEnd = 0.0;
        Double tableYStart = 0.0;
        Double tableYEnd = 0.0;
        Map<Double, List<TableLine.HorizonLine>> collect = horizonLines.stream().collect(Collectors.groupingBy(TableLine.HorizonLine::getY));
        List horizonList = collect.entrySet().stream().sorted((o1, o2) -> Double.compare((Double)o2.getKey(), (Double)o1.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(horizonList)) {
            Map.Entry lastLineListMap;
            List lastLineList;
            Map.Entry fistLineListMap = (Map.Entry)horizonList.get(0);
            List firstLineList = (List)fistLineListMap.getValue();
            if (!CollectionUtils.isEmpty((Collection)firstLineList)) {
                TableLine.HorizonLine horizonLine = (TableLine.HorizonLine)firstLineList.get(0);
                horizonLine.setXStart(-2.147483647E9);
                horizonLine.setXEnd(2.147483647E9);
                ArrayList<TableLine.HorizonLine> newFirstHorizonLine = new ArrayList<TableLine.HorizonLine>();
                newFirstHorizonLine.add(horizonLine);
                fistLineListMap.setValue(newFirstHorizonLine);
            }
            if (!CollectionUtils.isEmpty((Collection)(lastLineList = (List)(lastLineListMap = (Map.Entry)horizonList.get(horizonList.size() - 1)).getValue()))) {
                TableLine.HorizonLine horizonLine = (TableLine.HorizonLine)lastLineList.get(0);
                horizonLine.setXStart(-2.147483647E9);
                horizonLine.setXEnd(2.147483647E9);
                ArrayList<TableLine.HorizonLine> newLastHorizonLine = new ArrayList<TableLine.HorizonLine>();
                newLastHorizonLine.add(horizonLine);
                lastLineListMap.setValue(newLastHorizonLine);
            }
            tableYEnd = (Double)((Map.Entry)horizonList.get(0)).getKey();
            tableYStart = (Double)((Map.Entry)horizonList.get(horizonList.size() - 1)).getKey();
        }
        if (!CollectionUtils.isEmpty(verticalLines)) {
            TableLine.VerticalLine firstVerticalLine = verticalLines.get(0);
            firstVerticalLine.setYStart(-2.147483647E9);
            firstVerticalLine.setYEnd(2.147483647E9);
            double firstVerticalLineX = firstVerticalLine.getX();
            TableLine.VerticalLine lastVerticalLine = verticalLines.get(verticalLines.size() - 1);
            lastVerticalLine.setYStart(-2.147483647E9);
            lastVerticalLine.setYEnd(2.147483647E9);
            double lastVerticalLineX = lastVerticalLine.getX();
            ArrayList<TableLine.VerticalLine> newVerticalLines = new ArrayList<TableLine.VerticalLine>();
            for (TableLine.VerticalLine verticalLine : verticalLines) {
                double tmpX = verticalLine.getX();
                if (tmpX == firstVerticalLineX || tmpX == lastVerticalLineX) continue;
                newVerticalLines.add(verticalLine);
            }
            newVerticalLines.add(0, firstVerticalLine);
            newVerticalLines.add(lastVerticalLine);
            verticalLines = newVerticalLines;
            tableXStart = verticalLines.get(0).getX();
            tableXEnd = verticalLines.get(verticalLines.size() - 1).getX();
        }
        int rowNum = 0;
        int colNum = 0;
        int curRowIndex = 0;
        block3: for (int i = 0; i < horizonList.size() - 1; ++i) {
            Double floorY = (Double)((Map.Entry)horizonList.get(i)).getKey();
            List floorLines = (List)((Map.Entry)horizonList.get(i)).getValue();
            Double bottomY = (Double)((Map.Entry)horizonList.get(i + 1)).getKey();
            List bottomLines = (List)((Map.Entry)horizonList.get(i + 1)).getValue();
            HashSet<Double> set = new HashSet<Double>();
            int pre = 0;
            int pos = 0;
            int size = verticalLines.size();
            boolean preFind = false;
            boolean posFind = false;
            int colCount = 0;
            boolean firstIn = true;
            while (true) {
                preFind = false;
                if (pos != 0) {
                    pre = pos;
                    preFind = true;
                } else {
                    for (int j = pre; j < size; ++j) {
                        TableLine.VerticalLine tmp = verticalLines.get(pre);
                        double yStart = tmp.getYStart();
                        double yEnd = tmp.getYEnd();
                        if (!(yStart < bottomY) || !(yEnd > floorY)) continue;
                        preFind = true;
                        pre = j;
                        break;
                    }
                }
                posFind = false;
                set.clear();
                for (pos = pre + 1; pos < size; ++pos) {
                    TableLine.VerticalLine tmp = verticalLines.get(pos);
                    double yStart = tmp.getYStart();
                    double yEnd = tmp.getYEnd();
                    if (yStart < bottomY && yEnd > floorY) {
                        posFind = true;
                        break;
                    }
                    if (yStart < floorY && yStart > bottomY && yEnd > floorY) {
                        set.add(tmp.getX());
                        continue;
                    }
                    if (!(yEnd > bottomY) || !(yEnd < floorY) || !(yStart > bottomY)) continue;
                    set.add(tmp.getX());
                }
                if (!preFind || !posFind) continue block3;
                double leftX = verticalLines.get(pre).getX();
                double rightX = verticalLines.get(pos).getX();
                for (TableLine.VerticalLine tmp : verticalLines) {
                    double x2 = tmp.getX();
                    if (!(x2 > leftX) || !(x2 < rightX)) continue;
                    set.add(x2);
                }
                if (firstIn) {
                    ++curRowIndex;
                    firstIn = false;
                }
                TableCell cell = new TableCell(leftX, rightX, floorY, bottomY);
                cell.setColSpan(set.size() + 1);
                cell.setRowIndex(curRowIndex);
                cell.setColIndex(++colCount);
                rowNum = Math.max(curRowIndex, rowNum);
                colNum = Math.max(colCount, colNum);
                TableLine.VerticalLine left = verticalLines.get(pre);
                TableLine.VerticalLine right = verticalLines.get(pos);
                double middle = (left.getX() + right.getX()) / 2.0;
                if (CellAnalyser.isInLine(floorLines, middle)) {
                    if (CellAnalyser.isInLine(bottomLines, middle)) {
                        cell.setRowSpan(1);
                    } else {
                        cell.setRowSpanStatus(1);
                    }
                } else if (CellAnalyser.isInLine(bottomLines, middle)) {
                    cell.setRowSpanStatus(-1);
                } else {
                    cell.setRowSpanStatus(0);
                }
                list.add(cell);
            }
        }
        List waitRowCombineCells = list.stream().filter(x -> x.getRowSpanStatus() != null).sorted((o1, o2) -> {
            Double xEnd1 = o1.getXEnd();
            Double xEnd2 = o2.getXEnd();
            Integer rowIndex1 = o1.getRowIndex();
            Integer rowIndex2 = o2.getRowIndex();
            if (Double.compare(xEnd1, xEnd2) == -1) {
                return 1;
            }
            if (Double.compare(xEnd1, xEnd2) == 1) {
                return -1;
            }
            return rowIndex1 - rowIndex2;
        }).collect(Collectors.toList());
        ArrayList<TableCell> rowCombinedCell = new ArrayList<TableCell>();
        TableCell cell = null;
        for (TableCell c : waitRowCombineCells) {
            if (cell == null) {
                cell = c;
                continue;
            }
            Double xEnd = cell.getXEnd();
            if (!xEnd.equals(c.getXEnd())) {
                rowCombinedCell.add(cell);
                cell = c;
                continue;
            }
            if (c.getRowSpanStatus() == 1) {
                rowCombinedCell.add(cell);
                cell = c;
                continue;
            }
            if (c.getRowSpanStatus() == 0) {
                cell.setYEnd(c.getYEnd());
                cell.setRowSpan((cell.getRowSpan() == null ? 1 : cell.getRowSpan()) + 1);
                continue;
            }
            cell.setYEnd(c.getYEnd());
            cell.setRowSpan((cell.getRowSpan() == null ? 1 : cell.getRowSpan()) + 1);
            rowCombinedCell.add(cell);
            cell = null;
        }
        if (cell != null) {
            rowCombinedCell.add(cell);
        }
        List<TableCell> cellAll = list.stream().filter(x -> x.getRowSpanStatus() == null).collect(Collectors.toList());
        cellAll.addAll(rowCombinedCell);
        Collections.sort(cellAll);
        CellAnalyser.denseCols(cellAll);
        return new TableInfo(rowNum, colNum, tableXStart, tableYStart, tableXEnd, tableYEnd, cellAll);
    }

    private static boolean isInLine(List<TableLine.HorizonLine> lines, Double d) {
        for (TableLine.HorizonLine l : lines) {
            double xStart = l.getXStart();
            double xEnd = l.getXEnd();
            if (!(d > xStart) || !(d < xEnd)) continue;
            return true;
        }
        return false;
    }

    private static void denseCols(List<TableCell> cells) {
        int curRow = 0;
        int preCol = 0;
        for (TableCell cell : cells) {
            Integer rowIndex = cell.getRowIndex();
            if (curRow == 0) {
                curRow = rowIndex;
                preCol = 1;
                cell.setColIndex(preCol);
                continue;
            }
            if (rowIndex == curRow) {
                cell.setColIndex(++preCol);
                continue;
            }
            if (rowIndex <= curRow) continue;
            curRow = rowIndex;
            preCol = 1;
            cell.setColIndex(preCol);
        }
    }

    private static void stretchVerticalLine(List<TableLine.VerticalLine> verticalLines) {
        verticalLines.forEach(x -> {
            x.setYStart(x.getYStart() - 4.0);
            x.setYEnd(x.getYEnd() + 4.0);
            x.setLength(x.getLength() + 8.0);
        });
    }

    private static void stretchHorizonLine(List<TableLine.HorizonLine> horizonLines) {
        horizonLines.forEach(x -> {
            x.setXStart(x.getXStart() - 8.0);
            x.setXEnd(x.getXEnd() + 8.0);
            x.setLength(x.getLength() + 16.0);
        });
    }

    private static void unifyVerticalLine(List<TableLine.VerticalLine> verticalLines) {
        TreeSet treeSet = new TreeSet((o1, o2) -> {
            if (Math.abs(o1 - o2) <= 8.0) {
                return 0;
            }
            if (o1 - o2 > 8.0) {
                return 1;
            }
            return -1;
        });
        verticalLines.forEach(x -> treeSet.add(x.getX()));
        verticalLines.forEach(x -> {
            double x1 = x.getX();
            for (Double d : treeSet) {
                if (!(Math.abs(d - x1) < 8.0)) continue;
                x.setX(d);
                break;
            }
        });
    }

    private static void unifyHorizonLine(List<TableLine.HorizonLine> horizonLines) {
        TreeSet treeSet = new TreeSet((o1, o2) -> {
            if (Math.abs(o1 - o2) <= 4.0) {
                return 0;
            }
            if (o1 - o2 > 4.0) {
                return 1;
            }
            return -1;
        });
        horizonLines.forEach(horizonLine -> treeSet.add(horizonLine.getY()));
        horizonLines.forEach(x -> {
            double y1 = x.getY();
            for (Double d : treeSet) {
                if (!(Math.abs(d - y1) < 4.0)) continue;
                x.setY(d);
                break;
            }
        });
    }

    static {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 800, 900);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(3.0f));
    }
}

