import math
import sys
from pyclbr import Class

from PyPDF2 import PdfReader
import os
import re
import json
import fitz   # PyMuPDF PDF相关操作
import json
import PyPDF2  # PDF相关操作
import numpy as np
import operator
import pandas as pd  # 用于结构化表格
import fitz   # PyMuPDF PDF相关操作
import PyPDF2  # PDF相关操作
from typing import List

import sys

sys.stdout.reconfigure(encoding='utf-8')

#-*- coding: utf-8
class Text:
    """文本类，用于封装提取的文本内容 """

    def __init__(self,
                 title: str = None,
                 section: dict = {},
                 summary: str = None):
        """
        参数:
        - title: str，文本标题
        - section: dict, key:章节名称 value:章节文字内容
        - summary: str,  摘要
        """
        self.title = title
        self.section = section
        self.summary = summary


class PDFImage:
    """图片类，用于封装提取的图片信息 """

    def __init__(self,
                 title: str,
                 image_data: object,
                 page_num: int):
        """
        参数:
        - title: str，图片标题
        - image_data: 图片数据的表示形式，可以是字节流、文件路径等
        - page_num: int: 图片所在页数
        """
        self.title = title
        self.image_data = image_data
        self.page_num = page_num


class Table:
    """表格类，用于封装提取的表格信息 """

    def __init__(self,
                 title: str,
                 table_data: pd.DataFrame,
                 page_num: int,
                 bbox: None,
                 rowCellBbox:None,
                 pageHeight:None,
                 pageWidth:None):
        """
        参数:
        - title: str，表格标题
        - table_data: 表格数据，可以是 Pandas DataFrame 等形式
        - page_num: int: 表格所在页数
        """
        self.title = title
        self.table_data = table_data
        self.page_num = page_num
        self.bbox = bbox
        self.rowCellBbox = rowCellBbox
        self.pageHeight = pageHeight
        self.pageWidth = pageWidth

class Reference:
    """参考文献类，用于封装提取的参考文献信息 """

    def __init__(self, ref: str):
        """
        参数:
        - ref: str，参考文献
        """
        self.ref = ref


class PDFOutliner:
    """
    该类用于获取给定PDF的所有章节的标题
    该类对下面的代码做了一些修改，核心算法来自下面仓库
    https://github.com/beaverden/pdftoc/tree/main
    """

    def __init__(self):
        self.titles = []  # 每一个章节的标题

    def get_tree_pages(self, root, info, depth=0, titles=[]):
        """
            Recursively iterate the outline tree
            Find the pages pointed by the outline item
            and get the assigned physical order id
            Decrement with padding if necessary
        """
        if isinstance(root, dict):
            page = root['/Page'].get_object()
            t = root['/Title']
            title = t
            if isinstance(t, PyPDF2.generic.ByteStringObject):
                title = t.original_bytes.decode('utf8')
            title = title.strip()
            title = title.replace('\n', '')
            title = title.replace('\r', '')
            page_num = info['all_pages'].get(id(page), 0)
            if page_num == 0:
                # TODO: logging
                print('Not found page number for /Page!', page)
            elif page_num < info['padding']:
                page_num = 0
            else:
                page_num -= info['padding']
            str_val = '%-5d' % page_num
            str_val += '\t' * depth
            str_val += title + '\t' + '%3d' % page_num
            self.titles.append(title)
            return
        for elem in root:
            self.get_tree_pages(elem, info, depth+1)

    def recursive_numbering(self, obj, info):
        """
            Recursively iterate through all the pages in order and
            assign them a physical order number
        """
        if obj['/Type'] == '/Page':
            obj_id = id(obj)
            if obj_id not in info['all_pages']:
                info['all_pages'][obj_id] = info['current_page_id']
            info['current_page_id'] += 1
            return
        elif obj['/Type'] == '/Pages':
            for page in obj['/Kids']:
                self.recursive_numbering(page.get_object(), info)

    def create_text_outline(self, pdf_path, page_number_padding):
        # print('Running the script for [%s] with padding [%d]' % (pdf_path, page_number_padding))
        # creating an object
        titles = []
        with open(pdf_path, 'rb') as file:
            fileReader = PyPDF2.PdfReader(file)

            info = {
                'all_pages': {},
                'current_page_id': 1,
                'padding': page_number_padding
            }

            pages = fileReader.trailer['/Root']['/Pages'].get_object()
            self.recursive_numbering(pages, info)
            # for page_num, page in enumerate(pages['/Kids']):
            #    page_obj = page.getObject()
            #    all_pages[id(page_obj)] = page_num + 1
            self.get_tree_pages(fileReader.outline, info, 0, titles)
        return


class PDFParser:
    """PDF 解析器类，用于提取 PDF 中的文本、图片、表格和参考文献信息 """

    def __init__(self, pdf_path: str):
        """
        参数:
        - pdf_path: str，PDF 文件的路径
        """
        self.pdf_path = pdf_path
        self.doc = fitz.open(self.pdf_path)  # PyMuPDF fitz.Document
        self.text = Text()   # text: Text, 文字内容
        self.images = []     # list, 所有图片（PDFImage）
        self.tables = []     # list, 所有表格（Table）
        self.references = []  # list, 所有参考（Reference）

    def extract_title(self):
        """
        获取pdf标题
        """
        doc = self.doc
        first_page = doc.load_page(0)  # 获取第一页
        # 提取第一页的文本内容
        text = first_page.get_text()
        # 按行拆分文本内容
        lines = text.split('\n')
        # 获取第一行文本
        first_line = lines[0].strip()
        self.text.title = first_line
        return

    def extract_sections_content(self,
                                 doc: fitz.Document,
                                 section_titles: List[str]):
        """
        根据章节名称列表提取PDF中各章节的文字内容。
        参数：
        - pdf_file: 包含章节的PDF文件路径。
        - section_titles: 包含所有章节名称的列表。

        返回值：
        - 一个字典，键是章节名称，值是该章节的文字内容。
        """
        sections_content = {}  # 存储章节名称和内容的字典
        # 获取所有章节名称
        filtered_section_titles = [PDFParser.remove_leading_digits(
            title).strip() for title in section_titles]
        # 对于每一个章节名称，遍历所有文字行，如果文字行内包含了该章节的名称则加下去将文字行加入到该章节文字内容中
        # 如果文字行包含了下一个章节的名称则停止将文字行加入到该章节文字内容中
        for i, section_title in enumerate(filtered_section_titles):
            section_found = False
            section_content = ""
            scan_page = True
            for page_num in range(len(doc)):
                page = doc[page_num]
                page_text = page.get_text()
                for line in page_text.split('\n'):
                    # 如果找到了下一章的标题则跳出
                    if i+1 < len(filtered_section_titles) and filtered_section_titles[i+1].lower() in line.lower():
                        scan_page = False
                        break
                    if section_title.lower() in line.lower():
                        section_found = True
                    elif section_found:
                        # 如果找到了目标标题，开始获取章节内容
                        section_content += line + "\n"
                if not scan_page:
                    break

            if section_found:
                sections_content[section_titles[i]] = section_content

        return sections_content

    @staticmethod
    def remove_leading_digits(text: str):
        """
        删除输入文字开头的数字。
        """
        while text and text[0].isdigit():
            text = text[1:]  # 删除第一个字符
        return text

    def extract_text(self):
        """
        提取PDF中的文本内容
        """
        # 1 获取标题
        self.extract_title()
        # 2 获取章节名称
        outliner = PDFOutliner()
        outliner.create_text_outline(self.pdf_path, 0)
        # 3 获取对应章节下的文字内容
        self.text.section = self.extract_sections_content(
            self.doc, outliner.titles)
        return

    def extract_images(self, fig_caption_start: str = 'Figure'):
        """
        提取 PDF 中的图片信息: 图片和图片的标题
        fig_caption_start: str，图片标题开始词
        """
        doc = self.doc

        for page_num in range(len(doc)):
            page = doc[page_num]
            # 提取页面文本块
            blocks = page.get_text('blocks')
            # 通过计算文本块与图片的距离来匹配图片和对应的标题，
            # 文本块有特定的开始词开始且距离（欧氏距离）离图片最近的文本块的文字为当前图片的标题
            for img in page.get_images(full=True):
                xref = img[0]
                base_image = doc.extract_image(xref)
                x0, y0, x1, y2 = page.get_image_rects(xref)[0]
                related_text = "untitled"
                min_dist = float('inf')
                for block in blocks:
                    block_x0, block_y0, block_x1, block_y1, block_text = block[:5]
                    if block_text.strip().startswith(fig_caption_start):
                        # 计算欧式距离
                        dist = (x0 - block_x0)**2 + (y0 - block_y0)**2
                        if dist < min_dist:
                            min_dist = dist
                            related_text = block_text.strip()

                image_data = base_image["image"]
                image = PDFImage(related_text, image_data, page_num)
                self.images.append(image)

    def extract_tables(self, tab_caption_start: str = 'Table'):
        """
        提取 PDF 中的表格信息
        tab_caption_start: str, 表格标题开始词
        """
        doc = self.doc
        df = pd.DataFrame()
        last_tab_page = 0
        last_tab_has_text = True
        last_cell_has_text = False
        bbox = None
        rowCellBbox = None
        for num in range(len(doc)):
            page = doc[num]
            # 提取页面文本块
            blocks = page.get_text('blocks')
            # 提取表格
            tables = page.find_tables()

            # 通过计算文本块与表格的距离来匹配图片和对应的标题，
            # 文本块有特定的开始词且距离（欧氏距离）离表格最近的文本块的文字为当前图片的标题
            for table in tables:
                x0, y0, x1, y2 = table.bbox
                df_this = table.to_pandas()
                bbox_this = table.bbox
                rowCellBbox_this = table.rows
                this_page = page.number

                for row in rowCellBbox_this:
                    row.page_num = num
                if df.size==0 and len(df.axes)==0:
                    df = df_this
                    bbox = bbox_this
                    rowCellBbox = rowCellBbox_this
                    last_tab_page = page.number
                    if len(blocks) > 0:
                        if blocks[len(blocks) - 1][3] > y2:
                            last_tab_has_text = True
                        else:
                            last_tab_has_text = False
                    continue
                if this_page - last_tab_page == 1 and (not last_tab_has_text) and len(df_this.columns) == len(df.columns):
                    hasTextBefore = False
                    # 判断表格是否在当前页最前
                    if len(blocks) > 0 :
                        for ll in range(len(blocks)):
                            if blocks[ll][4].replace('\n', '').replace('\r', '').replace(' ', '') and blocks[ll][1] > page.rect.height*0.06 and blocks[ll][3] < page.rect.height*0.9 and blocks[ll][3] < y0:
                                hasTextBefore = True
                                break
                    # 是否合并行
                    isSameRow = False
                    if df_this.columns[0].startswith("Col"):
                        isSameRow = True

                    if not hasTextBefore:
                        df2_columns = pd.DataFrame([df_this.columns], columns=df.columns)
                        # 遍历数组对象，判断每项内容是否为列索引-文本，如果是，去除列索引-，仅保留文本
                        for index, row in df2_columns.iterrows():
                            for i in range(len(df2_columns.columns)):
                                if isinstance(row[df2_columns.columns[i]], str) :
                                    if operator.contains(row[df2_columns.columns[i]],"-") :
                                        if row[df2_columns.columns[i]].startswith(str(i)):
                                            row[df2_columns.columns[i]] = row[df2_columns.columns[i]].split("-")[1]
                        start = 0
                        for index, row in df.iterrows():
                            start = start + 1
                        df_this.columns = df.columns
                        df = pd.concat([df,df2_columns, df_this],ignore_index=True)
                        rowCellBbox = rowCellBbox+rowCellBbox_this
                        last_tab_page = this_page
                        # 合并行
                        if isSameRow:
                            merged_data = []
                            current_row = None
                            current_row_bbox = None
                            if start==0:
                                current_row = df_this.columns.tolist()

                            for index, row in df.iterrows():
                                row_values = row.values.tolist()
                                row_bbox = rowCellBbox[index]

                                if current_row is None:
                                    current_row = row_values
                                    current_row_bbox = row_bbox
                                else:
                                    if index==start and isSameRow:
                                        # 合并行
                                        for i in range(len(row_values)):
                                            if pd.notna(row_values[i]):
                                                a = re.compile('Col\\d{1,2}').sub('', row_values[i]).replace(' ','')
                                                current_row[i] = f"{current_row[i]} {a}".strip()
                                        current_row_bbox = current_row_bbox

                                        if start==0:
                                            df.columns = current_row
                                            current_row = None
                                    else:
                                        # 添加当前行到合并数据
                                        merged_data.append(current_row)
                                        current_row = row_values
                                        current_row_bbox = row_bbox

                            if current_row is not None:
                                merged_data.append(current_row)

                            df =pd.DataFrame(merged_data, columns=df.columns)
                        continue

                self.tables.append(Table(title="untitled",
                                         table_data=df,
                                         page_num=num,
                                         bbox=bbox,
                                         rowCellBbox=rowCellBbox,
                                         pageHeight=page.rect.height,
                                         pageWidth=page.rect.width))
                if len(blocks) > 0 :
                    if blocks[len(blocks) - 1][3] > y2:
                        last_tab_has_text = True
                    else:
                        last_tab_has_text = False
                        last_tab_page = page.number
                        df = df_this
                        bbox = bbox_this
                        rowCellBbox = rowCellBbox_this

                        continue

                last_tab_page = page.number
                df = df_this
                bbox = bbox_this
                rowCellBbox = rowCellBbox_this
        self.tables.append(Table(title="untitled",
                                 table_data=df,
                                 page_num=len(doc)-1,
                                 bbox=bbox,
                                 rowCellBbox=rowCellBbox,
                                 pageHeight=page.rect.height,
                                 pageWidth=page.rect.width))

    def merge_bboxes(self, bbox1, bbox2):
        """
        合并两个边界框
        """
        x0 = min(bbox1[0], bbox2[0])
        y0 = min(bbox1[1], bbox2[1])
        x1 = max(bbox1[2], bbox2[2])
        y1 = max(bbox1[3], bbox2[3])
        return (x0, y0, x1, y1)

    def extract_references(self):
        """
        提取 PDF 中的参考文献信息
        """
        doc = self.doc
        page_num = len(doc)
        ref_list = []
        for num, page in enumerate(doc):
            content = page.get_text('blocks')
            for pc in content:
                txt_blocks = list(pc[4:-2])
                txt = ''.join(txt_blocks)
                if 'References' in txt or 'REFERENCES' in txt or 'referenCes' in txt:
                    ref_num = [i for i in range(num, page_num)]
                    for rpn in ref_num:
                        ref_page = doc[rpn]
                        ref_content = ref_page.get_text('blocks')
                        for refc in ref_content:
                            txt_blocks = list(refc[4:-2])
                            ref_list.extend(txt_blocks)
        index = 0
        for i, ref in enumerate(ref_list):
            if 'References' in ref or 'REFERENCES' in ref or 'referenCes' in ref:
                index = i
                break
        if index + 1 < len(ref_list):
            index += 1
        self.references = [Reference(ref.replace('\n', ''))
                           for ref in ref_list[index:] if len(ref) > 10]
class Tablecell:
    def __init__(self,text,pagenum,row,col,bbox=None):
        self.text = text
        self.pagenum = pagenum
        self.row = row
        self.col = col
        self.bbox = bbox

class Tabledata:
    def __init__(self,index,pagenum,bbox,pageHeight,pageWidth):
        self.bbox = bbox
        self.index = index
        self.pagenum = pagenum
        self.pageHeight = pageHeight
        self.pageWidth = pageWidth
        self.cells = list()

class Textdata:
    def __init__(self,index,pagenum,text):
        self.index = index
        self.pagenum = pagenum
        self.text = text

class PdfInfo:

    def __init__(self):
        self.tables = list()
        self.textBlocks = list()

def extract_table(parser,resultData,tableinfos):
    for i, table in enumerate(parser.tables):
        data = Tabledata(i,table.page_num,table.bbox,table.pageHeight,table.pageWidth)
        rowCellBbox = table.rowCellBbox
        ss = table.table_data.axes
        row_value_one = ""
        start = 0
        if rowCellBbox and len(table.table_data.values) < len(rowCellBbox):
            start = 1
            for i,value in enumerate(ss[1]):
                txt = re.compile('Col\\d{1,2}').sub('', str(value)).replace('None','').replace(' ','')
                if rowCellBbox[0] and rowCellBbox[0].cells and rowCellBbox[0].cells[i] :
                    data.cells.append(Tablecell(txt,rowCellBbox[0].page_num,0,i,rowCellBbox[0].cells[i]))
                else:
                    data.cells.append(Tablecell(txt,rowCellBbox[0].page_num,0,i,None))
                row_value_one = row_value_one + txt
            # tableinfos.add(row_value_one)
        row_value = ""
        for rownumber, row in table.table_data.iterrows():
            for cellnumber,key in enumerate(ss[1]):
                txt = re.compile('Col\\d{1,2}').sub('', str(row[key])).replace('None','').replace(' ','')
                if len(rowCellBbox)>rownumber+start and rowCellBbox[rownumber+start] and rowCellBbox[rownumber+start].cells and len(rowCellBbox[rownumber+start].cells)>cellnumber and rowCellBbox[rownumber+start].cells[cellnumber] :
                    data.cells.append(Tablecell(txt,rowCellBbox[rownumber+start].page_num,rownumber+start,cellnumber,rowCellBbox[rownumber+start].cells[cellnumber]))
                else:
                    data.cells.append(Tablecell(txt,rowCellBbox[rownumber+start].page_num,rownumber+start,cellnumber,None))

                if row[key] is None :
                    row_value = row_value + ""
                else:
                    row_value = row_value + txt
            # tableinfos.add(row_value.replace('\n', '').replace('\r', '').replace(' ', ''))
        resultData.tables.append(data)
    return resultData

def extract_text(pdf_path,resultData,tableinfos,water_data):
    with fitz.open(pdf_path) as pdf:
        for page in pdf:
            skew_data = set()
            block_span = page.get_text("dict")["blocks"]
            for block in block_span:
                lines = block.get("lines")
                if lines is None:
                    continue
                for line in lines:
                    spans = line.get("spans")
                    if spans is None:
                        continue
                    for span in line.get("spans"):
                        bbox = span["bbox"]
                        text = span["text"]
                        width = bbox[2] - bbox[0]
                        height = bbox[3] - bbox[1]
                        color = span["color"]
                        if width != 0:
                            angle = math.degrees(math.atan(height / width))
                        else:
                            angle = 90.0
                        if line["dir"] != (1, 0):
                            skew_data.add(text.replace(' ', ''))

            for block in block_span:
                block_text = ''
                # 获取文本块内的内容
                lines = block.get("lines", [])  # 安全获取 lines，如果不存在则返回空列表
                if not lines:
                    continue

                for line in lines:
                    spans = line.get("spans", [])  # 安全获取 spans，如果不存在则返回空列表
                    if not spans:
                        continue
                    for span in spans:
                        if span and span['text']:
                            block_text = block_text + span['text']

                isInTable = False
                if resultData and resultData.tables:
                    for table in resultData.tables:
                        if table.pagenum==page.number and table.bbox and table.bbox[0]<=block['bbox'][0]+5 and table.bbox[1]<=block['bbox'][1]+5 and table.bbox[2]>=block['bbox'][2] and table.bbox[3]>=block['bbox'][3]:
                            # 在表格内，不作操作
                            isInTable = True
                            break
                if isInTable:
                    if not (block_text.replace('\n', '').replace('\r', '') in skew_data):
                        tableinfos.add(block_text.replace('\n', '').replace('\r', ''))
                    elif block_text.replace('\n', '').replace('\r', '').replace(' ', '') not in tableinfos:
                        water_data.add(block_text.replace('\n', '').replace('\r', '').replace(' ', ''))

                else:
                    if not (block_text.replace('\n', '').replace('\r', '') in skew_data):
                        resultData.textBlocks.append(Textdata(block['number'], page.number,block_text))
                    elif block_text.replace('\n', '').replace('\r', '').replace(' ', '') not in tableinfos:
                        water_data.add(block_text.replace('\n', '').replace('\r', '').replace(' ', ''))
    return resultData

def extract_text_with_table(pdf_path,resultData):
    with fitz.open(pdf_path) as pdf:
        for page in pdf:
            skew_data = set()
            block_text = page.get_text("blocks")

            for block in page.get_text("dict")["blocks"]:

                lines = block.get("lines")
                if lines is None:
                    continue

                for line in lines:
                    spans = line.get("spans")
                    if spans is None:
                        continue
                    for span in line.get("spans"):
                        bbox = span["bbox"]
                        text = span["text"]
                        width = bbox[2] - bbox[0]
                        height = bbox[3] - bbox[1]
                        if width != 0:
                            angle = math.degrees(math.atan(height / width))
                        else:
                            angle = 90.0
                        if angle > 40:
                            skew_data.add((text.replace(' ', ''), angle))
            for b_i, block in enumerate(block_text):
                if not (block[4].replace('\n', '').replace('\r', '') in skew_data):
                    resultData.textBlocks.append(Textdata(b_i, page.number,block[4]))
    return resultData

if __name__ == '__main__':
    pdf_path = sys.argv[1]
    # pdf_path = "D:\linkunpeng\Desktop\智能预审\2.0\测试文件\文档对比\日钢现场\2\烧结制造部13#14#15#18#19#环冷机增加环形皮带项目技术协议20250210+(3).pdf"
    tableinfos = set()
    parser = PDFParser(pdf_path)
    parser.extract_tables()
    resultData = PdfInfo()

    water_data = set()

    resultData = extract_text(pdf_path,extract_table(parser,resultData,tableinfos),tableinfos,water_data)
    for index, item in enumerate(resultData.tables):
        for i,tb in enumerate(item.cells):

            if tb.text is None or not operator.contains(tb.text,"\n"):
                continue
            new_text = ''
            for stext in re.split('\n| |',tb.text):
                bool_water = True
                for water_text in water_data:
                    if stext.replace(' ', '').replace('\r', '') in water_text:
                        bool_water = False
                if bool_water:
                    new_text += stext
            tb.text = new_text

    text = json.dumps(resultData, ensure_ascii=False, default=lambda o: o.__dict__, sort_keys=True, indent=4)
    print(text)
