/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.file;

import java.io.File;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class LibreOfficePDFConvert {
    @Autowired
    private Environment environments;
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficePDFConvert.class);
    private static String officeHomeDir = null;
    private static Environment environment;

    @PostConstruct
    public void staticInit() {
        environment = this.environments;
    }

    public static synchronized String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File outputFile = LibreOfficePDFConvert.convert(sourceFile, tarPdfFile);
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    public static File convert(File sourceFile, File tarPdfFile) throws OfficeException {
        File inputFile = sourceFile;
        officeHomeDir = environment.getProperty("docbase.libreOffice.path");
        Integer port = (Integer)environment.getProperty("docbase.libreOffice.port", Integer.class);
        String libreOfficePath = LibreOfficePDFConvert.getOfficeHome();
        DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
        builder.setOfficeHome(new File(libreOfficePath));
        builder.setPortNumbers(new int[]{port});
        builder.setTaskExecutionTimeout(3000000L);
        builder.setTaskQueueTimeout(864000000L);
        OfficeManager officeManager = builder.build();
        File outputFile = null;
        try {
            LibreOfficePDFConvert.startService(officeManager);
            OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
            outputFile = tarPdfFile;
            converter.convert(inputFile, outputFile);
            LibreOfficePDFConvert.stopService(officeManager);
        }
        catch (Exception e) {
            if (officeManager.isRunning()) {
                LibreOfficePDFConvert.stopService(officeManager);
            }
            logger.error("office\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)e);
            throw new OfficeException("office\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)e);
        }
        return outputFile;
    }

    public static File word2pdf(File sourceFile, File tarPdfFile) throws OfficeException {
        File inputFile = sourceFile;
        DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
        builder.setOfficeHome(new File("D:\\Program Files\\LibreOffice"));
        builder.setPortNumbers(new int[]{8100});
        builder.setTaskExecutionTimeout(3000000L);
        builder.setTaskQueueTimeout(864000000L);
        OfficeManager officeManager = builder.build();
        File outputFile = null;
        try {
            LibreOfficePDFConvert.startService(officeManager);
            OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
            outputFile = tarPdfFile;
            converter.convert(inputFile, outputFile);
            LibreOfficePDFConvert.stopService(officeManager);
        }
        catch (Exception e) {
            if (officeManager.isRunning()) {
                LibreOfficePDFConvert.stopService(officeManager);
            }
            logger.error("office\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)e);
            throw new OfficeException("office\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)e);
        }
        return outputFile;
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "D:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice6.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    public static void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }
}

