/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.user;

import com.jxdinfo.idp.common.user.entity.SysRolesVo;
import com.jxdinfo.idp.common.user.entity.SysUserRoleVo;
import com.jxdinfo.idp.common.user.entity.SysUsersVo;
import com.jxdinfo.idp.common.user.service.UserLoginService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserUtils {
    @Autowired
    private UserLoginService userLoginServices;
    private static UserLoginService userLoginService;

    @PostConstruct
    public void staticInit() {
        userLoginService = this.userLoginServices;
    }

    public static Long getLoginUserId() {
        return userLoginService.getUserId();
    }

    public static SysUsersVo getLoginUser() {
        return userLoginService.getUser();
    }

    public static Map<Long, SysUsersVo> getAllUserInfoMap() {
        List<SysUsersVo> allUserInfo = userLoginService.getAllUserInfo();
        HashMap<Long, SysUsersVo> map = new HashMap<Long, SysUsersVo>();
        allUserInfo.forEach(sysUsersVo -> map.put(sysUsersVo.getId(), (SysUsersVo)sysUsersVo));
        return map;
    }

    public static Map<Long, List<SysUserRoleVo>> getAllUserRoleMap() {
        List<SysUserRoleVo> allUserRole = userLoginService.getAllUserRole();
        HashMap<Long, List<SysUserRoleVo>> map = new HashMap<Long, List<SysUserRoleVo>>();
        allUserRole.forEach(sysUserRoleVo -> map.computeIfAbsent(sysUserRoleVo.getUserId(), k -> new ArrayList()).add(sysUserRoleVo));
        return map;
    }

    public static Map<Long, SysRolesVo> getAllRoleMap() {
        List<SysRolesVo> allRole = userLoginService.getAllRole();
        HashMap<Long, SysRolesVo> map = new HashMap<Long, SysRolesVo>();
        allRole.forEach(sysRolesVo -> map.put(sysRolesVo.getId(), (SysRolesVo)sysRolesVo));
        return map;
    }
}

