/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse.word;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordFooter;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordHeader;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.enums.DocRegularEnum;
import com.jxdinfo.idp.common.util.docparse.word.WordStructureUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.HeaderStories;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocStructureUtil
extends WordStructureUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocStructureUtil.class);

    @Override
    public WordInfo getWordInfo(InputStream is, String fileName) {
        WordInfo result = new WordInfo();
        try (HWPFDocument document = new HWPFDocument(is);){
            ArrayList<WordChapterInfo> chapterInfos = new ArrayList<WordChapterInfo>();
            result.setChapterInfos(chapterInfos);
            ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
            result.setElementInfos(elementInfos);
            Range range = document.getRange();
            int index = 0;
            for (int i = 0; i < range.numParagraphs(); ++i) {
                WordElementInfo info;
                Paragraph p = range.getParagraph(i);
                int titleLevel = p.getLvl();
                String text = this.getMarkedUnDeleted(p);
                if (p.isInTable()) {
                    if (i != 0 && range.getParagraph(i - 1).isInTable()) continue;
                    info = new WordTableInfo();
                    elementInfos.add(info);
                    result.getTableInfos().add((WordTableInfo)info);
                    info.setType("table");
                    info.setPoiIndex(i);
                    info.setIndex(index);
                    ++index;
                    this.assembleTable((WordTableInfo)info, range.getTable(p));
                    continue;
                }
                info = new WordParagraphInfo();
                elementInfos.add(info);
                info.setType("para");
                info.setIndex(index);
                info.setPoiIndex(i);
                ((WordParagraphInfo)info).setText(DocRegularEnum.matchCatalog(text));
                ++index;
                if (titleLevel == 9 || !StringUtils.isNotEmpty((CharSequence)text)) continue;
                WordChapterInfo chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName(text);
                chapterInfo.setLevel(titleLevel);
                chapterInfo.setStartIndex(index);
                chapterInfos.add(chapterInfo);
            }
            this.assembleChapter(chapterInfos, elementInfos);
        }
        catch (IOException e) {
            log.error("doc\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
        return result;
    }

    private void assembleChapter(List<WordChapterInfo> chapterInfos, List<WordElementInfo> elementInfos) {
        block0: for (int i = 0; i < chapterInfos.size() - 1; ++i) {
            for (int j = i + 1; j < chapterInfos.size(); ++j) {
                WordChapterInfo current = chapterInfos.get(i);
                WordChapterInfo next = chapterInfos.get(j);
                if (next.getLevel() <= current.getLevel()) {
                    current.setEndIndex(next.getStartIndex());
                    continue block0;
                }
                if (j != chapterInfos.size() - 1) continue;
                current.setEndIndex(elementInfos.size());
                continue block0;
            }
        }
        if (CollectionUtil.isNotEmpty(chapterInfos)) {
            chapterInfos.get(chapterInfos.size() - 1).setEndIndex(elementInfos.size());
        }
        for (WordChapterInfo chapterInfo : chapterInfos) {
            chapterInfo.setEInfoList(new ArrayList<WordElementInfo>());
            StringBuilder text = new StringBuilder();
            for (int i = chapterInfo.getStartIndex().intValue(); i < chapterInfo.getEndIndex(); ++i) {
                WordElementInfo eInfo = elementInfos.get(i);
                chapterInfo.getEInfoList().add(eInfo);
                if (i <= chapterInfo.getStartIndex()) continue;
                if ("para".equals(eInfo.getType())) {
                    WordParagraphInfo pInfo = (WordParagraphInfo)eInfo;
                    text.append(pInfo.getText()).append("\n");
                    continue;
                }
                if (!"table".equals(eInfo.getType())) continue;
                text.append("\u3010\u8868\u683c\u3011\n");
            }
            chapterInfo.setText(text.toString());
        }
    }

    private void assembleTable(WordTableInfo tInfo, Table table) {
        ArrayList<WordRowInfo> rowInfos = new ArrayList<WordRowInfo>();
        tInfo.setRows(rowInfos);
        for (int j = 0; j < table.numRows(); ++j) {
            WordRowInfo rowInfo = new WordRowInfo();
            rowInfos.add(rowInfo);
            rowInfo.setIndex(j);
            ArrayList<WordCellInfo> cellInfos = new ArrayList<WordCellInfo>();
            rowInfo.setCells(cellInfos);
            TableRow row = table.getRow(j);
            for (int k = 0; k < row.numCells(); ++k) {
                WordCellInfo cellInfo = new WordCellInfo();
                cellInfos.add(cellInfo);
                cellInfo.setIndex(k);
                TableCell cell = row.getCell(k);
                cellInfo.setText(cell.text().replaceAll("[\u0007|\\t|\\n|\u00a0+]", "").trim());
                ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
                cellInfo.setElementInfos(elementInfos);
                int index = 0;
                for (int l = 0; l < cell.numParagraphs(); ++l) {
                    Paragraph para = cell.getParagraph(l);
                    WordParagraphInfo info = new WordParagraphInfo();
                    elementInfos.add(info);
                    info.setIndex(index);
                    ++index;
                    info.setPoiIndex(l);
                    info.setType("para");
                    info.setText(this.getMarkedUnDeleted(para));
                }
            }
        }
    }

    private List<WordFooter> getFooters(HWPFDocument doc) {
        ArrayList<WordFooter> result = new ArrayList<WordFooter>();
        HeaderStories headerStories = new HeaderStories(doc);
        Range range = doc.getRange();
        int numSections = range.numSections();
        int pageCount = 0;
        for (int s = 0; s < numSections; ++s) {
            pageCount += range.getSection(s).numParagraphs();
        }
        for (int i = 0; i < pageCount; ++i) {
            WordFooter wordFooter = new WordFooter();
            wordFooter.setIndex(i);
            wordFooter.setText(headerStories.getFooter(i));
            result.add(wordFooter);
        }
        return result;
    }

    private List<WordHeader> getHeaders(HWPFDocument doc) {
        ArrayList<WordHeader> result = new ArrayList<WordHeader>();
        HeaderStories headerStories = new HeaderStories(doc);
        Range range = doc.getRange();
        int numSections = range.numSections();
        int pageCount = 0;
        for (int s = 0; s < numSections; ++s) {
            pageCount += range.getSection(s).numParagraphs();
        }
        for (int i = 0; i < pageCount; ++i) {
            WordHeader wordHeader = new WordHeader();
            wordHeader.setIndex(i);
            wordHeader.setText(headerStories.getHeader(i));
            result.add(wordHeader);
        }
        return result;
    }

    private String getMarkedUnDeleted(Paragraph p) {
        StringBuilder pText = new StringBuilder();
        for (int i = 0; i < p.numCharacterRuns(); ++i) {
            CharacterRun run = p.getCharacterRun(i);
            if (run.isMarkedDeleted()) continue;
            pText.append(run.text());
        }
        return pText.toString().trim();
    }

    public static void main(String[] args) throws IOException {
        FileInputStream inputStream = new FileInputStream("C:\\Users\\HP\\Desktop\\\u6d4b\u8bd520250126\u9879\u76ee\u6807\u4e66\u6587\u4ef6  (2).doc");
        XWPFDocument document = new XWPFDocument((InputStream)inputStream);
        System.out.println("-----end-----\u0007\u0007");
    }
}

