/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse.htmlhandler;

import com.jxdinfo.idp.common.util.docparse.SignUtil;
import com.jxdinfo.idp.common.util.docparse.htmlhandler.AbstractHtmlHandler;
import java.util.Map;
import lombok.Generated;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ContrastHtmlHandler
extends AbstractHtmlHandler {
    private Map<String, String> typeMap;
    private String dataType;

    @Override
    public void after() {
        for (Map.Entry<String, String> entry : this.typeMap.entrySet()) {
            Elements elements = this.document.getElementsByAttributeValueContaining("data-id", entry.getKey());
            for (Element element : elements) {
                this.addElementClass(element, entry.getValue());
                element.attr("data-type", this.dataType);
            }
        }
    }

    private void addElementClass(Element element, String type) {
        element.addClass(SignUtil.getEClass(type));
        String className = element.className();
        if (className.contains("border-left")) {
            element.removeClass("border-left");
            element.addClass("border-left" + type);
        } else if (className.contains("border-right")) {
            element.removeClass("border-right");
            element.addClass("border-right" + type);
        }
    }

    @Generated
    public ContrastHtmlHandler() {
    }

    @Generated
    public Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public void setTypeMap(Map<String, String> typeMap) {
        this.typeMap = typeMap;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContrastHtmlHandler)) {
            return false;
        }
        ContrastHtmlHandler other = (ContrastHtmlHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$typeMap = this.getTypeMap();
        Map<String, String> other$typeMap = other.getTypeMap();
        if (this$typeMap == null ? other$typeMap != null : !((Object)this$typeMap).equals(other$typeMap)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContrastHtmlHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $typeMap = this.getTypeMap();
        result = result * 59 + ($typeMap == null ? 43 : ((Object)$typeMap).hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContrastHtmlHandler(typeMap=" + this.getTypeMap() + ", dataType=" + this.getDataType() + ")";
    }
}

