/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.tools;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.tools.ModifiedPDFTextStripperByArea;
import com.jxdinfo.idp.common.pdfparser.tools.RenderInfo;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.text.PDFTextStripperByArea;
import org.apache.pdfbox.text.TextPosition;

public class TextTool {
    public static String reKeyAnd(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&", "\u548c");
    }

    public static String bakKeyAnd(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\u548c", "&");
    }

    public static String toJson(Object object) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fa) {
                return fa.getName().equals("startLine") || fa.getName().equals("startLineStatus") || fa.getName().equals("endLine") || fa.getName().equals("endLineStatus") || fa.getName().equals("WordStyleStruct") || fa.getName().equals("pdfStyleStructs") || fa.getName().equals("trueColIndex") || fa.getName().equals("vMerge");
            }

            public boolean shouldSkipClass(Class<?> arg0) {
                return false;
            }
        }).create();
        return gson.toJson(object);
    }

    public static String unescape(String str) {
        return StringEscapeUtils.unescapeHtml((String)str);
    }

    public static String escape(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public static String encodeTextLine(String text, float xStart, float yStart, float xEnd, float yEnd) {
        DecimalFormat decimalFormat = new DecimalFormat("000.000");
        String xStartStr = decimalFormat.format(xStart);
        String yStartStr = decimalFormat.format(yStart);
        String xEndStr = decimalFormat.format(xEnd);
        String yEndStr = decimalFormat.format(yEnd);
        return xStartStr + yStartStr + xEndStr + yEndStr + text;
    }

    public static String[] decodeTextLine(String line) {
        String xStart = line.substring(0, 7);
        String yStart = line.substring(7, 14);
        String xEnd = line.substring(14, 21);
        String yEnd = line.substring(21, 28);
        String text = line.substring(28, line.length());
        return new String[]{text, xStart, yStart, xEnd, yEnd};
    }

    public static List<Tu.Tuple2<String, Rectangle2D>> grabText(PDDocument pd, List<Rectangle2D> ranges, int pageNum) throws IOException {
        ArrayList<Tu.Tuple2<String, Rectangle2D>> result = new ArrayList<Tu.Tuple2<String, Rectangle2D>>();
        PDFTextStripperByArea stripper = new PDFTextStripperByArea();
        int count = 0;
        for (Rectangle2D rect : ranges) {
            stripper.addRegion(count + "", rect);
            ++count;
        }
        PDPage docPage = pd.getPage(pageNum - 1);
        stripper.extractRegions(docPage);
        for (int i = 0; i < count; ++i) {
            String textForRegion = stripper.getTextForRegion(i + "");
            Rectangle2D rectangle2D = ranges.get(i);
            result.add(new Tu.Tuple2<String, Rectangle2D>(textForRegion, rectangle2D));
        }
        return result;
    }

    public static List<Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>> grabTextEnhance(PDDocument pd, List<Tu.Tuple2<Boolean, Rectangle2D>> ranges, int pageNum) throws IOException {
        ArrayList<Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>> result = new ArrayList<Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>>();
        ModifiedPDFTextStripperByArea stripper = new ModifiedPDFTextStripperByArea();
        int count = 0;
        for (Tu.Tuple2<Boolean, Rectangle2D> tu : ranges) {
            stripper.addRegion(count + "", tu.getValue());
            ++count;
        }
        PDPage docPage = pd.getPage(pageNum - 1);
        PDRectangle cropBox = docPage.getCropBox();
        stripper.extractRegions(docPage);
        for (int i = 0; i < count; ++i) {
            Tu.Tuple2<Boolean, Rectangle2D> tu = ranges.get(i);
            Boolean key = tu.getKey();
            Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D> newTu = new Tu.Tuple3<List<List<Tu.Tuple2<TextPosition, RenderInfo>>>, String, Rectangle2D>();
            if (key.booleanValue()) {
                List<List<Tu.Tuple2<TextPosition, RenderInfo>>> detailedTextForRange = stripper.getDetailedTextForRange(i + "");
                newTu.setValue1(detailedTextForRange);
            } else {
                String textForRegion = stripper.getTextForRegion(i + "");
                newTu.setValue2(textForRegion);
            }
            newTu.setValue3(ranges.get(i).getValue());
            result.add(newTu);
        }
        return result;
    }

    public static boolean isContainChinese(String str) {
        String reg = "[\\u4E00-\\u9FA5]+";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isContainEnglish(String str) {
        String reg = "[A-Za-z]";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.find();
    }
}

