/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.entity.util.wordpicture;

import com.jxdinfo.idp.common.util.uuid.IdUtils;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageOutputStream;
import lombok.Generated;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class PictureManagerImpl
implements PicturesManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PictureManagerImpl.class);
    private String urlPrefix;
    private String newDirName = IdUtils.simpleUUID();

    public PictureManagerImpl(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String savePicture(byte[] bytes, PictureType pictureType, String s, float v, float v1) {
        String path = ResourceUtils.getURL((String)"classpath:").getPath() + "static/img/" + this.newDirName + "/";
        String imgName = IdUtils.simpleUUID() + s;
        if (pictureType == PictureType.EMF || pictureType == PictureType.WMF || pictureType == PictureType.UNKNOWN) {
            return "dir=" + this.newDirName + ";fileName=" + s;
        }
        File imgFile = new File(path + imgName);
        if (!imgFile.getParentFile().exists()) {
            imgFile.getParentFile().mkdirs();
        }
        try (FileImageOutputStream outputStream = new FileImageOutputStream(imgFile);){
            outputStream.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            log.error("\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return "dir=" + this.newDirName + ";fileName=" + imgName;
    }

    public String getImgDirName() {
        return this.newDirName;
    }
}

