/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse.htmlhandler;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.util.docparse.document.ElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.location.WordLocation;
import com.jxdinfo.idp.common.util.docparse.SignUtil;
import com.jxdinfo.idp.common.util.docparse.Word2HtmlUtil;
import com.jxdinfo.idp.common.util.docparse.htmlhandler.HtmlHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHtmlHandler
implements HtmlHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHtmlHandler.class);
    protected Document document;
    protected String imgDirName;

    protected Document getHtml(Map<String, Object> htmlInfo, FileBytesInfo bytesInfo, Map<String, String> matchTextMap) {
        Document document = Jsoup.parse((String)((String)htmlInfo.get("htmlStr")));
        Elements pList = document.getElementsByTag("p");
        try {
            for (Element element : pList) {
                String index2;
                String delFlag;
                Object id;
                Matcher matcher;
                List<String> regexes;
                String signText = element.text();
                if (StringUtils.isEmpty((CharSequence)signText) || !signText.contains("sign_")) continue;
                List<Element> elementList = SignUtil.findTextElements(element);
                if (signText.contains("sign_para")) {
                    regexes = SignUtil.batchMatchPara(signText);
                    for (String regex : regexes) {
                        matcher = SignUtil.matchParaProp(regex);
                        if (matcher == null) continue;
                        id = matcher.group(1);
                        delFlag = matcher.group(2);
                        index2 = matcher.group(3);
                        if ("0".equals(delFlag)) {
                            this.attrDataId(element, (String)id);
                            this.addBorders(element);
                            continue;
                        }
                        Element delElement = this.delElement((String)id);
                        if ("-1".equals(index2)) {
                            Element cloned = element.clone();
                            element.empty();
                            element.appendChild((Node)delElement);
                            element.appendChildren((Collection)cloned.children());
                            continue;
                        }
                        element.appendChild((Node)delElement);
                    }
                }
                if (signText.contains("sign_table")) {
                    regexes = SignUtil.batchMatchTable(signText);
                    for (String regex : regexes) {
                        matcher = SignUtil.matchTableProp(regex);
                        if (matcher == null) continue;
                        id = matcher.group(1);
                        delFlag = matcher.group(2);
                        index2 = matcher.group(3);
                        Element table = AbstractHtmlHandler.getTable(element);
                        if ("0".equals(delFlag)) {
                            this.attrDataId(table, (String)id);
                            this.addBorders(table);
                            continue;
                        }
                        Element delElement = this.delElement((String)id);
                        if ("-1".equals(index2)) {
                            Element cloned = table.clone();
                            table.empty();
                            table.appendChild((Node)delElement);
                            table.appendChildren((Collection)cloned.children());
                            continue;
                        }
                        table.appendChild((Node)delElement);
                    }
                }
                if (signText.contains("sign_text")) {
                    String allText = AbstractHtmlHandler.getAllText(elementList);
                    TreeSet<Integer> indices = new TreeSet<Integer>();
                    HashMap<Integer, Element> eCache = new HashMap<Integer, Element>();
                    HashMap<Integer, Element> delECache = new HashMap<Integer, Element>();
                    List<String> regexes2 = SignUtil.batchMatchText(signText);
                    for (String regex : regexes2) {
                        Matcher matcher2 = SignUtil.matchTextProp(regex);
                        if (matcher2 == null) continue;
                        String signId = matcher2.group(1);
                        String matchText = matchTextMap.get(signId);
                        int eIndex = Integer.parseInt(matcher2.group(2));
                        int eLength = Integer.parseInt(matcher2.group(3));
                        if (eIndex == -1) {
                            this.span(signId, eIndex, delECache);
                            continue;
                        }
                        if (eLength == 0) {
                            this.span(signId, eIndex, delECache);
                            indices.add(eIndex);
                            continue;
                        }
                        eIndex = AbstractHtmlHandler.proofText(allText, matchText, eIndex, eLength);
                        int eEndIndex = Math.min(eIndex + eLength, allText.length());
                        for (int i = eIndex; i < eEndIndex && i < allText.length(); ++i) {
                            Element span = this.span(signId, i, eCache);
                            if (i == eIndex) {
                                this.addLeftBorder(span);
                            }
                            if (i == eEndIndex - 1) {
                                this.addRightBorder(span);
                            }
                            span.text(String.valueOf(allText.charAt(i)));
                            indices.add(i);
                        }
                    }
                    int allLength = allText.length();
                    indices.removeIf(index -> index >= allLength);
                    List indexList = indices.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                    List<ElementInfo> elementInfos = AbstractHtmlHandler.elementInfos(elementList);
                    if (CollUtil.isEmpty(elementInfos)) continue;
                    int eleIndex = 0;
                    int textIndex = 0;
                    ElementInfo currentEInfo = elementInfos.get(eleIndex);
                    Element currentE = currentEInfo.getElement();
                    currentE.text("");
                    if (delECache.get(-1) != null) {
                        currentE.appendChild((Node)delECache.get(-1));
                    }
                    boolean flag = false;
                    for (Integer index3 : indexList) {
                        while (elementInfos.get(eleIndex).getEndIndex() < index3 || elementInfos.get(eleIndex).getLength() == 0) {
                            ++eleIndex;
                            flag = true;
                        }
                        if (flag) {
                            if (textIndex <= currentEInfo.getEndIndex()) {
                                currentE.appendText(currentEInfo.getText().substring(textIndex - currentEInfo.getStartIndex()));
                            }
                            currentEInfo = elementInfos.get(eleIndex);
                            textIndex = currentEInfo.getStartIndex();
                            currentE = currentEInfo.getElement();
                            currentE.text("");
                            flag = false;
                        }
                        Element textSpan = (Element)eCache.get(index3);
                        Element delSpan = (Element)delECache.get(index3);
                        if (textSpan != null) {
                            if (index3 > textIndex) {
                                currentE.appendText(currentEInfo.getText().substring(textIndex - currentEInfo.getStartIndex(), index3 - currentEInfo.getStartIndex()));
                            }
                            currentE.appendChild((Node)textSpan);
                        } else {
                            currentE.appendText(currentEInfo.getText().substring(textIndex - currentEInfo.getStartIndex(), index3 - currentEInfo.getStartIndex() + 1));
                        }
                        if (delSpan != null) {
                            currentE.appendChild((Node)delSpan);
                        }
                        textIndex = index3 + 1;
                    }
                    if (textIndex <= currentEInfo.getEndIndex()) {
                        currentE.appendText(currentEInfo.getText().substring(textIndex - currentEInfo.getStartIndex()));
                    }
                }
                if (!signText.contains("sign_cell")) continue;
                regexes = SignUtil.batchMatchCell(signText);
                for (String regex : regexes) {
                    matcher = SignUtil.matchCellProp(regex);
                    if (matcher == null) continue;
                    String singId = matcher.group(1);
                    String position = matcher.group(2);
                    Element parent = element.parent();
                    if (StringUtils.isNotEmpty((CharSequence)position)) {
                        this.addPosition(parent, singId, position);
                    }
                    if (parent == null) continue;
                    this.attrDataId(parent, singId);
                }
            }
        }
        catch (Exception e) {
            log.error("html\u521b\u5efa\u6807\u7b7e\u5f02\u5e38", (Throwable)e);
            for (Element element : pList) {
                if (!element.text().contains("sign_")) continue;
                SignUtil.findTextElements(element);
            }
        }
        return document;
    }

    @Override
    public void handle(HttpServletResponse response, FileBytesInfo bytesInfo, Map<String, WordLocation> locationMap, Map<String, String> matchTextMap) throws IOException {
        Map<String, Object> htmlInfo = Word2HtmlUtil.word2html(bytesInfo, locationMap);
        this.imgDirName = (String)htmlInfo.get("imgDirName");
        this.document = this.getHtml(htmlInfo, bytesInfo, matchTextMap);
        AbstractHtmlHandler.adaptiveWith(this.document);
    }

    @Override
    public void handle(FileBytesInfo bytesInfo, Map<String, WordLocation> locationMap, Map<String, String> matchTextMap) throws IOException {
        Map<String, Object> htmlInfo = Word2HtmlUtil.word2html(bytesInfo, locationMap);
        this.imgDirName = (String)htmlInfo.get("imgDirName");
        this.document = this.getHtml(htmlInfo, bytesInfo, matchTextMap);
        AbstractHtmlHandler.adaptiveWith(this.document);
    }

    @Override
    public void response(HttpServletResponse response, FileBytesInfo bytesInfo) throws IOException {
        Cookie cookie = new Cookie("Iamge-Dir-Name", this.imgDirName);
        response.reset();
        response.addCookie(cookie);
        response.setHeader("Iamge-Dir-Name", this.imgDirName);
        response.setHeader("Access-Control-Expose-Headers", "Iamge-Dir-Name");
        response.setContentType("text/html;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + bytesInfo.getFileName());
        ServletOutputStream outputStream = response.getOutputStream();
        if (bytesInfo.getFileName().endsWith("doc")) {
            Document tempDoc = Document.createShell((String)"");
            Element div = new Element("div");
            div.attr("style", "margin-bottom:72.0pt;margin-top:72.0pt;margin-left:90.0pt;margin-right:90.0pt;");
            div.appendChild((Node)this.document.body().clone());
            tempDoc.body().appendChild((Node)div);
            outputStream.write(tempDoc.html().getBytes(StandardCharsets.UTF_8));
        } else {
            outputStream.write(this.document.html().getBytes(StandardCharsets.UTF_8));
        }
        outputStream.flush();
    }

    @Override
    public byte[] response(FileBytesInfo bytesInfo) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (bytesInfo.getFileName().endsWith("doc")) {
            Document tempDoc = Document.createShell((String)"");
            Element div = new Element("div");
            div.attr("style", "margin-bottom:72.0pt;margin-top:72.0pt;margin-left:90.0pt;margin-right:90.0pt;");
            div.appendChild((Node)this.document.body().clone());
            tempDoc.body().appendChild((Node)div);
            outputStream.write(tempDoc.html().getBytes(StandardCharsets.UTF_8));
        } else {
            outputStream.write(this.document.html().getBytes(StandardCharsets.UTF_8));
        }
        outputStream.flush();
        return outputStream.toByteArray();
    }

    private static String getAllText(List<Element> elements) {
        StringBuilder buffer = new StringBuilder();
        for (Element element : elements) {
            buffer.append(SignUtil.text(element.toString()));
        }
        return buffer.toString();
    }

    private static Element getTable(Element element) {
        Element parent = element.parent();
        if (parent != null) {
            if ("table".equals(parent.tagName())) {
                return parent;
            }
            return AbstractHtmlHandler.getTable(parent);
        }
        return element;
    }

    private static int proofText(String allText, String matchText, int index, int length) {
        try {
            String actualText = allText.substring(index, index + length);
            if (matchText.equals(actualText)) {
                return index;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int handledIndex = allText.indexOf(matchText);
        return handledIndex == -1 ? index : handledIndex;
    }

    private void addBorders(Element element) {
        this.addLeftBorder(element);
        this.addRightBorder(element);
    }

    private void addPosition(Element element, String id, String position) {
        String positionPrefix = element.attr("data-position");
        if (StringUtils.isNotEmpty((CharSequence)positionPrefix)) {
            element.attr("data-position", positionPrefix + "," + position + id);
        } else {
            element.attr("data-position", position + id);
        }
    }

    private void addLeftBorder(Element element) {
        element.addClass("border-left");
    }

    private void addRightBorder(Element element) {
        element.addClass("border-right");
    }

    private void attrDataId(Element element, String id) {
        String ids = element.attr("data-id");
        if (ids.startsWith("content")) {
            element.attr("data-id", ids + ",content" + id);
        } else {
            element.attr("data-id", "content" + id);
        }
    }

    private Element span(String id, int index, Map<Integer, Element> map) {
        Element span = map.computeIfAbsent(index, k -> new Element("span"));
        this.attrDataId(span, id);
        return span;
    }

    private static List<ElementInfo> elementInfos(List<Element> elements) {
        ArrayList<ElementInfo> infos = new ArrayList<ElementInfo>();
        int index = 0;
        for (Element element : elements) {
            ElementInfo elementInfo = new ElementInfo();
            elementInfo.setElement(element);
            String text = SignUtil.text(element.toString());
            elementInfo.setText(text);
            elementInfo.setStartIndex(index);
            int length = text.length();
            elementInfo.setLength(length);
            elementInfo.setEndIndex((index += length) - 1);
            infos.add(elementInfo);
        }
        return infos;
    }

    private static void adaptiveWith(Document doc) {
        Elements divList = doc.getElementsByTag("div");
        for (Element element : divList) {
            String style = element.attr("style");
            Pattern pattern = Pattern.compile("(width.*?;)");
            Matcher matcher = pattern.matcher(style);
            if (matcher.find()) {
                style = style.replace(matcher.group(), "");
            }
            element.attr("style", style);
        }
    }

    private Element delElement(String signId) {
        Element delElement = new Element("p");
        this.attrDataId(delElement, signId);
        this.addBorders(delElement);
        return delElement;
    }
}

