/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.exception.handler;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.ZNYSStringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class GlobalExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Autowired
    private MultipartProperties multipartProperties;

    @ExceptionHandler(value={MyBatisSystemException.class})
    public ApiResponse<Void> handlerException(MyBatisSystemException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751fmybatis\u5f02\u5e38{}\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            logger.error("\u53d1\u751fsql\u5f02\u5e38\uff0cMyBatisSystemException:\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.status(false);
    }

    @ExceptionHandler(value={BadSqlGrammarException.class})
    public ApiResponse<Void> handlerException(BadSqlGrammarException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751fsql\u5f02\u5e38{}\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            logger.error("\u53d1\u751fsql\u5f02\u5e38\uff0cMyBatisSystemException:\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.status(false);
    }

    @ExceptionHandler(value={BusinessException.class})
    public ApiResponse<Void> handlerException(BusinessException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38{}\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            logger.error("\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff0cBusinessException\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.fail(e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ApiResponse<Void> handlerException(HttpRequestMethodNotSupportedException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            logger.error("\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.fail(405, "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ApiResponse<Void> handlerException(MaxUploadSizeExceededException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            logger.error("\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.fail("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u670d\u52a1\u5668\u5141\u8bb8\u6587\u4ef6\u5927\u5c0f\u9650\u5236\uff0c\u6700\u5927\u5141\u8bb8\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + this.multipartProperties.getMaxFileSize().toBytes() + "bytes\u3002");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ApiResponse<Void> handlerMissRequestParameterException(MissingServletRequestParameterException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u8bf7\u6c42\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage(), e});
        } else {
            logger.error("\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.fail("\u53d1\u751f\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
    }

    @ExceptionHandler(value={Exception.class})
    public ApiResponse<Void> handlerException(Exception e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            logger.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage(), e});
        } else {
            logger.error("\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.fail("\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
    }

    private void doResponse(HttpServletResponse response) {
        if (!ZNYSStringUtil.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }
}

