/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.arrange;

import com.jxdinfo.idp.common.pdfparser.pojo.BoldStatus;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.pojo.MarkPojo;
import com.jxdinfo.idp.common.pdfparser.tools.SettingReader;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class MarkPdf {
    public static void markTitleSep(ContentPojo contentPojo) {
        MarkPojo markPojo = SettingReader.getPdfMark();
        List<MarkPojo.TitlePattern> titlePatterns = markPojo.getTitlePatterns();
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        ArrayList<Integer> boldStatuses = new ArrayList<Integer>();
        boldStatuses.add(2);
        for (int i = 0; i < outList.size(); ++i) {
            List<ContentPojo.PdfStyleStruct> styles;
            ContentPojo.contentElement p = outList.get(i);
            if (p.getElementType().equals("table") || p.getElementType().equals("pic") || (styles = p.getPdfStyleStructs()) == null) continue;
            for (int j = 0; j < titlePatterns.size(); ++j) {
                MarkPojo.TitlePattern titlePattern = titlePatterns.get(j);
                String bold = titlePattern.getBold();
                String pattern = titlePattern.getPattern();
                int boldStatus = 0;
                if (bold != null && boldStatuses.contains(boldStatus = MarkPdf.verifyBold(styles).getStatus())) {
                    p.setElementType("title");
                    continue;
                }
                if (!p.getText().matches(pattern)) continue;
                p.setElementType("title");
            }
        }
    }

    public static void markTitle(ContentPojo contentPojo, MarkPojo markPojo) {
        if (markPojo == null) {
            markPojo = SettingReader.getPdfMark();
        }
        List<MarkPojo.TitlePattern> titlePatterns = markPojo.getTitlePatterns();
        List sortedTitlePatterns = titlePatterns.stream().filter(x -> x.getOrder() != null).sorted(new Comparator<MarkPojo.TitlePattern>(){

            @Override
            public int compare(MarkPojo.TitlePattern o1, MarkPojo.TitlePattern o2) {
                return o1.getOrder() - o2.getOrder();
            }
        }).collect(Collectors.toList());
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        for (int i = 0; i < outList.size(); ++i) {
            List<ContentPojo.PdfStyleStruct> styles;
            ContentPojo.contentElement p = outList.get(i);
            if (p.getElementType().equals("table") || p.getElementType().equals("pic") || (styles = p.getPdfStyleStructs()) == null) continue;
            for (int j = 0; j < sortedTitlePatterns.size(); ++j) {
                MarkPojo.TitlePattern titlePattern = (MarkPojo.TitlePattern)sortedTitlePatterns.get(j);
                String bold = titlePattern.getBold();
                List<Integer> boldStatuses = new ArrayList<Integer>();
                String pattern = titlePattern.getPattern();
                String firstPattern = titlePattern.getFirstPattern();
                Float level = titlePattern.getLevel();
                boldStatuses.add(1);
                boldStatuses.add(2);
                boldStatuses.add(0);
                int boldStatus = 0;
                if (bold != null) {
                    boldStatuses = Arrays.stream(bold.split(",")).map(Integer::parseInt).collect(Collectors.toList());
                    boldStatus = MarkPdf.verifyBold(styles).getStatus();
                }
                if (!boldStatuses.contains(boldStatus) || !p.getText().matches(pattern)) continue;
                p.setElementType("title");
                p.setLevel(level + "");
                Pattern pa = Pattern.compile(pattern);
                Matcher m = pa.matcher(p.getText());
                if (m.find() && m.groupCount() == 2) {
                    p.setTitlePrefix(m.group(1));
                    p.setTitleBody(m.group(2));
                }
                if (firstPattern == null) continue;
                if (p.getText().matches(firstPattern)) {
                    p.setTitleStart(true);
                    continue;
                }
                p.setTitleStart(false);
            }
        }
        Optional<MarkPojo.TitlePattern> first = titlePatterns.stream().filter(x -> x.getLevel().floatValue() == 1.0f).findFirst();
        if (first.isPresent()) {
            ArrayList<Integer> firstHeaderList = new ArrayList<Integer>();
            for (int i = 0; i < outList.size(); ++i) {
                ContentPojo.contentElement p = outList.get(i);
                String element_type = p.getElementType();
                if (!element_type.equals("title")) continue;
                String level = p.getLevel();
                Boolean titleStart = p.getTitleStart();
                if (titleStart == null || !titleStart.booleanValue() || !level.equals("1.0")) continue;
                firstHeaderList.add(i);
            }
            if (!CollectionUtils.isEmpty(firstHeaderList)) {
                Integer firstHeaderIndex = (Integer)firstHeaderList.get(firstHeaderList.size() - 1);
                for (int i = 0; i < firstHeaderIndex; ++i) {
                    ContentPojo.contentElement p = outList.get(i);
                    if (!p.getElementType().equals("title")) continue;
                    p.setElementType("text");
                    p.setLevel(null);
                    p.setTitleStart(null);
                }
            }
        }
    }

    public static BoldStatus verifyBold(List<ContentPojo.PdfStyleStruct> styles) {
        int countAll = 0;
        int countBold = 0;
        for (int i = 0; i < styles.size(); ++i) {
            String text;
            ContentPojo.PdfStyleStruct style = styles.get(i);
            if (style == null || !TextTool.isContainEnglish(text = style.getText()) && !TextTool.isContainChinese(text)) continue;
            ++countAll;
            String fontName = style.getFontName();
            Float fontWeight = style.getFontWeight();
            String renderingMode = style.getRenderingMode();
            if (!(fontName != null && fontName.contains("SimHei") || fontWeight != null && fontWeight.floatValue() > 400.0f) && (renderingMode == null || !renderingMode.equals("FILL_STROKE"))) continue;
            ++countBold;
        }
        if (countAll != 0) {
            if (countBold == countAll) {
                return BoldStatus.FullBord;
            }
            if (countBold >= 1) {
                return BoldStatus.PartBord;
            }
            return BoldStatus.NoBord;
        }
        return BoldStatus.NoBord;
    }
}

