/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.pageutil;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.util.reflect.ReflectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class PageUtils {
    private static final String CURRENT = "current";
    private static final String SIZE = "size";

    public static <T> Page<T> buildPage(Object object, Class<T> tClass) {
        Page page = new Page();
        BeanUtils.copyProperties((Object)object, (Object)page);
        return page;
    }

    public static <T> T buildObjectPage(T object) {
        try {
            Object result = object.getClass().newInstance();
            BeanUtils.copyProperties(object, result);
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return object;
        }
    }

    public static <T> Page<T> transformPage(Page<T> page) {
        Page newPage = new Page();
        newPage.setSize(page.getCurrent() * page.getSize());
        newPage.setCurrent(1L);
        newPage.setOrders(page.getOrders());
        return newPage;
    }

    public static <T> T transformPageObject(T object) {
        try {
            Object result = object.getClass().newInstance();
            BeanUtils.copyProperties(object, result);
            ReflectUtils.setValueByMethod(SIZE, result, (Long)ReflectUtils.getValueByMethod(CURRENT, object) * (Long)ReflectUtils.getValueByMethod(SIZE, object));
            ReflectUtils.setValueByMethod(CURRENT, result, 1);
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return object;
        }
    }

    public static <T> Page<T> getCombinedList(List<Page<T>> listList, Page<T> page) {
        List<Object> records = new ArrayList();
        int total = 0;
        for (Page<T> tPage : listList) {
            total = (int)((long)total + tPage.getTotal());
            records.addAll(tPage.getRecords());
        }
        List orders = page.orders();
        long skip = page.getSize() * (page.getCurrent() - 1L);
        records = records.stream().sorted((a, b) -> PageUtils.compare(orders, a, b)).skip(skip).limit(page.getSize()).collect(Collectors.toList());
        page.setRecords(records);
        page.setTotal((long)total);
        return page;
    }

    private static <T> int compare(List<OrderItem> orders, T a, T b) {
        for (OrderItem order : orders) {
            int c;
            Object aOrder = ReflectUtils.getFieldValueByName(order.getColumn(), a);
            Object bOrder = ReflectUtils.getFieldValueByName(order.getColumn(), b);
            if (aOrder != null || bOrder != null || !(aOrder instanceof Comparable) || (c = ((Comparable)aOrder).compareTo(bOrder)) == 0) continue;
            return c;
        }
        return 0;
    }
}

