/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.excel;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.export.ExcelExportService;
import cn.hutool.core.util.ObjectUtil;
import com.jxdinfo.idp.common.excel.ExportExcelDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelExportUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean exportExcel(ExportExcelDto exportExcelDto) {
        try {
            if (ObjectUtil.isNull(exportExcelDto.getSheetNames()) && ObjectUtil.isNull(exportExcelDto.getTableTitles()) && ObjectUtil.isNull(exportExcelDto.getDataset()) && exportExcelDto.getSheetNames().size() == exportExcelDto.getTableTitles().size() && exportExcelDto.getSheetNames().size() == exportExcelDto.getDataset().size()) {
                return false;
            }
            ArrayList dataList = new ArrayList();
            HSSFWorkbook workbook = new HSSFWorkbook();
            int j = exportExcelDto.getDataset().size();
            for (int i = 0; i < j; ++i) {
                HashMap<ExportParams, List> map = new HashMap<ExportParams, List>();
                ExportParams exportParams = new ExportParams(exportExcelDto.getTableTitles().get(i), exportExcelDto.getSheetNames().get(i));
                map.put(exportParams, exportExcelDto.getDataset().get(i));
                dataList.add(map);
                ExcelExportService service = new ExcelExportService();
                service.createSheet((Workbook)workbook, exportParams, exportExcelDto.getClassList().get(i), (Collection)exportExcelDto.getDataset().get(i));
            }
            try {
                workbook.write(exportExcelDto.getOut());
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (workbook != null) {
                        workbook.close();
                    }
                    if (exportExcelDto.getOut() != null) {
                        exportExcelDto.getOut().close();
                    }
                }
                catch (IOException e4) {
                    System.err.println("\u5173\u95ed Workbook \u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e4.getMessage());
                    e4.printStackTrace();
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return false;
        }
    }
}

