/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

@Component
public class ReadPdfUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadPdfUtil.class);
    @Value(value="${idp.pdf.file.path}")
    private String filePath;
    @Value(value="${idp.pdf.python.path}")
    private String pythonPath;
    @Value(value="${idp.pdf.charsetName:}")
    private String charsetName;
    private static String filePathStatic;
    private static String pythonPathStatic;
    private static String charsetNameStatic;
    private static final SpreadsheetExtractionAlgorithm ALGORITHM;

    @PostConstruct
    public void initStatic() {
        filePathStatic = this.filePath;
        pythonPathStatic = this.pythonPath;
        charsetNameStatic = this.charsetName;
    }

    public static void removeTextWatermark(PDDocument pd) throws Exception {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            pdfsp.parse();
            List tokens = pdfsp.getTokens();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                countMap.put(next.toString(), countMap.getOrDefault(next.toString(), 0) + 1);
            }
        }
        ArrayList waterMarks = new ArrayList();
        for (Map.Entry entry : countMap.entrySet()) {
            waterMarks.add(entry.getKey());
        }
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            pdfsp.parse();
            List tokens = pdfsp.getTokens();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                for (String waterMark : waterMarks) {
                    if (!next.toString().equals(waterMark)) continue;
                    iterator.remove();
                }
            }
            PDStream updatedStream = new PDStream(pd);
            OutputStream out = updatedStream.createOutputStream();
            ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
            tokenWriter.writeTokens(tokens);
            out.close();
            page.setContents(updatedStream);
        }
    }

    public static void removeTextWatermark(FileBytesInfo bytesInfo) {
        try (PDDocument pd = PDDocument.load((byte[])bytesInfo.getFileBytes());
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ReadPdfUtil.removeTextWatermark(pd);
            pd.save((OutputStream)outputStream);
            bytesInfo.setFileBytes(outputStream.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized JSONObject getPDFTable(FileBytesInfo bytesInfo) {
        StringBuilder cmd = new StringBuilder("python ");
        String fileName = System.currentTimeMillis() + ".pdf";
        cmd.append(pythonPathStatic).append(" ").append(filePathStatic).append(File.separator).append(fileName);
        StringBuilder sb = new StringBuilder();
        File file = new File(filePathStatic + File.separator + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytesInfo.getFileBytes());
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            BufferedReader in = new BufferedReader(StringUtils.isNotEmpty(charsetNameStatic) ? new InputStreamReader(proc.getInputStream(), charsetNameStatic) : new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                sb.append(line);
                System.out.println(line);
            }
            in.close();
            proc.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)sb.toString());
    }

    private static void checkCellMap(TreeMap<Double, Double> cellMap) {
        Iterator<Map.Entry<Double, Double>> iterator = cellMap.entrySet().iterator();
        double index = 0.0;
        while (iterator.hasNext()) {
            Map.Entry<Double, Double> currentEntry = iterator.next();
            cellMap.put(currentEntry.getKey(), index);
            index += 1.0;
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Process proc = Runtime.getRuntime().exec("python E:\\code\\idps\\idp_web\\idp-common\\src\\main\\resources\\PdfParse.py D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee\\1.ZF3G24020003\u4e2d\u6807\u901a\u77e5\u4e66.pdf D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee");
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream(), "GBK"));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                System.out.println(line);
            }
            System.out.println(sb);
            in.close();
            proc.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        ALGORITHM = new SpreadsheetExtractionAlgorithm();
    }
}

