/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static final List<Pattern> TIME_REG_LIST = new ArrayList<Pattern>();
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static LocalDate strToTime(String str) {
        String timeStr = TimeUtils.format(str);
        return LocalDate.parse(timeStr, FORMATTER);
    }

    private static String format(String str) {
        for (Pattern pattern : TIME_REG_LIST) {
            Matcher matcher = pattern.matcher(str);
            if (!matcher.find()) continue;
            return matcher.group(1) + "-" + matcher.group(2) + "-" + matcher.group(3);
        }
        throw new IllegalArgumentException(str + "\u627e\u4e0d\u51fa\u65f6\u95f4");
    }

    static {
        TIME_REG_LIST.add(Pattern.compile("(\\d+).*?(\\d+).*?(\\d+)"));
    }
}

