/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.thirdparty;

import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;

public class GetImageEngine
extends PDFStreamEngine {
    public int imageNumber = 1;
    private String picSavePath;
    private final List<Tu.Tuple2<Integer, Rectangle2D.Float>> pics = new ArrayList<Tu.Tuple2<Integer, Rectangle2D.Float>>();

    public List<Tu.Tuple2<Integer, Rectangle2D.Float>> getPics() {
        return this.pics;
    }

    public void clearList() {
        this.pics.clear();
    }

    public void setPicSavePath(String picSavePath) {
        this.picSavePath = picSavePath;
    }

    public String getPicSavePath() {
        return this.picSavePath;
    }

    public GetImageEngine(String picSavePath) throws IOException {
        this.picSavePath = picSavePath;
        this.addOperator((OperatorProcessor)new Concatenate());
        this.addOperator((OperatorProcessor)new DrawObject());
        this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
        this.addOperator((OperatorProcessor)new Save());
        this.addOperator((OperatorProcessor)new Restore());
        this.addOperator((OperatorProcessor)new SetMatrix());
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        String operation = operator.getName();
        if ("Do".equals(operation)) {
            COSName objectName = (COSName)operands.get(0);
            PDXObject xobject = this.getResources().getXObject(objectName);
            if (xobject instanceof PDImageXObject) {
                PDImageXObject image = (PDImageXObject)xobject;
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                Matrix ctmNew = this.getGraphicsState().getCurrentTransformationMatrix();
                BufferedImage bImage = image.getImage();
                ImageIO.write((RenderedImage)bImage, "PNG", new File(this.picSavePath + "/" + this.imageNumber + ".png"));
                System.out.println("Image saved.");
                this.pics.add(new Tu.Tuple2<Integer, Rectangle2D.Float>(this.imageNumber, new Rectangle2D.Float(ctmNew.getTranslateX(), ctmNew.getTranslateY(), imageWidth, imageHeight)));
                ++this.imageNumber;
            } else if (xobject instanceof PDFormXObject) {
                PDFormXObject form = (PDFormXObject)xobject;
                this.showForm(form);
            }
        } else {
            super.processOperator(operator, operands);
        }
    }
}

