/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.pdfparser.table;

import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.pojo.Tu;
import com.jxdinfo.idp.common.pdfparser.table.TableLine;
import com.jxdinfo.idp.common.pdfparser.thirdparty.CustomPDFRenderer;
import com.jxdinfo.idp.common.pdfparser.thirdparty.CustomPageDrawer;
import com.jxdinfo.idp.common.pdfparser.tools.TextTool;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class CellAnalyser {
    private static final double minHorizonLineLength = 60.0;
    private static final double minVerticalLineLength = 15.0;
    private static final double maxVerticalLineWidth = 3.0;
    private static final double maxHorizonLineWidth = 3.0;

    public static List<Shape> getShapes(PDDocument doc, int pageNum) throws IOException {
        CustomPDFRenderer renderer = new CustomPDFRenderer(doc);
        BufferedImage image = renderer.renderImage(pageNum - 1);
        CustomPageDrawer drawer = renderer.getDrawer();
        List<Shape> tableLines = drawer.getTableLines();
        List<Shape> fillLines = drawer.getFillLines();
        List<Shape> strokeLines = drawer.getStrokeLines();
        if (strokeLines.size() != 0) {
            return strokeLines;
        }
        return fillLines;
    }

    public static List<Shape> getSpecifyShapes(List<Shape> shapes, Double heightStart, Double heightEnd) {
        return shapes.stream().filter(x -> {
            double yStart = x.getBounds2D().getY() + 5.0;
            double yEnd = x.getBounds2D().getY() + x.getBounds2D().getHeight() - 5.0;
            return yStart >= heightStart && yEnd <= heightEnd;
        }).collect(Collectors.toList());
    }

    public static Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> getLastTableInfo(List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> resultList) {
        Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> curLast = null;
        Double curStart = Double.MAX_VALUE;
        for (Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> tu : resultList) {
            Double tmpStart = tu.getKey().getKey();
            if (!(tmpStart < curStart)) continue;
            curLast = tu;
            curStart = tmpStart;
        }
        return curLast;
    }

    public static Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> getFirstTableInfo(List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> resultList) {
        Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> curFirst = null;
        Double curStart = 0.0;
        for (Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo> tu : resultList) {
            Double tmpStart = tu.getKey().getKey();
            if (!(tmpStart > curStart)) continue;
            curFirst = tu;
            curStart = tmpStart;
        }
        return curFirst;
    }

    public static TableInfo getSpecifyTableInfo(List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> resultList, Double heightStart, Double heightEnd) {
        List list = resultList.stream().filter(x -> {
            Tu.Tuple2 key = (Tu.Tuple2)x.getKey();
            Double yStart = (Double)key.getKey();
            Double yEnd = (Double)key.getValue();
            return yStart <= heightStart && yEnd >= heightEnd;
        }).collect(Collectors.toList());
        if (list.size() != 0) {
            return (TableInfo)((Tu.Tuple2)list.get(0)).getValue();
        }
        return new TableInfo(0, 0, 0.0, 0.0, 0.0, 0.0, new ArrayList<Cell>());
    }

    public static List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> getTableInfos(List<Shape> tableLines) {
        ArrayList<TableLine.VerticalLine> verticalLines = new ArrayList<TableLine.VerticalLine>();
        ArrayList<TableLine.HorizonLine> horizonLines = new ArrayList<TableLine.HorizonLine>();
        for (Shape shape : tableLines) {
            Rectangle bounds2D = shape.getBounds();
            double width = ((RectangularShape)bounds2D).getWidth();
            double height = ((RectangularShape)bounds2D).getHeight();
            if (((RectangularShape)bounds2D).getWidth() * ((RectangularShape)bounds2D).getHeight() >= 300000.0 || width >= 8.0 && height >= 8.0) continue;
            if (width < 3.0) {
                verticalLines.add(new TableLine.VerticalLine(((RectangularShape)bounds2D).getX(), ((RectangularShape)bounds2D).getY(), ((RectangularShape)bounds2D).getY() + ((RectangularShape)bounds2D).getHeight()));
            }
            if (!(height < 3.0)) continue;
            horizonLines.add(new TableLine.HorizonLine(((RectangularShape)bounds2D).getY(), ((RectangularShape)bounds2D).getX(), ((RectangularShape)bounds2D).getX() + ((RectangularShape)bounds2D).getWidth()));
        }
        CellAnalyser.unifyVerticalLine(verticalLines);
        Collections.sort(verticalLines);
        double curX = 0.0;
        TableLine.VerticalLine vL = null;
        ArrayList<TableLine.VerticalLine> newVerticalLines = new ArrayList<TableLine.VerticalLine>();
        for (TableLine.VerticalLine v : verticalLines) {
            double x2 = v.getX();
            if (curX == 0.0) {
                curX = x2;
            }
            if (curX == x2) {
                if (vL == null) {
                    vL = v;
                    continue;
                }
                double yEnd = vL.getYEnd();
                double yStart = v.getYStart();
                if (yStart - yEnd < 2.0) {
                    vL = TableLine.connectVLine(vL, v);
                    continue;
                }
                if (vL.length >= 15.0) {
                    newVerticalLines.add(vL);
                }
                vL = v;
                continue;
            }
            if (vL != null) {
                if (vL.length >= 15.0) {
                    newVerticalLines.add(vL);
                }
                vL = v;
            }
            curX = x2;
        }
        if (vL != null && vL.length >= 15.0) {
            newVerticalLines.add(vL);
        }
        CellAnalyser.unifyHorizonLine(horizonLines);
        Collections.sort(horizonLines);
        double curY = 0.0;
        TableLine.HorizonLine hl = null;
        ArrayList<TableLine.HorizonLine> newHorizonLines = new ArrayList<TableLine.HorizonLine>();
        for (TableLine.HorizonLine h : horizonLines) {
            double y = h.getY();
            if (curY == 0.0) {
                curY = y;
            }
            if (curY == y) {
                if (hl == null) {
                    hl = h;
                    continue;
                }
                double xEnd = hl.getXEnd();
                double xStart = h.getXStart();
                if (xStart - xEnd < 2.0) {
                    hl = TableLine.connectHLine(hl, h);
                    continue;
                }
                if (hl.length >= 60.0) {
                    newHorizonLines.add(hl);
                }
                hl = h;
                continue;
            }
            if (hl != null) {
                if (hl.length >= 60.0) {
                    newHorizonLines.add(hl);
                }
                hl = h;
            }
            curY = y;
        }
        if (hl != null && hl.length >= 60.0) {
            newHorizonLines.add(hl);
        }
        if (newHorizonLines.size() != 0) {
            TableLine.HorizonLine firstLine = (TableLine.HorizonLine)newHorizonLines.get(0);
            double y = firstLine.getY();
            if (newVerticalLines.size() >= 2) {
                TableLine.VerticalLine left = (TableLine.VerticalLine)newVerticalLines.get(0);
                double leftYEnd = left.getYEnd();
                double leftX = left.getX();
                TableLine.VerticalLine right = (TableLine.VerticalLine)newVerticalLines.get(newVerticalLines.size() - 1);
                double rightYEnd = right.getYEnd();
                double rightX = right.getX();
                if (leftYEnd - y > 10.0 && rightYEnd - y > 10.0) {
                    newHorizonLines.add(0, new TableLine.HorizonLine(leftYEnd, leftX, rightX));
                }
            }
        }
        CellAnalyser.stretchVerticalLine(newVerticalLines);
        CellAnalyser.stretchHorizonLine(newHorizonLines);
        ArrayList<Tu.Tuple2<Double, Double>> rangeList = new ArrayList<Tu.Tuple2<Double, Double>>();
        for (TableLine.VerticalLine verticalLine : newVerticalLines) {
            double yStart = verticalLine.getYStart();
            double yEnd = verticalLine.getYEnd();
            rangeList.add(new Tu.Tuple2<Double, Double>(yStart, yEnd));
        }
        for (int i = 0; i < rangeList.size() - 1; ++i) {
            Tu.Tuple2 tuple = (Tu.Tuple2)rangeList.get(i);
            Double yStart = (Double)tuple.getKey();
            Double yEnd = (Double)tuple.getValue();
            for (int j = i + 1; j < rangeList.size(); ++j) {
                Tu.Tuple2 curTuple = (Tu.Tuple2)rangeList.get(j);
                Double tmpYStart = (Double)curTuple.getKey();
                Double tmpYEnd = (Double)curTuple.getValue();
                if (yStart <= tmpYStart && yEnd >= tmpYEnd) {
                    curTuple.setKey(yStart);
                    curTuple.setValue(yEnd);
                    tuple.setKey(-1.0);
                    tuple.setValue(-1.0);
                    continue;
                }
                if (tmpYStart <= yStart && tmpYEnd >= yEnd) {
                    tuple.setKey(-1.0);
                    tuple.setValue(-1.0);
                    continue;
                }
                if (!CellAnalyser.modifyEqual(tmpYStart, yStart) || !CellAnalyser.modifyEqual(tmpYEnd, yEnd)) continue;
                curTuple.setKey(Math.min(tmpYStart, yStart));
                curTuple.setValue(Math.max(tmpYEnd, yEnd));
                tuple.setKey(-1.0);
                tuple.setValue(-1.0);
            }
        }
        List ranges = rangeList.stream().filter(x -> (Double)x.getKey() != -1.0).collect(Collectors.toList());
        List<Tu.Tuple2<Tu.Tuple2<Double, Double>, TableInfo>> result = ranges.stream().map(x -> {
            Double yStart = (Double)x.getKey() - 5.0;
            Double yEnd = (Double)x.getValue() + 5.0;
            List<TableLine.HorizonLine> horizonLines1 = newHorizonLines.stream().filter(y -> {
                double y1 = y.getY();
                return yStart <= y1 && yEnd >= y1;
            }).collect(Collectors.toList());
            List<TableLine.VerticalLine> verticalLines1 = newVerticalLines.stream().filter(y -> {
                double yStart1 = y.getYStart();
                double yEnd1 = y.getYEnd();
                return yStart <= yStart1 && yEnd >= yEnd1;
            }).collect(Collectors.toList());
            if (horizonLines1.size() != 0) {
                TableLine.HorizonLine lastHLine = horizonLines1.get(horizonLines1.size() - 1);
                double xs = lastHLine.getXStart();
                double xe = lastHLine.getXEnd();
                double lhy = lastHLine.getY();
                TableLine.HorizonLine firstHLine = horizonLines1.get(0);
                double fhy = firstHLine.getY();
                if (verticalLines1.size() != 0) {
                    TableLine.VerticalLine firstVLine = verticalLines1.get(0);
                    TableLine.VerticalLine lastVLine = verticalLines1.get(verticalLines1.size() - 1);
                    double fxv = firstVLine.getX();
                    double lxv = lastVLine.getX();
                    if (fxv - xs > 20.0) {
                        verticalLines1.add(0, new TableLine.VerticalLine(xs, lhy, fhy));
                    }
                    if (xe - lxv > 20.0) {
                        verticalLines1.add(new TableLine.VerticalLine(xe, lhy, fhy));
                    }
                }
            }
            TableInfo tableInfo = CellAnalyser.getTableInfo(horizonLines1, verticalLines1);
            return new Tu.Tuple2<Tu.Tuple2, TableInfo>((Tu.Tuple2)x, tableInfo);
        }).collect(Collectors.toList());
        return result;
    }

    public static ContentPojo.contentElement formTable(TableInfo tableInfo, Integer pageNum, PDDocument pdd) throws IOException {
        PDRectangle cropBox = pdd.getPage(pageNum - 1).getCropBox();
        float maxHeight = cropBox.getHeight();
        ArrayList<Rectangle2D> cellRanges = new ArrayList<Rectangle2D>();
        List<ContentPojo.contentElement.InnerCell> innerCells = tableInfo.getCells().stream().map(x -> {
            Integer rowIndex = x.getRowIndex();
            Integer colIndex = x.getColIndex();
            Integer rowSpan = x.getRowSpan();
            Integer colSpan = x.getColSpan();
            float xStart = x.getXStart().floatValue();
            float xEnd = x.getXEnd().floatValue();
            float width = xEnd - xStart;
            float yStart = x.getYStart().floatValue();
            float yEnd = x.getYEnd().floatValue();
            float height = yStart - yEnd;
            cellRanges.add(new Rectangle2D.Double(xStart, maxHeight - yStart, width, height));
            ContentPojo.contentElement.InnerCell innerCell = new ContentPojo.contentElement.InnerCell();
            innerCell.setRow_index(rowIndex);
            innerCell.setCol_index(colIndex);
            innerCell.setRow_span(rowSpan);
            innerCell.setCol_span(colSpan);
            return innerCell;
        }).collect(Collectors.toList());
        List<Tu.Tuple2<String, Rectangle2D>> cellTexts = TextTool.grabText(pdd, cellRanges, pageNum);
        for (int i = 0; i < innerCells.size(); ++i) {
            Tu.Tuple2<String, Rectangle2D> tmp = cellTexts.get(i);
            ((ContentPojo.contentElement.InnerCell)innerCells.get(i)).setText(tmp.getKey());
            ((ContentPojo.contentElement.InnerCell)innerCells.get(i)).setXStart(Float.valueOf((float)tmp.getValue().getX()));
            innerCells.get(i).setYStart(Float.valueOf((float)tmp.getValue().getY()));
            innerCells.get(i).setHeight(Float.valueOf((float)tmp.getValue().getHeight()));
            innerCells.get(i).setWidth(Float.valueOf((float)tmp.getValue().getWidth()));
        }
        Integer rowNum = tableInfo.getRowNum();
        Integer colNum = tableInfo.getColNum();
        ContentPojo.contentElement table = new ContentPojo.contentElement((int)pageNum, "table", rowNum, colNum, innerCells);
        return table;
    }

    public static ContentPojo.contentElement formTable(TableInfo tableInfo, Integer pageNum) {
        Integer rowNum = tableInfo.getRowNum();
        Integer colNum = tableInfo.getColNum();
        List<ContentPojo.contentElement.InnerCell> innerCells = tableInfo.getCells().stream().map(x -> {
            Integer rowIndex = x.getRowIndex();
            Integer colIndex = x.getColIndex();
            Integer rowSpan = x.getRowSpan();
            Integer colSpan = x.getColSpan();
            float xStart = x.getXStart().floatValue();
            float xEnd = x.getXEnd().floatValue();
            float width = xEnd - xStart;
            float yStart = x.getYStart().floatValue();
            float yEnd = x.getYEnd().floatValue();
            float height = yStart - yEnd;
            String cell = x.getCell();
            ContentPojo.contentElement.InnerCell innerCell = new ContentPojo.contentElement.InnerCell();
            innerCell.setRow_index(rowIndex);
            innerCell.setCol_index(colIndex);
            innerCell.setRow_span(rowSpan);
            innerCell.setCol_span(colSpan);
            innerCell.setXStart(Float.valueOf(xStart));
            innerCell.setYStart(Float.valueOf(yStart));
            innerCell.setWidth(Float.valueOf(width));
            innerCell.setHeight(Float.valueOf(height));
            innerCell.setText(cell);
            return innerCell;
        }).collect(Collectors.toList());
        ContentPojo.contentElement table = new ContentPojo.contentElement((int)pageNum, "table", rowNum, colNum, innerCells);
        Double xStart = tableInfo.getXStart();
        Double xEnd = tableInfo.getXEnd();
        Double yStart = tableInfo.getYStart();
        Double yEnd = tableInfo.getYEnd();
        table.setXStart(Float.valueOf(xStart.floatValue()));
        table.setYStart(Float.valueOf(yStart.floatValue()));
        double height = yEnd - yStart;
        table.setHeight(Float.valueOf((float)height));
        double width = xEnd - xStart;
        table.setWidth(Float.valueOf((float)width));
        return table;
    }

    public static boolean modifyEqual(Double a, Double b) {
        return Math.abs(b - a) <= 3.0;
    }

    private static TableInfo getTableInfo(List<TableLine.HorizonLine> horizonLines, List<TableLine.VerticalLine> verticalLines) {
        ArrayList<TableLine.HorizonLine> needRemoveLine = new ArrayList<TableLine.HorizonLine>();
        for (TableLine.HorizonLine horizonLine : horizonLines) {
            double xStart = horizonLine.getXStart();
            double xEnd = horizonLine.getXEnd();
            double y = horizonLine.getY();
            int crossCount = 0;
            for (TableLine.VerticalLine verticalLine : verticalLines) {
                if (crossCount == 2) break;
                double verticalLineX = verticalLine.getX();
                double verticalLineYStart = verticalLine.getYStart();
                double verticalLineYEnd = verticalLine.getYEnd();
                if (!(xStart < verticalLineX) || !(xEnd > verticalLineX) || !(verticalLineYStart < y) || !(verticalLineYEnd > y)) continue;
                ++crossCount;
            }
            if (crossCount >= 2) continue;
            needRemoveLine.add(horizonLine);
        }
        horizonLines.removeAll(needRemoveLine);
        ArrayList<Cell> list = new ArrayList<Cell>();
        int rowNum = 0;
        int colNum = 0;
        int curRowIndex = 0;
        Double tableXStart = 0.0;
        Double tableXEnd = 0.0;
        Double tableYStart = 0.0;
        Double tableYEnd = 0.0;
        Map<Double, List<TableLine.HorizonLine>> collect = horizonLines.stream().collect(Collectors.groupingBy(TableLine.HorizonLine::getY));
        List horizonList = collect.entrySet().stream().sorted(new Comparator<Map.Entry<Double, List<TableLine.HorizonLine>>>(){

            @Override
            public int compare(Map.Entry<Double, List<TableLine.HorizonLine>> o1, Map.Entry<Double, List<TableLine.HorizonLine>> o2) {
                return Double.compare(o2.getKey(), o1.getKey());
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(horizonList)) {
            Map.Entry lastLineListMap;
            List lastLineList;
            Map.Entry fistLineListMap = (Map.Entry)horizonList.get(0);
            List firstLineList = (List)fistLineListMap.getValue();
            if (!CollectionUtils.isEmpty((Collection)firstLineList)) {
                TableLine.HorizonLine horizonLine = (TableLine.HorizonLine)firstLineList.get(0);
                horizonLine.setXStart(-2.147483647E9);
                horizonLine.setXEnd(2.147483647E9);
                ArrayList<TableLine.HorizonLine> newFirstHorizonLine = new ArrayList<TableLine.HorizonLine>();
                newFirstHorizonLine.add(horizonLine);
                fistLineListMap.setValue(newFirstHorizonLine);
            }
            if (!CollectionUtils.isEmpty((Collection)(lastLineList = (List)(lastLineListMap = (Map.Entry)horizonList.get(horizonList.size() - 1)).getValue()))) {
                TableLine.HorizonLine horizonLine = (TableLine.HorizonLine)lastLineList.get(0);
                horizonLine.setXStart(-2.147483647E9);
                horizonLine.setXEnd(2.147483647E9);
                ArrayList<TableLine.HorizonLine> newLastHorizonLine = new ArrayList<TableLine.HorizonLine>();
                newLastHorizonLine.add(horizonLine);
                lastLineListMap.setValue(newLastHorizonLine);
            }
            tableYEnd = (Double)((Map.Entry)horizonList.get(0)).getKey();
            tableYStart = (Double)((Map.Entry)horizonList.get(horizonList.size() - 1)).getKey();
        }
        if (!CollectionUtils.isEmpty(verticalLines)) {
            TableLine.VerticalLine firstVerticalLine = verticalLines.get(0);
            firstVerticalLine.setYStart(-2.147483647E9);
            firstVerticalLine.setYEnd(2.147483647E9);
            double firstVerticalLineX = firstVerticalLine.getX();
            TableLine.VerticalLine lastVerticalLine = verticalLines.get(verticalLines.size() - 1);
            lastVerticalLine.setYStart(-2.147483647E9);
            lastVerticalLine.setYEnd(2.147483647E9);
            double lastVerticalLineX = lastVerticalLine.getX();
            ArrayList<TableLine.VerticalLine> newVerticalLines = new ArrayList<TableLine.VerticalLine>();
            for (TableLine.VerticalLine verticalLine : verticalLines) {
                double tmpX = verticalLine.getX();
                if (tmpX == firstVerticalLineX || tmpX == lastVerticalLineX) continue;
                newVerticalLines.add(verticalLine);
            }
            newVerticalLines.add(0, firstVerticalLine);
            newVerticalLines.add(lastVerticalLine);
            verticalLines = newVerticalLines;
            tableXStart = verticalLines.get(0).getX();
            tableXEnd = verticalLines.get(verticalLines.size() - 1).getX();
        }
        block3: for (int i = 0; i < horizonList.size() - 1; ++i) {
            Double floorY = (Double)((Map.Entry)horizonList.get(i)).getKey();
            List floorLines = (List)((Map.Entry)horizonList.get(i)).getValue();
            Double bottomY = (Double)((Map.Entry)horizonList.get(i + 1)).getKey();
            List bottomLines = (List)((Map.Entry)horizonList.get(i + 1)).getValue();
            HashSet<Double> set = new HashSet<Double>();
            int pre = 0;
            int pos = 0;
            int size = verticalLines.size();
            boolean preFind = false;
            boolean posFind = false;
            int colCount = 0;
            boolean firstIn = true;
            while (true) {
                preFind = false;
                if (pos != 0) {
                    pre = pos;
                    preFind = true;
                } else {
                    for (int j = pre; j < size; ++j) {
                        TableLine.VerticalLine tmp = verticalLines.get(pre);
                        double yStart = tmp.getYStart();
                        double yEnd = tmp.getYEnd();
                        if (!(yStart < bottomY) || !(yEnd > floorY)) continue;
                        preFind = true;
                        pre = j;
                        break;
                    }
                }
                posFind = false;
                set.clear();
                for (pos = pre + 1; pos < size; ++pos) {
                    TableLine.VerticalLine tmp = verticalLines.get(pos);
                    double yStart = tmp.getYStart();
                    double yEnd = tmp.getYEnd();
                    if (yStart < bottomY && yEnd > floorY) {
                        posFind = true;
                        break;
                    }
                    if (yStart < floorY && yStart > bottomY) {
                        set.add(tmp.getX());
                        continue;
                    }
                    if (!(yEnd > bottomY) || !(yEnd < floorY)) continue;
                    set.add(tmp.getX());
                }
                if (!preFind || !posFind) continue block3;
                double leftX = verticalLines.get(pre).getX();
                double rightX = verticalLines.get(pos).getX();
                for (TableLine.VerticalLine tmp : verticalLines) {
                    double x2 = tmp.getX();
                    if (!(x2 > leftX) || !(x2 < rightX)) continue;
                    set.add(x2);
                }
                if (firstIn) {
                    ++curRowIndex;
                    firstIn = false;
                }
                Cell cell = new Cell(leftX, rightX, floorY, bottomY);
                cell.setColSpan(set.size() + 1);
                cell.setRowIndex(curRowIndex);
                rowNum = Math.max(curRowIndex, rowNum);
                colNum = Math.max(++colCount, colNum);
                cell.setColIndex(colCount);
                TableLine.VerticalLine left = verticalLines.get(pre);
                TableLine.VerticalLine right = verticalLines.get(pos);
                double middle = (left.getX() + right.getX()) / 2.0;
                if (CellAnalyser.isInLine(floorLines, middle)) {
                    if (CellAnalyser.isInLine(bottomLines, middle)) {
                        cell.setRowSpan(1);
                    } else {
                        cell.setRowSpanStatus(1);
                    }
                } else if (CellAnalyser.isInLine(bottomLines, middle)) {
                    cell.setRowSpanStatus(-1);
                } else {
                    cell.setRowSpanStatus(0);
                }
                list.add(cell);
            }
        }
        List waitRowCombineCells = list.stream().filter(x -> x.getRowSpanStatus() != null).sorted((o1, o2) -> {
            Double xEnd1 = o1.getXEnd();
            Double xEnd2 = o2.getXEnd();
            Integer rowIndex1 = o1.getRowIndex();
            Integer rowIndex2 = o2.getRowIndex();
            if (xEnd1 < xEnd2) {
                return -1;
            }
            return rowIndex1 - rowIndex2;
        }).collect(Collectors.toList());
        ArrayList<Cell> rowCombinedCell = new ArrayList<Cell>();
        Cell cell = null;
        for (Cell c : waitRowCombineCells) {
            if (cell == null) {
                cell = c;
                continue;
            }
            Double xEnd = cell.getXEnd();
            if (!xEnd.equals(c.getXEnd())) {
                rowCombinedCell.add(cell);
                cell = c;
                continue;
            }
            if (c.getRowSpanStatus() == 1) {
                rowCombinedCell.add(cell);
                cell = c;
                continue;
            }
            if (c.getRowSpanStatus() == 0) {
                cell.setYEnd(c.getYEnd());
                cell.setRowSpan((cell.getRowSpan() == null ? 1 : cell.getRowSpan()) + 1);
                continue;
            }
            cell.setYEnd(c.getYEnd());
            cell.setRowSpan((cell.getRowSpan() == null ? 1 : cell.getRowSpan()) + 1);
            rowCombinedCell.add(cell);
            cell = null;
        }
        if (cell != null) {
            rowCombinedCell.add(cell);
        }
        List<Cell> cellAll = list.stream().filter(x -> x.getRowSpanStatus() == null).collect(Collectors.toList());
        cellAll.addAll(rowCombinedCell);
        Collections.sort(cellAll);
        CellAnalyser.denseCols(cellAll);
        return new TableInfo(rowNum, colNum, tableXStart, tableYStart, tableXEnd, tableYEnd, cellAll);
    }

    private static boolean isInLine(List<TableLine.HorizonLine> lines, Double d) {
        for (TableLine.HorizonLine l : lines) {
            double xStart = l.getXStart();
            double xEnd = l.getXEnd();
            if (!(d > xStart) || !(d < xEnd)) continue;
            return true;
        }
        return false;
    }

    private static void denseCols(List<Cell> cells) {
        int curRow = 0;
        int preCol = 0;
        for (Cell cell : cells) {
            Integer rowIndex = cell.getRowIndex();
            if (curRow == 0) {
                curRow = rowIndex;
                preCol = 1;
                cell.setColIndex(preCol);
                continue;
            }
            if (rowIndex == curRow) {
                cell.setColIndex(++preCol);
                continue;
            }
            if (rowIndex <= curRow) continue;
            curRow = rowIndex;
            preCol = 1;
            cell.setColIndex(preCol);
        }
    }

    private static void stretchVerticalLine(List<TableLine.VerticalLine> verticalLines) {
        verticalLines.forEach(x -> {
            x.setYStart(x.getYStart() - 2.0);
            x.setYEnd(x.getYEnd() + 2.0);
            x.setLength(x.getLength() + 4.0);
        });
    }

    private static void stretchHorizonLine(List<TableLine.HorizonLine> horizonLines) {
        horizonLines.forEach(x -> {
            x.setXStart(x.getXStart() - 2.0);
            x.setXEnd(x.getXEnd() + 2.0);
            x.setLength(x.getLength() + 4.0);
        });
    }

    private static void unifyVerticalLine(List<TableLine.VerticalLine> verticalLines) {
        TreeSet treeSet = new TreeSet((o1, o2) -> {
            if (Math.abs(o1 - o2) <= 5.0) {
                return 0;
            }
            if (o1 - o2 > 5.0) {
                return 1;
            }
            return -1;
        });
        verticalLines.forEach(x -> treeSet.add(x.getX()));
        verticalLines.forEach(x -> {
            double x1 = x.getX();
            for (Double d : treeSet) {
                if (!(Math.abs(d - x1) < 5.0)) continue;
                x.setX(d);
                break;
            }
        });
    }

    private static void unifyHorizonLine(List<TableLine.HorizonLine> horizonLines) {
        TreeSet treeSet = new TreeSet((o1, o2) -> {
            if (Math.abs(o1 - o2) <= 5.0) {
                return 0;
            }
            if (o1 - o2 > 5.0) {
                return 1;
            }
            return -1;
        });
        horizonLines.forEach(x -> treeSet.add(x.getY()));
        horizonLines.forEach(x -> {
            double y1 = x.getY();
            for (Double d : treeSet) {
                if (!(Math.abs(d - y1) < 5.0)) continue;
                x.setY(d);
                break;
            }
        });
    }

    public static class Cell
    implements Comparable<Cell> {
        private Double xStart;
        private Double xEnd;
        private Double yStart;
        private Double yEnd;
        private Integer colSpan;
        private Integer rowSpan;
        private Integer rowIndex;
        private Integer colIndex;
        private String cell;
        private Integer rowSpanStatus;

        public Cell(Double xStart, Double xEnd, Double yStart, Double yEnd) {
            this.xStart = xStart;
            this.xEnd = xEnd;
            this.yStart = yStart;
            this.yEnd = yEnd;
        }

        @Override
        public int compareTo(Cell o) {
            Integer rowIndex1 = this.getRowIndex();
            Integer colIndex1 = this.getColIndex();
            Integer rowIndex2 = o.getRowIndex();
            Integer colIndex2 = o.getColIndex();
            if (rowIndex1 < rowIndex2) {
                return -1;
            }
            if (rowIndex1 > rowIndex2) {
                return 1;
            }
            if (colIndex1 < colIndex2) {
                return -1;
            }
            if (colIndex1 > colIndex2) {
                return 1;
            }
            return 0;
        }

        @Generated
        public Double getXStart() {
            return this.xStart;
        }

        @Generated
        public Double getXEnd() {
            return this.xEnd;
        }

        @Generated
        public Double getYStart() {
            return this.yStart;
        }

        @Generated
        public Double getYEnd() {
            return this.yEnd;
        }

        @Generated
        public Integer getColSpan() {
            return this.colSpan;
        }

        @Generated
        public Integer getRowSpan() {
            return this.rowSpan;
        }

        @Generated
        public Integer getRowIndex() {
            return this.rowIndex;
        }

        @Generated
        public Integer getColIndex() {
            return this.colIndex;
        }

        @Generated
        public String getCell() {
            return this.cell;
        }

        @Generated
        public Integer getRowSpanStatus() {
            return this.rowSpanStatus;
        }

        @Generated
        public void setXStart(Double xStart) {
            this.xStart = xStart;
        }

        @Generated
        public void setXEnd(Double xEnd) {
            this.xEnd = xEnd;
        }

        @Generated
        public void setYStart(Double yStart) {
            this.yStart = yStart;
        }

        @Generated
        public void setYEnd(Double yEnd) {
            this.yEnd = yEnd;
        }

        @Generated
        public void setColSpan(Integer colSpan) {
            this.colSpan = colSpan;
        }

        @Generated
        public void setRowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
        }

        @Generated
        public void setRowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Generated
        public void setColIndex(Integer colIndex) {
            this.colIndex = colIndex;
        }

        @Generated
        public void setCell(String cell) {
            this.cell = cell;
        }

        @Generated
        public void setRowSpanStatus(Integer rowSpanStatus) {
            this.rowSpanStatus = rowSpanStatus;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$xStart = this.getXStart();
            Double other$xStart = other.getXStart();
            if (this$xStart == null ? other$xStart != null : !((Object)this$xStart).equals(other$xStart)) {
                return false;
            }
            Double this$xEnd = this.getXEnd();
            Double other$xEnd = other.getXEnd();
            if (this$xEnd == null ? other$xEnd != null : !((Object)this$xEnd).equals(other$xEnd)) {
                return false;
            }
            Double this$yStart = this.getYStart();
            Double other$yStart = other.getYStart();
            if (this$yStart == null ? other$yStart != null : !((Object)this$yStart).equals(other$yStart)) {
                return false;
            }
            Double this$yEnd = this.getYEnd();
            Double other$yEnd = other.getYEnd();
            if (this$yEnd == null ? other$yEnd != null : !((Object)this$yEnd).equals(other$yEnd)) {
                return false;
            }
            Integer this$colSpan = this.getColSpan();
            Integer other$colSpan = other.getColSpan();
            if (this$colSpan == null ? other$colSpan != null : !((Object)this$colSpan).equals(other$colSpan)) {
                return false;
            }
            Integer this$rowSpan = this.getRowSpan();
            Integer other$rowSpan = other.getRowSpan();
            if (this$rowSpan == null ? other$rowSpan != null : !((Object)this$rowSpan).equals(other$rowSpan)) {
                return false;
            }
            Integer this$rowIndex = this.getRowIndex();
            Integer other$rowIndex = other.getRowIndex();
            if (this$rowIndex == null ? other$rowIndex != null : !((Object)this$rowIndex).equals(other$rowIndex)) {
                return false;
            }
            Integer this$colIndex = this.getColIndex();
            Integer other$colIndex = other.getColIndex();
            if (this$colIndex == null ? other$colIndex != null : !((Object)this$colIndex).equals(other$colIndex)) {
                return false;
            }
            Integer this$rowSpanStatus = this.getRowSpanStatus();
            Integer other$rowSpanStatus = other.getRowSpanStatus();
            if (this$rowSpanStatus == null ? other$rowSpanStatus != null : !((Object)this$rowSpanStatus).equals(other$rowSpanStatus)) {
                return false;
            }
            String this$cell = this.getCell();
            String other$cell = other.getCell();
            return !(this$cell == null ? other$cell != null : !this$cell.equals(other$cell));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cell;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $xStart = this.getXStart();
            result = result * 59 + ($xStart == null ? 43 : ((Object)$xStart).hashCode());
            Double $xEnd = this.getXEnd();
            result = result * 59 + ($xEnd == null ? 43 : ((Object)$xEnd).hashCode());
            Double $yStart = this.getYStart();
            result = result * 59 + ($yStart == null ? 43 : ((Object)$yStart).hashCode());
            Double $yEnd = this.getYEnd();
            result = result * 59 + ($yEnd == null ? 43 : ((Object)$yEnd).hashCode());
            Integer $colSpan = this.getColSpan();
            result = result * 59 + ($colSpan == null ? 43 : ((Object)$colSpan).hashCode());
            Integer $rowSpan = this.getRowSpan();
            result = result * 59 + ($rowSpan == null ? 43 : ((Object)$rowSpan).hashCode());
            Integer $rowIndex = this.getRowIndex();
            result = result * 59 + ($rowIndex == null ? 43 : ((Object)$rowIndex).hashCode());
            Integer $colIndex = this.getColIndex();
            result = result * 59 + ($colIndex == null ? 43 : ((Object)$colIndex).hashCode());
            Integer $rowSpanStatus = this.getRowSpanStatus();
            result = result * 59 + ($rowSpanStatus == null ? 43 : ((Object)$rowSpanStatus).hashCode());
            String $cell = this.getCell();
            result = result * 59 + ($cell == null ? 43 : $cell.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CellAnalyser.Cell(xStart=" + this.getXStart() + ", xEnd=" + this.getXEnd() + ", yStart=" + this.getYStart() + ", yEnd=" + this.getYEnd() + ", colSpan=" + this.getColSpan() + ", rowSpan=" + this.getRowSpan() + ", rowIndex=" + this.getRowIndex() + ", colIndex=" + this.getColIndex() + ", cell=" + this.getCell() + ", rowSpanStatus=" + this.getRowSpanStatus() + ")";
        }

        @Generated
        public Cell() {
        }
    }

    public static class TableInfo {
        private Integer rowNum;
        private Integer colNum;
        private Double xStart;
        private Double yStart;
        private Double xEnd;
        private Double yEnd;
        private List<Cell> cells;

        @Generated
        public Integer getRowNum() {
            return this.rowNum;
        }

        @Generated
        public Integer getColNum() {
            return this.colNum;
        }

        @Generated
        public Double getXStart() {
            return this.xStart;
        }

        @Generated
        public Double getYStart() {
            return this.yStart;
        }

        @Generated
        public Double getXEnd() {
            return this.xEnd;
        }

        @Generated
        public Double getYEnd() {
            return this.yEnd;
        }

        @Generated
        public List<Cell> getCells() {
            return this.cells;
        }

        @Generated
        public void setRowNum(Integer rowNum) {
            this.rowNum = rowNum;
        }

        @Generated
        public void setColNum(Integer colNum) {
            this.colNum = colNum;
        }

        @Generated
        public void setXStart(Double xStart) {
            this.xStart = xStart;
        }

        @Generated
        public void setYStart(Double yStart) {
            this.yStart = yStart;
        }

        @Generated
        public void setXEnd(Double xEnd) {
            this.xEnd = xEnd;
        }

        @Generated
        public void setYEnd(Double yEnd) {
            this.yEnd = yEnd;
        }

        @Generated
        public void setCells(List<Cell> cells) {
            this.cells = cells;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableInfo)) {
                return false;
            }
            TableInfo other = (TableInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowNum = this.getRowNum();
            Integer other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                return false;
            }
            Integer this$colNum = this.getColNum();
            Integer other$colNum = other.getColNum();
            if (this$colNum == null ? other$colNum != null : !((Object)this$colNum).equals(other$colNum)) {
                return false;
            }
            Double this$xStart = this.getXStart();
            Double other$xStart = other.getXStart();
            if (this$xStart == null ? other$xStart != null : !((Object)this$xStart).equals(other$xStart)) {
                return false;
            }
            Double this$yStart = this.getYStart();
            Double other$yStart = other.getYStart();
            if (this$yStart == null ? other$yStart != null : !((Object)this$yStart).equals(other$yStart)) {
                return false;
            }
            Double this$xEnd = this.getXEnd();
            Double other$xEnd = other.getXEnd();
            if (this$xEnd == null ? other$xEnd != null : !((Object)this$xEnd).equals(other$xEnd)) {
                return false;
            }
            Double this$yEnd = this.getYEnd();
            Double other$yEnd = other.getYEnd();
            if (this$yEnd == null ? other$yEnd != null : !((Object)this$yEnd).equals(other$yEnd)) {
                return false;
            }
            List<Cell> this$cells = this.getCells();
            List<Cell> other$cells = other.getCells();
            return !(this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TableInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
            Integer $colNum = this.getColNum();
            result = result * 59 + ($colNum == null ? 43 : ((Object)$colNum).hashCode());
            Double $xStart = this.getXStart();
            result = result * 59 + ($xStart == null ? 43 : ((Object)$xStart).hashCode());
            Double $yStart = this.getYStart();
            result = result * 59 + ($yStart == null ? 43 : ((Object)$yStart).hashCode());
            Double $xEnd = this.getXEnd();
            result = result * 59 + ($xEnd == null ? 43 : ((Object)$xEnd).hashCode());
            Double $yEnd = this.getYEnd();
            result = result * 59 + ($yEnd == null ? 43 : ((Object)$yEnd).hashCode());
            List<Cell> $cells = this.getCells();
            result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CellAnalyser.TableInfo(rowNum=" + this.getRowNum() + ", colNum=" + this.getColNum() + ", xStart=" + this.getXStart() + ", yStart=" + this.getYStart() + ", xEnd=" + this.getXEnd() + ", yEnd=" + this.getYEnd() + ", cells=" + this.getCells() + ")";
        }

        @Generated
        public TableInfo() {
        }

        @Generated
        public TableInfo(Integer rowNum, Integer colNum, Double xStart, Double yStart, Double xEnd, Double yEnd, List<Cell> cells) {
            this.rowNum = rowNum;
            this.colNum = colNum;
            this.xStart = xStart;
            this.yStart = yStart;
            this.xEnd = xEnd;
            this.yEnd = yEnd;
            this.cells = cells;
        }
    }
}

