/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

public class ReadPdfUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadPdfUtil.class);
    private static final SpreadsheetExtractionAlgorithm ALGORITHM = new SpreadsheetExtractionAlgorithm();

    public static void removeTextWatermark(PDDocument pd) throws Exception {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            pdfsp.parse();
            List tokens = pdfsp.getTokens();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                countMap.put(next.toString(), countMap.getOrDefault(next.toString(), 0) + 1);
            }
        }
        ArrayList waterMarks = new ArrayList();
        for (Map.Entry entry : countMap.entrySet()) {
            waterMarks.add(entry.getKey());
        }
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            pdfsp.parse();
            List tokens = pdfsp.getTokens();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                for (String waterMark : waterMarks) {
                    if (!next.toString().equals(waterMark)) continue;
                    iterator.remove();
                }
            }
            PDStream updatedStream = new PDStream(pd);
            OutputStream out = updatedStream.createOutputStream();
            ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
            tokenWriter.writeTokens(tokens);
            out.close();
            page.setContents(updatedStream);
        }
    }

    public static void removeTextWatermark(FileBytesInfo bytesInfo) {
        try (PDDocument pd = PDDocument.load((byte[])bytesInfo.getFileBytes());
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ReadPdfUtil.removeTextWatermark(pd);
            pd.save((OutputStream)outputStream);
            bytesInfo.setFileBytes(outputStream.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkCellMap(TreeMap<Double, Double> cellMap) {
        Iterator<Map.Entry<Double, Double>> iterator = cellMap.entrySet().iterator();
        double index = 0.0;
        while (iterator.hasNext()) {
            Map.Entry<Double, Double> currentEntry = iterator.next();
            cellMap.put(currentEntry.getKey(), index);
            index += 1.0;
        }
    }

    public static void main(String[] args) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("python E:\\code\\idps\\idp_web\\idp-common\\src\\main\\resources\\test.py D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee\\1.ZF3G24020003\u4e2d\u6807\u901a\u77e5\u4e66.pdf D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee");
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            int exitCode = process.waitFor();
            System.out.println("\nPython script exited with error code: " + exitCode);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

