/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

@Component
@Service
public class ReadPdfUtil {
    private static final SpreadsheetExtractionAlgorithm ALGORITHM = new SpreadsheetExtractionAlgorithm();

    public static void removeTextWatermark(PDDocument pd) throws Exception {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            List tokens = pdfsp.parse();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                countMap.put(next.toString(), countMap.getOrDefault(next.toString(), 0) + 1);
            }
        }
        ArrayList waterMarks = new ArrayList();
        for (Map.Entry entry : countMap.entrySet()) {
            waterMarks.add(entry.getKey());
        }
        for (PDPage page : pd.getPages()) {
            PDFStreamParser pdfsp = new PDFStreamParser((PDContentStream)page);
            List tokens = pdfsp.parse();
            Iterator iterator = tokens.iterator();
            boolean find = false;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next instanceof Operator) {
                    Operator op = (Operator)next;
                    find = op.getName().equals("Tm");
                    continue;
                }
                if (!find || !(next instanceof COSString)) continue;
                for (String waterMark : waterMarks) {
                    if (!next.toString().equals(waterMark)) continue;
                    iterator.remove();
                }
            }
            PDStream updatedStream = new PDStream(pd);
            OutputStream out = updatedStream.createOutputStream();
            ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
            tokenWriter.writeTokens(tokens);
            out.close();
            page.setContents(updatedStream);
        }
    }

    private static void checkCellMap(TreeMap<Double, Double> cellMap) {
        Iterator<Map.Entry<Double, Double>> iterator = cellMap.entrySet().iterator();
        double index = 0.0;
        while (iterator.hasNext()) {
            Map.Entry<Double, Double> currentEntry = iterator.next();
            cellMap.put(currentEntry.getKey(), index);
            index += 1.0;
        }
    }

    public static void main(String[] args) throws Exception {
        PDDocument pdDocument = Loader.loadPDF((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24040003\u68c0\u5316\u9a8c\u667a\u80fd\u5316\u63d0\u5347\u9879\u76ee\u53d6\u5236\u6837\u63d0\u5347\u90e8\u5206\\1.ZF3G24040003\u4e2d\u6807\u901a\u77e5\u4e66.pdf"));
        ReadPdfUtil.removeTextWatermark(pdDocument);
        pdDocument.save("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24040003\u68c0\u5316\u9a8c\u667a\u80fd\u5316\u63d0\u5347\u9879\u76ee\u53d6\u5236\u6837\u63d0\u5347\u90e8\u5206\\1.ZF3G24040003\u4e2d\u6807\u901a\u77e5\u4e66-\u65e0\u6c34\u5370\u7248.pdf");
    }
}

