/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum DocRegularEnum {
    CATALOG0("catalog", "\u0013.*?TOC.*?\u0014(\u76ee\u5f55)"),
    CATALOG1("catalog", "(\u76ee\u5f55)\u0013.*?TOC.*?\u0014"),
    CATALOG2("catalog", ".*?\u0013 HYPERLINK.*?\u0014(.*?)\u0013 PAGEREF.*\u0014(.*?)\u0015\u0015");

    private final String type;
    private final String regular;

    private DocRegularEnum(String type, String regular) {
        this.type = type;
        this.regular = regular;
    }

    private static List<String> getRegulars() {
        ArrayList<String> regulars = new ArrayList<String>();
        for (DocRegularEnum regularEnum : DocRegularEnum.values()) {
            regulars.add(regularEnum.regular);
        }
        return regulars;
    }

    public static String matchCatalog(String text) {
        List<String> regulars = DocRegularEnum.getRegulars();
        for (String regular : regulars) {
            Pattern pattern = Pattern.compile(regular);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            StringBuilder temp = new StringBuilder();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                temp.append(matcher.group(i));
                if (i >= matcher.groupCount()) continue;
                temp.append("...........................");
            }
            text = temp.toString();
            break;
        }
        return text;
    }
}

