/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.enums.doc;

import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ContentDisposition;

public enum AcceptFileType {
    DOC("application/msword", "doc", true),
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx", true),
    XLS("application/vnd.ms-excel", "xls", true),
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx", false),
    PDF("application/pdf", "pdf", false),
    JPG("image/jpeg", "jpg", false),
    PNG("image/png", "png", false),
    WPS("application/vnd.ms-works", "wps", true);

    private final String contentType;
    private final String type;
    private final Boolean convertFlag;

    public String getContentType() {
        return this.contentType;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getConvertFlag() {
        return this.convertFlag;
    }

    private AcceptFileType(String contentType, String type, Boolean convertFlag) {
        this.contentType = contentType;
        this.type = type;
        this.convertFlag = convertFlag;
    }

    public static AcceptFileType getAcceptFileType(String contentType, ContentDisposition contentDisposition) {
        String fileName;
        AcceptFileType result = null;
        for (AcceptFileType acceptFileType : AcceptFileType.values()) {
            if (!acceptFileType.getContentType().equals(contentType)) continue;
            result = acceptFileType;
            break;
        }
        if (result == null && contentDisposition != null && (fileName = contentDisposition.getFilename()) != null) {
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            for (AcceptFileType acceptFileType : AcceptFileType.values()) {
                if (!acceptFileType.getType().equalsIgnoreCase(suffix)) continue;
                result = acceptFileType;
                break;
            }
        }
        return result;
    }

    public static AcceptFileType getAcceptFileType(String contentType) {
        AcceptFileType result = null;
        for (AcceptFileType acceptFileType : AcceptFileType.values()) {
            if (!acceptFileType.getType().equals(contentType)) continue;
            result = acceptFileType;
            break;
        }
        return result;
    }

    public static List<String> getFileTypeList() {
        ArrayList<String> fileTypeList = new ArrayList<String>();
        for (AcceptFileType acceptFileType : AcceptFileType.values()) {
            fileTypeList.add(acceptFileType.getType());
        }
        return fileTypeList;
    }
}

