/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.common.entity.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class TreeUtil {
    public static <T extends TreeNode<T>> List<T> getTree(List<T> nodes) {
        HashMap<Long, List> parentIdChildMap = new HashMap<Long, List>();
        Stack<TreeNode> stack = new Stack<TreeNode>();
        ArrayList<TreeNode> roots = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            if (node.getParentId() == null) {
                stack.push(node);
                roots.add(node);
                continue;
            }
            List childList = parentIdChildMap.computeIfAbsent(node.getParentId(), k -> new ArrayList());
            childList.add(node);
        }
        while (!stack.isEmpty()) {
            TreeNode parent = (TreeNode)stack.pop();
            List children = (List)parentIdChildMap.get(parent.getId());
            parent.setChildren(children);
            if (!CollUtil.isNotEmpty((Collection)children)) continue;
            for (TreeNode child : children) {
                stack.push(child);
            }
        }
        return roots;
    }

    public static <T extends TreeNode<T>> List<T> getTree(List<T> nodes, List<T> roots) {
        HashMap<Long, List> parentIdChildMap = new HashMap<Long, List>();
        for (TreeNode node : nodes) {
            Long parentId = node.getParentId();
            List childList = parentIdChildMap.computeIfAbsent(parentId, k -> new ArrayList());
            childList.add(node);
        }
        Stack<TreeNode> stack = new Stack<TreeNode>();
        roots.forEach(stack::push);
        while (!stack.isEmpty()) {
            TreeNode parent = (TreeNode)stack.pop();
            List children = (List)parentIdChildMap.get(parent.getId());
            parent.setChildren(children);
            if (!CollectionUtil.isNotEmpty((Collection)children)) continue;
            for (TreeNode child : children) {
                stack.push(child);
            }
        }
        return roots;
    }
}

