/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.entity.util.wordpicture;

import com.jxdinfo.idp.common.util.uuid.IdUtils;
import fr.opensagres.poi.xwpf.converter.core.ImageManager;
import java.io.File;
import javax.imageio.stream.FileImageOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class ImageManagerImpl
extends ImageManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageManagerImpl.class);
    private String suffix;
    private String urlPrefix;
    private String newDirName = IdUtils.simpleUUID();

    public ImageManagerImpl(String urlPrefix) {
        super(null, "img");
        this.urlPrefix = urlPrefix;
    }

    public void extract(String imagePath, byte[] imageData) {
        String path = ResourceUtils.getURL((String)"classpath:").getPath() + "static/img/" + this.newDirName + "/";
        String[] imgTypeUri = imagePath.split("/");
        this.suffix = IdUtils.simpleUUID() + imgTypeUri[imgTypeUri.length - 1];
        try {
            File imgFile = new File(path + this.suffix);
            if (!imgFile.getParentFile().exists()) {
                imgFile.getParentFile().mkdirs();
            }
            try (FileImageOutputStream outputStream = new FileImageOutputStream(imgFile);){
                outputStream.write(imageData, 0, imageData.length);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25", (Object)e.getMessage());
        }
    }

    public String resolve(String uri) {
        return "dir=" + this.newDirName + ";fileName=" + this.suffix;
    }

    public String getImgDirName() {
        return this.newDirName;
    }
}

