/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ClassTypeUtil {
    public static Class<?> getInterfaceT(Object o, int index) {
        Type[] types = o.getClass().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)types[index];
        Type type = parameterizedType.getActualTypeArguments()[index];
        return ClassTypeUtil.checkType(type, index);
    }

    public static Class<?> getClassT(Object o, int index) {
        Type type = o.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type actType = parameterizedType.getActualTypeArguments()[index];
            return ClassTypeUtil.checkType(actType, index);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, but <" + type + "> is of type " + className);
    }

    private static Class<?> checkType(Type type, int index) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type t = pt.getActualTypeArguments()[index];
            return ClassTypeUtil.checkType(t, index);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, but <" + type + "> is of type " + className);
    }
}

