/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.file;

import com.jxdinfo.idp.common.enums.doc.AcceptFileType;
import com.jxdinfo.idp.common.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static void createFilePath(File file) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        catch (IOException e) {
            throw new BusinessException("\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84\u521b\u5efa\u5931\u8d25", e);
        }
    }

    public static void createFoldPath(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void deleteFile(List<String> filePath) {
        for (String path : filePath) {
            File file = new File(path);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    public static String getDocFormat(File file) {
        String format = "";
        Path path = Paths.get(file.getPath(), new String[0]);
        try {
            String mimeType = Files.probeContentType(path);
            if (AcceptFileType.DOC.getContentType().equals(mimeType)) {
                format = AcceptFileType.DOC.getType();
            } else if (AcceptFileType.DOCX.getContentType().equals(mimeType)) {
                format = AcceptFileType.DOCX.getType();
            } else if (AcceptFileType.PDF.getContentType().equals(mimeType)) {
                format = AcceptFileType.PDF.getType();
            } else if (AcceptFileType.XLS.getContentType().equals(mimeType)) {
                format = AcceptFileType.XLS.getType();
            } else if (AcceptFileType.XLSX.getContentType().equals(mimeType)) {
                format = AcceptFileType.XLSX.getType();
            } else if (AcceptFileType.JPG.getContentType().equals(mimeType)) {
                format = AcceptFileType.JPG.getType();
            } else if (AcceptFileType.PNG.getContentType().equals(mimeType)) {
                format = AcceptFileType.PNG.getType();
            }
        }
        catch (IOException e) {
            throw new BusinessException("\u6587\u4ef6\u771f\u5b9e\u683c\u5f0f\u83b7\u53d6\u5f02\u5e38", e);
        }
        return format;
    }

    public static String createRandomFileName(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            String suffix = fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
            String random = UUID.randomUUID().toString().replace("-", "");
            return random + suffix;
        }
        return fileName;
    }

    public static String getSuffix(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
        }
        return fileName;
    }

    public static String getNoPointSuffix(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        }
        return fileName;
    }

    public static String getNoSuffixOfFileName(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    public static void transferToFile(File inputFile, File outputFile) {
        try (FileInputStream fis = new FileInputStream(inputFile.getAbsoluteFile());
             FileOutputStream fos = new FileOutputStream(outputFile);){
            FileChannel sourceChannel = fis.getChannel();
            FileChannel destinationChannel = fos.getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
            log.info("FileUpload :" + inputFile.getName());
        }
        catch (IOException e) {
            log.info("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", e);
        }
    }

    public static String getMD5(String path) {
        BigInteger bi = null;
        try {
            byte[] buffer = new byte[8192];
            int len = 0;
            MessageDigest md = MessageDigest.getInstance("MD5");
            File f = new File(path);
            FileInputStream fis = new FileInputStream(f);
            while ((len = fis.read(buffer)) != -1) {
                md.update(buffer, 0, len);
            }
            fis.close();
            byte[] b = md.digest();
            bi = new BigInteger(1, b);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        assert (bi != null);
        return bi.toString(16);
    }

    public static String checkFileValidity(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return "\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        return null;
    }

    public static void deleteDirectoryBatch(List<String> path) {
        for (String path1 : path) {
            FileUtil.deleteDirectory(new File(path1));
        }
    }

    public static boolean deleteDirectory(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDirectory(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }
}

