/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.loadprop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import lombok.Generated;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class YamlPropertySourceFactory
implements PropertySourceFactory {
    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        String sourceName;
        Properties propertiesFromYaml = this.loadYamlIntoProperties(resource);
        String string = sourceName = name != null ? name : resource.getResource().getFilename();
        assert (sourceName != null);
        return new PropertiesPropertySource(sourceName, propertiesFromYaml);
    }

    private Properties loadYamlIntoProperties(EncodedResource resource) throws FileNotFoundException {
        try {
            YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
            factory.setResources(new Resource[]{resource.getResource()});
            factory.afterPropertiesSet();
            return factory.getObject();
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Generated
    public YamlPropertySourceFactory() {
    }
}

