/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.counter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.counter.mapper.CounterMapper;
import com.jxdinfo.idp.common.counter.service.ICounterService;
import com.jxdinfo.idp.common.entity.Counter;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import org.springframework.stereotype.Service;

@Service
public class CounterServiceImpl
extends ServiceImpl<CounterMapper, Counter>
implements ICounterService {
    @Override
    public void add(Long objId, Long relId, String objType, String relType) {
        Counter counter = (Counter)this.getOne(this.wrapper(objId, relId, objType, relType));
        if (counter != null) {
            counter.setAmount(counter.getAmount() + 1);
            this.updateById(counter);
        } else {
            counter = new Counter(objId, relId, objType, relType);
            counter.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            this.save(counter);
        }
    }

    @Override
    public void subtract(Long objId, Long relId, String objType, String relType) {
        Counter counter = (Counter)this.getOne(this.wrapper(objId, relId, objType, relType));
        if (counter != null) {
            int amount = counter.getAmount() - 1;
            if (amount == 0) {
                this.removeById(counter);
            } else {
                counter.setAmount(amount);
                this.updateById(counter);
            }
        }
    }

    private Wrapper<Counter> wrapper(Long objId, Long relId, String objType, String relType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Counter::getObjId, (Object)objId);
        wrapper.eq(Counter::getRelId, (Object)relId);
        wrapper.eq(Counter::getObjType, (Object)objType);
        wrapper.eq(Counter::getRelType, (Object)relType);
        return wrapper;
    }
}

