/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.docparse.excel;

import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.excel.XlsxStructureUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelStructureUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelStructureUtil.class);

    public abstract ExcelInfo getExcelInfo(InputStream var1);

    protected ExcelInfo excelInfo(Workbook wk) {
        ExcelInfo excelInfo = new ExcelInfo();
        excelInfo.setSheetInfos(new ArrayList<ExcelSheetInfo>());
        int sheetIndex = 0;
        for (Sheet sheet : wk) {
            ExcelSheetInfo sheetInfo = new ExcelSheetInfo();
            excelInfo.getSheetInfos().add(sheetInfo);
            sheetInfo.setIndex(sheetIndex++);
            sheetInfo.setName(sheet.getSheetName());
            sheetInfo.setCellArray2D(this.getCellArray2D(sheet));
        }
        return excelInfo;
    }

    private ExcelCellInfo[][] getCellArray2D(Sheet sheet) {
        ExcelCellInfo[][] cell2dArray = new ExcelCellInfo[sheet.getLastRowNum() + 1][];
        for (Row row : sheet) {
            int rowNum = row.getRowNum();
            short lastCellNum = row.getLastCellNum();
            if (lastCellNum == -1) continue;
            cell2dArray[rowNum] = new ExcelCellInfo[lastCellNum + 1];
            for (Cell cell : row) {
                ExcelCellInfo cellInfo = new ExcelCellInfo();
                this.getCellValue(cellInfo, cell, sheet.getWorkbook());
                cell2dArray[rowNum][cell.getColumnIndex()] = cellInfo;
            }
        }
        return cell2dArray;
    }

    private Object getCellValue(Cell cell, Workbook wk) {
        try {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return cell.getDateCellValue();
                    }
                    DataFormatter formatter = new DataFormatter();
                    FormulaEvaluator evaluator = wk.getCreationHelper().createFormulaEvaluator();
                    try {
                        return Double.parseDouble(formatter.formatCellValue(cell, evaluator));
                    }
                    catch (NumberFormatException e) {
                        return formatter.formatCellValue(cell, evaluator);
                    }
                }
                case STRING: {
                    return cell.getStringCellValue();
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case FORMULA: {
                    FormulaEvaluator evaluator = wk.getCreationHelper().createFormulaEvaluator();
                    return this.getFormulaCellValue(evaluator, cell);
                }
                case ERROR: {
                    return Byte.toString(cell.getErrorCellValue());
                }
            }
            return cell.toString();
        }
        catch (Exception e) {
            log.error("\u5355\u5143\u683c\u503c\u63d0\u53d6\u5f02\u5e38\uff01", (Throwable)e);
            return cell.toString();
        }
    }

    private void getCellValue(ExcelCellInfo cellInfo, Cell cell, Workbook wk) {
        try {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    DataFormatter formatter = new DataFormatter(Locale.CHINA);
                    String valueStr = formatter.formatCellValue(cell);
                    cellInfo.setValueStr(valueStr);
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellInfo.setValue(cell.getDateCellValue());
                        break;
                    }
                    try {
                        cellInfo.setValue(new BigDecimal(valueStr));
                    }
                    catch (NumberFormatException e) {
                        cellInfo.setValue(valueStr);
                    }
                    break;
                }
                case STRING: {
                    cellInfo.setValue(cell.getStringCellValue());
                    cellInfo.setValueStr(cell.getStringCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellInfo.setValue(cell.getBooleanCellValue());
                    cellInfo.setValueStr(String.valueOf(cell.getBooleanCellValue()));
                    break;
                }
                case FORMULA: {
                    FormulaEvaluator evaluator = wk.getCreationHelper().createFormulaEvaluator();
                    Object value = this.getFormulaCellValue(evaluator, cell);
                    cellInfo.setValue(value);
                    cellInfo.setValueStr(value.toString());
                    break;
                }
                case ERROR: {
                    byte errorCellValue = cell.getErrorCellValue();
                    cellInfo.setValue(errorCellValue);
                    cellInfo.setValueStr(Byte.toString(errorCellValue));
                    break;
                }
                default: {
                    cellInfo.setValue(cell.toString());
                    cellInfo.setValueStr(cell.toString());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5355\u5143\u683c\u503c\u63d0\u53d6\u5f02\u5e38\uff01", (Throwable)e);
            cellInfo.setValue(cell.toString());
            cellInfo.setValueStr(cell.toString());
        }
    }

    private Object getFormulaCellValue(FormulaEvaluator evaluator, Cell cell) {
        CellValue evaluate = evaluator.evaluate(cell);
        switch (evaluate.getCellType()) {
            case NUMERIC: {
                DataFormatter formatter = new DataFormatter(Locale.CHINA);
                try {
                    return new BigDecimal(formatter.formatCellValue(cell, evaluator));
                }
                catch (NumberFormatException e) {
                    return formatter.formatCellValue(cell);
                }
            }
            case STRING: {
                return evaluate.getStringValue();
            }
            case BOOLEAN: {
                return evaluate.getBooleanValue();
            }
            case ERROR: {
                return Byte.toString(evaluate.getErrorValue());
            }
        }
        return evaluate.toString();
    }

    private void mergeCell(Workbook workbook, ExcelInfo excelInfo) {
    }

    public static void main(String[] args) throws FileNotFoundException {
        XlsxStructureUtil util = new XlsxStructureUtil();
        FileInputStream inputStream = new FileInputStream("C:\\Users\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\1.5\\\u6d4b\u8bd5\u6587\u4ef6\\bug\u4fee\u6539\\excel\\202011\u5229\u6da6.xlsx");
        ExcelInfo excelInfo = ((ExcelStructureUtil)util).getExcelInfo(inputStream);
        System.out.println("end");
    }
}

