/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ColorUtil {
    private static String FONT_IMAGE_BASE_PATH;
    public static List<String> RED_COLORS;
    public static List<String> BLUE_COLORS;
    public static List<String> YELLOW_COLORS;
    public static List<String> GREEN_COLORS;
    public static String s;

    public static void createImage(String str, String imgName) throws Exception {
        ColorUtil.createImage(str, new Font("\u5b8b\u4f53", 1, 40), new File(FONT_IMAGE_BASE_PATH + imgName));
    }

    public static void createImage(String str, File outFile) throws Exception {
        ColorUtil.createImage(str, new Font("\u5b8b\u4f53", 1, 40), outFile);
    }

    public static void createImage(String str, Font font, File outFile) throws Exception {
        ArrayList<int[]> rgbs = ColorUtil.getRGB();
        int width = 120;
        int height = 120;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(new Color(rgbs.get(0)[0], rgbs.get(0)[1], rgbs.get(0)[2]));
        g.fillRect(0, 0, width, height);
        g.setColor(new Color(rgbs.get(1)[0], rgbs.get(1)[1], rgbs.get(1)[2]));
        g.setFont(font);
        g.drawString(str, 60, 60);
        g.dispose();
        ImageIO.write((RenderedImage)image, "png", outFile);
    }

    private static ArrayList<int[]> getRGB() {
        ArrayList<int[]> colorList = new ArrayList<int[]>();
        int[] rgb = ColorUtil.getRanRGB();
        while (true) {
            if (ColorUtil.isDarkRGB(rgb)) break;
            rgb = ColorUtil.getRanRGB();
        }
        colorList.add(rgb);
        int[] rgbQ = ColorUtil.getRanRGB();
        while (ColorUtil.isDarkRGB(rgbQ)) {
            rgbQ = ColorUtil.getRanRGB();
        }
        colorList.add(rgbQ);
        return colorList;
    }

    public static int[] getRanRGB() {
        int[] colors = new int[3];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = (int)(Math.random() * 256.0);
        }
        return colors;
    }

    public static String getRanHex() {
        int[] colors = ColorUtil.getRanRGB();
        return ColorUtil.ConvertRGBToHex(colors[0], colors[1], colors[2]);
    }

    public static boolean isDarkRGB(int[] colors) {
        int grayLevel = (int)((double)colors[0] * 0.299 + (double)colors[1] * 0.587 + (double)colors[2] * 0.114);
        return grayLevel >= 192;
    }

    public static boolean isDarkHex(String hex) {
        int[] colors = ColorUtil.ConvertHexToRGB(hex);
        int grayLevel = (int)((double)colors[0] * 0.299 + (double)colors[1] * 0.587 + (double)colors[2] * 0.114);
        return grayLevel >= 192;
    }

    public static String ConvertRGBToHex(int r, int g, int b) {
        String hex = "";
        if (r >= 0 && r < 256 && g >= 0 && g < 256 && b >= 0 && b < 256) {
            int x = r % 16;
            r = (r - x) / 16;
            int y = g % 16;
            g = (g - y) / 16;
            int z = b % 16;
            b = (b - z) / 16;
            hex = "#" + s.substring(r, r + 1) + s.substring(x, x + 1) + s.substring(g, g + 1) + s.substring(y, y + 1) + s.substring(b, b + 1) + s.substring(z, z + 1);
        }
        return hex;
    }

    public static int[] ConvertHexToRGB(String hex) {
        int[] rgb = new int[3];
        String regex = "^[0-9A-F]{3}|[0-9A-F]{6}$";
        if (hex != null) {
            if ((hex = hex.toUpperCase()).substring(0, 1).equals("#")) {
                hex = hex.substring(1);
            }
            if (Pattern.compile(regex).matcher(hex).matches()) {
                String[] str = new String[3];
                for (int i = 0; i < 3; ++i) {
                    String a = hex.length() == 6 ? hex.substring(i * 2, i * 2 + 2) : hex.substring(i, i + 1) + hex.substring(i, i + 1);
                    String c = a.substring(0, 1);
                    String d = a.substring(1, 2);
                    str[i] = String.valueOf(s.indexOf(c) * 16 + s.indexOf(d));
                }
                rgb[0] = Integer.valueOf(str[0]);
                rgb[1] = Integer.valueOf(str[1]);
                rgb[2] = Integer.valueOf(str[2]);
            }
        }
        return rgb;
    }

    public static String getDarkColor(String hex) {
        int[] rgb = ColorUtil.ConvertHexToRGB(hex);
        double red = rgb[0];
        double green = rgb[1];
        double blue = rgb[2];
        String maxColor = "red";
        if (green >= red && green >= blue) {
            maxColor = "green";
        } else if (blue >= red && blue >= green) {
            maxColor = "blue";
        }
        double decrease = 40.0;
        switch (maxColor) {
            case "red": {
                red -= decrease;
            }
            case "green": {
                green -= decrease;
            }
            case "blue": {
                blue -= decrease;
            }
        }
        if (red < 0.0) {
            red = 0.0;
        }
        if (green < 0.0) {
            green = 0.0;
        }
        if (blue < 0.0) {
            blue = 0.0;
        }
        return ColorUtil.ConvertRGBToHex((int)red, (int)green, (int)blue);
    }

    public static List<String> getColors(String colorType) {
        switch (colorType) {
            case "red": {
                return new ArrayList<String>(RED_COLORS);
            }
            case "blue": {
                return new ArrayList<String>(BLUE_COLORS);
            }
            case "yellow": {
                return new ArrayList<String>(YELLOW_COLORS);
            }
            case "green": {
                return new ArrayList<String>(GREEN_COLORS);
            }
        }
        ArrayList<String> colorList = new ArrayList<String>();
        colorList.addAll(RED_COLORS);
        colorList.addAll(BLUE_COLORS);
        colorList.addAll(YELLOW_COLORS);
        colorList.addAll(GREEN_COLORS);
        return colorList;
    }

    static {
        RED_COLORS = Arrays.asList("#AA9BEC", "#9254DE", "#D3ADF7", "#F888B9", "#F89588");
        BLUE_COLORS = Arrays.asList("#3AC6FF", "#2794F8", "#6495CA", "#85A5FF", "#3661EE");
        YELLOW_COLORS = Arrays.asList("#D4A082", "#FD6B08", "#FF9F0D", "#FEB62C", "#EDD443", "#BFDB58");
        GREEN_COLORS = Arrays.asList("#47DB5F", "#41CC8B", "#36CFC9", "#65DEDE");
        s = "0123456789ABCDEF";
    }
}

