/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.bidreview.enums;

import com.jxdinfo.idp.bidreview.enums.AgentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum AgentParamKey {
    QIANFAN_ACCESS_TOKEN("qianfan_access_Token", "\u5343\u5e06 Access Token", AgentType.QIANFAN, true),
    QIANFAN_ANALYSIS("qianfan_analysis", "\u5343\u5e06 - \u6587\u4ef6\u89e3\u6790 App ID", AgentType.QIANFAN, true),
    QIANFAN_RULE("qianfan_rule", "\u5343\u5e06 - \u5ba1\u67e5\u89c4\u5219\u751f\u6210 App ID", AgentType.QIANFAN, true),
    QIANFAN_URL_RUN("qianfan_url_run", "\u5343\u5e06\u8fd0\u884c\u5730\u5740", AgentType.QIANFAN, true),
    QIANFAN_URL_UPLOAD_FILE("qianfan_url_upload_file", "\u5343\u5e06\u4e0a\u4f20\u6587\u4ef6\u5730\u5740", AgentType.QIANFAN, false),
    DIFY_ANALYSIS("dify_analysis", "Dify - \u6587\u4ef6\u89e3\u6790\u5bc6\u94a5", AgentType.DIFY, true),
    DIFY_RULE("dify_rule", "Dify - \u5ba1\u67e5\u89c4\u5219\u751f\u6210\u5bc6\u94a5", AgentType.DIFY, true),
    DIFY_URL_RUN("dify_url_run", "Dify \u8fd0\u884c\u5730\u5740", AgentType.DIFY, true),
    DIFY_URL_UPLOAD_FILE("dify_url_upload_file", "Dify \u4e0a\u4f20\u6587\u4ef6\u5730\u5740", AgentType.DIFY, false);

    private final String key;
    private final String description;
    private final AgentType agentType;
    private final Boolean isReturn;

    private AgentParamKey(String key, String description, AgentType agentType, Boolean isReturn) {
        this.key = key;
        this.description = description;
        this.agentType = agentType;
        this.isReturn = isReturn;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public AgentType getAgentType() {
        return this.agentType;
    }

    public String toString() {
        return this.key;
    }

    public static List<AgentParamKey> getParamsByAgentType(AgentType type) {
        return Arrays.stream(AgentParamKey.values()).filter(param -> param.getAgentType() == type && param.getReturn() != false).collect(Collectors.toList());
    }

    public static List<String> toKeyList(AgentType type) {
        List<AgentParamKey> paramKeys = AgentParamKey.getParamsByAgentType(type);
        if (paramKeys == null) {
            return new ArrayList<String>();
        }
        return paramKeys.stream().map(AgentParamKey::getKey).collect(Collectors.toList());
    }

    public Boolean getReturn() {
        return this.isReturn;
    }
}

