/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.bidreview.enums;

import java.util.Arrays;

public enum AgentType {
    QIANFAN("qianfan", "\u767e\u5ea6\u5343\u5e06"),
    DIFY("dify", "Dify AI");

    private final String code;
    private final String description;

    private AgentType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static AgentType of(String code) {
        if (code == null) {
            return null;
        }
        String trimmedCode = code.trim();
        if (trimmedCode.isEmpty()) {
            return null;
        }
        for (AgentType type : AgentType.values()) {
            if (!type.code.equalsIgnoreCase(trimmedCode)) continue;
            return type;
        }
        return null;
    }

    public static AgentType requireValid(String code) {
        AgentType type = AgentType.of(code);
        if (type == null) {
            String available = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(AgentType.values()).map(AgentType::getCode).toArray(String[]::new));
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u667a\u80fd\u4f53\u7c7b\u578b: '" + (code == null ? "null" : code.trim()) + "'\uff0c\u652f\u6301\u7684\u7c7b\u578b\u6709: [" + available + "]");
        }
        return type;
    }
}

